"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const eui_1 = require("@elastic/eui");
const react_1 = require("@kbn/i18n/react");
const moment_timezone_1 = tslib_1.__importDefault(require("moment-timezone"));
const react_2 = tslib_1.__importDefault(require("react"));
const styled_components_1 = tslib_1.__importDefault(require("styled-components"));
const range_date_picker_1 = require("../range_date_picker");
class MetricsTimeControls extends react_2.default.Component {
    constructor() {
        super(...arguments);
        this.dateRangeRef = react_2.default.createRef();
        this.state = {
            showGoButton: false,
            to: moment_timezone_1.default().millisecond(this.props.currentTimeRange.to),
            from: moment_timezone_1.default().millisecond(this.props.currentTimeRange.from),
            recentlyUsed: [],
        };
        this.handleChangeDate = (from, to, search) => {
            const { onChangeRangeTime } = this.props;
            const duration = moment_timezone_1.default.duration(from && to ? from.diff(to) : 0);
            const milliseconds = duration.asMilliseconds();
            if (to && from && onChangeRangeTime && search && to > from) {
                this.setState({
                    showGoButton: false,
                    to,
                    from,
                });
                onChangeRangeTime({
                    to: to && to.valueOf(),
                    from: from && from.valueOf(),
                });
            }
            else if (milliseconds !== 0) {
                this.setState({
                    showGoButton: true,
                    to,
                    from,
                });
            }
        };
        this.searchRangeTime = () => {
            const { onChangeRangeTime } = this.props;
            const { to, from, recentlyUsed } = this.state;
            if (to && from && onChangeRangeTime && to > from) {
                this.setState({
                    ...this.state,
                    showGoButton: false,
                    recentlyUsed: [
                        ...recentlyUsed,
                        ...[
                            {
                                type: 'date-range',
                                text: [from.format('L LTS'), to.format('L LTS')],
                            },
                        ],
                    ],
                });
                onChangeRangeTime({
                    to: to.valueOf(),
                    from: from.valueOf(),
                });
            }
        };
        this.startLiveStreaming = () => {
            const { startLiveStreaming } = this.props;
            if (startLiveStreaming) {
                startLiveStreaming();
            }
        };
        this.stopLiveStreaming = () => {
            const { stopLiveStreaming } = this.props;
            if (stopLiveStreaming) {
                stopLiveStreaming();
            }
        };
        this.cancelSearch = () => {
            const { onChangeRangeTime } = this.props;
            const to = moment_timezone_1.default(this.props.currentTimeRange.to);
            const from = moment_timezone_1.default(this.props.currentTimeRange.from);
            this.setState({
                ...this.state,
                showGoButton: false,
                to,
                from,
            });
            this.dateRangeRef.current.resetRangeDate(from, to);
            if (onChangeRangeTime) {
                onChangeRangeTime({
                    to: to && to.valueOf(),
                    from: from && from.valueOf(),
                });
            }
        };
        this.resetSearch = () => {
            const { onChangeRangeTime } = this.props;
            const to = moment_timezone_1.default();
            const from = moment_timezone_1.default().subtract(1, 'hour');
            if (onChangeRangeTime) {
                onChangeRangeTime({
                    to: to.valueOf(),
                    from: from.valueOf(),
                });
            }
        };
    }
    render() {
        const { currentTimeRange, isLiveStreaming } = this.props;
        const { showGoButton, to, from, recentlyUsed } = this.state;
        const liveStreamingButton = (react_2.default.createElement(eui_1.EuiFlexGroup, { gutterSize: "s", justifyContent: "flexStart" },
            react_2.default.createElement(eui_1.EuiFlexItem, { grow: false }, isLiveStreaming ? (react_2.default.createElement(eui_1.EuiButton, { color: "primary", iconSide: "left", iconType: "pause", onClick: this.stopLiveStreaming },
                react_2.default.createElement(react_1.FormattedMessage, { id: "xpack.infra.metricsTimeControls.stopRefreshingButtonLabel", defaultMessage: "Stop refreshing" }))) : (react_2.default.createElement(eui_1.EuiButton, { iconSide: "left", iconType: "play", onClick: this.startLiveStreaming },
                react_2.default.createElement(react_1.FormattedMessage, { id: "xpack.infra.metricsTimeControls.autoRefreshButtonLabel", defaultMessage: "Auto-refresh" })))),
            react_2.default.createElement(eui_1.EuiFlexItem, { grow: false },
                react_2.default.createElement(eui_1.EuiButtonEmpty, { onClick: this.resetSearch },
                    react_2.default.createElement(react_1.FormattedMessage, { id: "xpack.infra.metricsTimeControls.resetButtonLabel", defaultMessage: "Reset" })))));
        const goColor = from && to && from > to ? 'danger' : 'primary';
        const appendButton = showGoButton ? (react_2.default.createElement(eui_1.EuiFlexGroup, { gutterSize: "s", justifyContent: "flexStart" },
            react_2.default.createElement(eui_1.EuiFlexItem, { grow: false },
                react_2.default.createElement(eui_1.EuiButton, { color: goColor, fill: true, onClick: this.searchRangeTime },
                    react_2.default.createElement(react_1.FormattedMessage, { id: "xpack.infra.metricsTimeControls.goButtonLabel", defaultMessage: "Go" }))),
            react_2.default.createElement(eui_1.EuiFlexItem, { grow: false },
                react_2.default.createElement(eui_1.EuiButtonEmpty, { onClick: this.cancelSearch },
                    react_2.default.createElement(react_1.FormattedMessage, { id: "xpack.infra.metricsTimeControls.cancelButtonLabel", defaultMessage: "Cancel" }))))) : (liveStreamingButton);
        return (react_2.default.createElement(MetricsTimeControlsContainer, null,
            react_2.default.createElement(range_date_picker_1.RangeDatePicker, { key: `${currentTimeRange.from}-${currentTimeRange.to}`, startDate: moment_timezone_1.default(currentTimeRange.from), endDate: moment_timezone_1.default(currentTimeRange.to), onChangeRangeTime: this.handleChangeDate, isLoading: isLiveStreaming, disabled: isLiveStreaming, recentlyUsed: recentlyUsed, ref: this.dateRangeRef }),
            appendButton));
    }
}
exports.MetricsTimeControls = MetricsTimeControls;
const MetricsTimeControlsContainer = styled_components_1.default.div `
  display: flex;
  justify-content: right;
  flex-flow: row wrap;
  & > div:first-child {
    margin-right: 0.5rem;
  }
`;
