"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const react_1 = require("@kbn/i18n/react");
const React = tslib_1.__importStar(require("react"));
const handlers_1 = require("../../../utils/handlers");
const empty_states_1 = require("../../empty_states");
const loading_1 = require("../../loading");
const item_1 = require("./item");
const item_view_1 = require("./item_view");
const loading_item_view_1 = require("./loading_item_view");
const measurable_item_view_1 = require("./measurable_item_view");
const vertical_scroll_panel_1 = require("./vertical_scroll_panel");
class ScrollableLogTextStreamViewClass extends React.PureComponent {
    constructor() {
        super(...arguments);
        this.state = {
            target: null,
            targetId: null,
        };
        this.handleOpenFlyout = (id) => {
            this.props.setFlyoutItem(id);
            this.props.showFlyout();
        };
        this.handleReload = () => {
            const { jumpToTarget, target } = this.props;
            if (target) {
                jumpToTarget(target);
            }
        };
        this.handleLoadNewerItems = () => {
            const { loadNewerItems } = this.props;
            if (loadNewerItems) {
                loadNewerItems();
            }
        };
        // this is actually a method but not recognized as such
        // tslint:disable-next-line:member-ordering
        this.handleVisibleChildrenChange = handlers_1.callWithoutRepeats(({ topChild, middleChild, bottomChild, pagesAbove, pagesBelow, }) => {
            this.props.reportVisibleInterval({
                endKey: item_1.parseStreamItemId(bottomChild),
                middleKey: item_1.parseStreamItemId(middleChild),
                pagesAfterEnd: pagesBelow,
                pagesBeforeStart: pagesAbove,
                startKey: item_1.parseStreamItemId(topChild),
            });
        });
    }
    static getDerivedStateFromProps(nextProps, prevState) {
        const hasNewTarget = nextProps.target && nextProps.target !== prevState.target;
        const hasItems = nextProps.items.length > 0;
        if (nextProps.isStreaming && hasItems) {
            return {
                target: nextProps.target,
                targetId: item_1.getStreamItemId(nextProps.items[nextProps.items.length - 1]),
            };
        }
        else if (hasNewTarget && hasItems) {
            return {
                target: nextProps.target,
                targetId: item_1.getStreamItemId(item_1.getStreamItemBeforeTimeKey(nextProps.items, nextProps.target)),
            };
        }
        else if (!nextProps.target || !hasItems) {
            return {
                target: null,
                targetId: null,
            };
        }
        return null;
    }
    render() {
        const { items, height, width, scale, wrap, isReloading, isLoadingMore, hasMoreBeforeStart, hasMoreAfterEnd, isStreaming, lastLoadedTime, intl, } = this.props;
        const { targetId } = this.state;
        const hasItems = items.length > 0;
        if (isReloading && !hasItems) {
            return (React.createElement(loading_1.InfraLoadingPanel, { height: height, width: width, text: React.createElement(react_1.FormattedMessage, { id: "xpack.infra.logs.scrollableLogTextStreamView.loadingEntriesLabel", defaultMessage: "Loading entries" }) }));
        }
        else if (!hasItems) {
            return (React.createElement(empty_states_1.NoData, { titleText: intl.formatMessage({
                    id: 'xpack.infra.logs.emptyView.noLogMessageTitle',
                    defaultMessage: 'There are no log messages to display.',
                }), bodyText: intl.formatMessage({
                    id: 'xpack.infra.logs.emptyView.noLogMessageDescription',
                    defaultMessage: 'Try adjusting your filter.',
                }), refetchText: intl.formatMessage({
                    id: 'xpack.infra.logs.emptyView.checkForNewDataButtonLabel',
                    defaultMessage: 'Check for new data',
                }), onRefetch: this.handleReload, testString: "logsNoDataPrompt" }));
        }
        else {
            return (React.createElement(vertical_scroll_panel_1.VerticalScrollPanel, { height: height, width: width, onVisibleChildrenChange: this.handleVisibleChildrenChange, target: targetId, hideScrollbar: true }, registerChild => (React.createElement(React.Fragment, null,
                React.createElement(loading_item_view_1.LogTextStreamLoadingItemView, { alignment: "bottom", isLoading: isLoadingMore, hasMore: hasMoreBeforeStart, isStreaming: false, lastStreamingUpdate: null }),
                items.map(item => (React.createElement(measurable_item_view_1.MeasurableItemView, { register: registerChild, registrationKey: item_1.getStreamItemId(item), key: item_1.getStreamItemId(item) }, measureRef => (React.createElement(item_view_1.LogTextStreamItemView, { openFlyoutWithItem: this.handleOpenFlyout, ref: measureRef, item: item, scale: scale, wrap: wrap }))))),
                React.createElement(loading_item_view_1.LogTextStreamLoadingItemView, { alignment: "top", isLoading: isStreaming || isLoadingMore, hasMore: hasMoreAfterEnd, isStreaming: isStreaming, lastStreamingUpdate: isStreaming ? lastLoadedTime : null, onLoadMore: this.handleLoadNewerItems })))));
        }
    }
}
exports.ScrollableLogTextStreamView = react_1.injectI18n(ScrollableLogTextStreamViewClass);
