"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const eui_1 = require("@elastic/eui");
const react_1 = require("@kbn/i18n/react");
const React = tslib_1.__importStar(require("react"));
const styled_components_1 = tslib_1.__importDefault(require("styled-components"));
const relative_time_1 = require("./relative_time");
class LogTextStreamLoadingItemView extends React.PureComponent {
    render() {
        const { alignment, className, hasMore, isLoading, isStreaming, lastStreamingUpdate, onLoadMore, } = this.props;
        if (isStreaming) {
            return (React.createElement(ProgressEntry, { alignment: alignment, className: className, color: "primary", isLoading: true },
                React.createElement(ProgressMessage, null,
                    React.createElement(eui_1.EuiText, { color: "subdued" },
                        React.createElement(react_1.FormattedMessage, { id: "xpack.infra.logs.streamingNewEntriesText", defaultMessage: "Streaming new entries" }))),
                lastStreamingUpdate ? (React.createElement(ProgressMessage, null,
                    React.createElement(eui_1.EuiText, { color: "subdued" },
                        React.createElement(eui_1.EuiIcon, { type: "clock" }),
                        React.createElement(react_1.FormattedMessage, { id: "xpack.infra.logs.lastStreamingUpdateText", defaultMessage: " last updated {lastUpdateTime} ago", values: {
                                lastUpdateTime: (React.createElement(relative_time_1.RelativeTime, { time: lastStreamingUpdate, refreshInterval: 1000 })),
                            } })))) : null));
        }
        else if (isLoading) {
            return (React.createElement(ProgressEntry, { alignment: alignment, className: className, color: "subdued", isLoading: true },
                React.createElement(ProgressMessage, null,
                    React.createElement(react_1.FormattedMessage, { id: "xpack.infra.logs.loadingAdditionalEntriesText", defaultMessage: "Loading additional entries" }))));
        }
        else if (!hasMore) {
            return (React.createElement(ProgressEntry, { alignment: alignment, className: className, color: "subdued", isLoading: false },
                React.createElement(ProgressMessage, null,
                    React.createElement(react_1.FormattedMessage, { id: "xpack.infra.logs.noAdditionalEntriesFoundText", defaultMessage: "No additional entries found" })),
                onLoadMore ? (React.createElement(eui_1.EuiButtonEmpty, { size: "xs", onClick: onLoadMore, iconType: "refresh" },
                    React.createElement(react_1.FormattedMessage, { id: "xpack.infra.logs.loadAgainButtonLabel", defaultMessage: "Load again" }))) : null));
        }
        else {
            return null;
        }
    }
}
exports.LogTextStreamLoadingItemView = LogTextStreamLoadingItemView;
// tslint:disable-next-line:max-classes-per-file
class ProgressEntry extends React.PureComponent {
    render() {
        const { alignment, children, className, color, isLoading } = this.props;
        return (React.createElement(ProgressEntryWrapper, { className: className },
            React.createElement(AlignedProgress, { alignment: alignment, color: color, max: isLoading ? undefined : 1, size: "xs", value: isLoading ? undefined : 1, position: "absolute" }),
            children));
    }
}
const ProgressEntryWrapper = styled_components_1.default.div `
  align-items: center;
  display: flex;
  min-height: ${props => props.theme.eui.euiSizeXxl};
  position: relative;
`;
const ProgressMessage = styled_components_1.default.div `
  padding: 8px 16px;
`;
const AlignedProgress = styled_components_1.default(eui_1.EuiProgress).attrs({}) `
  top: ${props => (props.alignment === 'top' ? 0 : 'initial')};
  bottom: ${props => (props.alignment === 'top' ? 'initial' : 0)};
`;
