"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const React = tslib_1.__importStar(require("react"));
const log_entry_item_view_1 = require("./log_entry_item_view");
exports.LogTextStreamItemView = React.forwardRef(({ item, scale, wrap, openFlyoutWithItem }, ref) => {
    switch (item.kind) {
        case 'logEntry':
            return (React.createElement(log_entry_item_view_1.LogTextStreamLogEntryItemView, { boundingBoxRef: ref, logEntry: item.logEntry, searchResult: item.searchResult, scale: scale, wrap: wrap, openFlyoutWithItem: openFlyoutWithItem }));
    }
});
