"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const polished_1 = require("polished");
const React = tslib_1.__importStar(require("react"));
const styled_components_1 = tslib_1.__importStar(require("styled-components"));
const styles_1 = require("../../../utils/styles");
const item_field_1 = require("./item_field");
class LogTextStreamItemMessageField extends React.PureComponent {
    render() {
        const { children, highlights, isHovered, isWrapped, scale } = this.props;
        const hasHighlights = highlights.length > 0;
        const content = hasHighlights ? renderHighlightFragments(children, highlights) : children;
        return (React.createElement(LogTextStreamItemMessageFieldWrapper, { hasHighlights: hasHighlights, isHovered: isHovered, isWrapped: isWrapped, scale: scale }, content));
    }
}
exports.LogTextStreamItemMessageField = LogTextStreamItemMessageField;
const renderHighlightFragments = (text, highlights) => {
    const renderedHighlights = highlights.reduce(({ lastFragmentEnd, renderedFragments }, highlight) => {
        const fragmentStart = text.indexOf(highlight, lastFragmentEnd);
        return {
            lastFragmentEnd: fragmentStart + highlight.length,
            renderedFragments: [
                ...renderedFragments,
                text.slice(lastFragmentEnd, fragmentStart),
                React.createElement(HighlightSpan, { key: fragmentStart }, highlight),
            ],
        };
    }, {
        lastFragmentEnd: 0,
        renderedFragments: [],
    });
    return [...renderedHighlights.renderedFragments, text.slice(renderedHighlights.lastFragmentEnd)];
};
const highlightedFieldStyle = styled_components_1.css `
  background-color: ${props => styles_1.tintOrShade(props.theme.eui.euiTextColor, props.theme.eui.euiColorSecondary, 0.15)};
`;
const hoveredFieldStyle = styled_components_1.css `
  background-color: ${props => props.theme.darkMode
    ? polished_1.transparentize(0.9, polished_1.darken(0.05, props.theme.eui.euiColorHighlight))
    : polished_1.darken(0.05, props.theme.eui.euiColorHighlight)};
`;
const wrappedFieldStyle = styled_components_1.css `
  overflow: visible;
  white-space: pre-wrap;
  word-break: break-all;
`;
const unwrappedFieldStyle = styled_components_1.css `
  overflow: hidden;
  white-space: pre;
`;
const LogTextStreamItemMessageFieldWrapper = item_field_1.LogTextStreamItemField.extend.attrs({}) `
  flex-grow: 1;
  text-overflow: ellipsis;
  background-color: ${props => props.theme.eui.euiColorEmptyShade};

  ${props => (props.hasHighlights ? highlightedFieldStyle : '')};
  ${props => (props.isHovered ? hoveredFieldStyle : '')};
  ${props => (props.isWrapped ? wrappedFieldStyle : unwrappedFieldStyle)};
`;
const HighlightSpan = styled_components_1.default.span `
  display: inline-block;
  background-color: ${props => props.theme.eui.euiColorSecondary};
  color: ${props => props.theme.eui.euiColorGhost};
  font-weight: ${props => props.theme.eui.euiFontWeightMedium};
`;
