"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const styled_components_1 = tslib_1.__importDefault(require("styled-components"));
const styles_1 = require("../../../utils/styles");
exports.LogTextStreamItemField = styled_components_1.default.div.attrs({}) `
  font-size: ${props => styles_1.switchProp('scale', {
    large: props.theme.eui.euiFontSizeM,
    medium: props.theme.eui.euiFontSizeS,
    small: props.theme.eui.euiFontSizeXs,
    [styles_1.switchProp.default]: props.theme.eui.euiFontSize,
})};
  line-height: ${props => props.theme.eui.euiLineHeight};
  padding: 2px ${props => props.theme.eui.euiSize} 2px 0;
`;
