"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const eui_1 = require("@elastic/eui");
const react_1 = require("@kbn/i18n/react");
const react_2 = tslib_1.__importDefault(require("react"));
const styled_components_1 = tslib_1.__importDefault(require("styled-components"));
exports.InfraHeaderFeedbackLink = ({ url }) => (react_2.default.createElement(VerticallyCenteredHeaderSection, { side: "right" },
    react_2.default.createElement(eui_1.EuiLink, { href: url, target: "_blank", rel: "noopener" },
        react_2.default.createElement(react_1.FormattedMessage, { id: "xpack.infra.headerFeedbackLink.feedbackText", defaultMessage: "Feedback" }))));
const VerticallyCenteredHeaderSection = styled_components_1.default(eui_1.EuiHeaderSection) `
  padding-left: ${props => props.theme.eui.euiSizeS};
  padding-right: ${props => props.theme.eui.euiSizeS};
  align-items: center;
`;
