"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const react_1 = tslib_1.__importDefault(require("react"));
const with_kibana_chrome_1 = require("../../containers/with_kibana_chrome");
const external_header_1 = require("./external_header");
const legacy_header_1 = require("./legacy_header");
exports.Header = ({ appendSections, breadcrumbs = [] }) => {
    return (react_1.default.createElement(with_kibana_chrome_1.WithKibanaChrome, null, ({ setBreadcrumbs, uiSettings: { k7Design } }) => k7Design ? (react_1.default.createElement(external_header_1.ExternalHeader, { breadcrumbs: breadcrumbs, setBreadcrumbs: setBreadcrumbs })) : (react_1.default.createElement(legacy_header_1.LegacyHeader, { appendSections: appendSections, breadcrumbs: breadcrumbs }))));
};
