"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const eui_1 = require("@elastic/eui");
const react_1 = require("@kbn/i18n/react");
const react_2 = tslib_1.__importDefault(require("react"));
const styled_components_1 = tslib_1.__importDefault(require("styled-components"));
exports.BetaBadgeHeaderSection = ({ tooltipContent = (react_2.default.createElement(react_1.FormattedMessage, { id: "xpack.infra.betaBadgeHeaderSection.betaBadgeHeaderSectionDefaultTooltip", defaultMessage: "Please help us improve by reporting issues or bugs in the Kibana repo." })), }) => (react_2.default.createElement(VerticallyCenteredHeaderSection, { side: "right" },
    react_2.default.createElement(eui_1.EuiBetaBadge, { label: react_2.default.createElement(react_1.FormattedMessage, { id: "xpack.infra.betaBadgeHeaderSection.betaLabel", defaultMessage: "Beta" }), tooltipContent: tooltipContent })));
exports.InfrastructureBetaBadgeHeaderSection = () => (react_2.default.createElement(exports.BetaBadgeHeaderSection, { tooltipContent: react_2.default.createElement(react_1.FormattedMessage, { id: "xpack.infra.betaBadgeHeaderSection.infrastructureUiIsStillInBetaTooltip", defaultMessage: "The Infrastructure UI is still in beta. Please help us improve by reporting issues or bugs in the Kibana repo." }) }));
exports.LogsBetaBadgeHeaderSection = () => (react_2.default.createElement(exports.BetaBadgeHeaderSection, { tooltipContent: react_2.default.createElement(react_1.FormattedMessage, { id: "xpack.infra.betaBadgeHeaderSection.logsUiIsStillInBetaTooltip", defaultMessage: "The Logs UI is still in beta. Please help us improve by reporting issues or bugs in the Kibana repo." }) }));
const VerticallyCenteredHeaderSection = styled_components_1.default(eui_1.EuiHeaderSection) `
  padding-left: ${props => props.theme.eui.euiSizeS};
  padding-right: ${props => props.theme.eui.euiSizeS};
  align-items: center;
`;
