"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const log_entry_1 = require("./log_entry");
function getIndexNearLogEntry(logEntries, key, highest = false) {
    let minIndex = 0;
    let maxIndex = logEntries.length;
    let currentIndex;
    let currentKey;
    while (minIndex < maxIndex) {
        currentIndex = (minIndex + maxIndex) >>> 1; // tslint:disable-line:no-bitwise
        currentKey = log_entry_1.getLogEntryKey(logEntries[currentIndex]);
        if ((highest ? log_entry_1.isLessOrEqual : log_entry_1.isLess)(currentKey, key)) {
            minIndex = currentIndex + 1;
        }
        else {
            maxIndex = currentIndex;
        }
    }
    return maxIndex;
}
exports.getIndexNearLogEntry = getIndexNearLogEntry;
function getIndexOfLogEntry(logEntries, key) {
    const index = getIndexNearLogEntry(logEntries, key);
    const logEntry = logEntries[index];
    return logEntry && log_entry_1.isEqual(key, log_entry_1.getLogEntryKey(logEntry)) ? index : null;
}
exports.getIndexOfLogEntry = getIndexOfLogEntry;
