'use strict';

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var options = {};

function getSelections(ast) {
  if (ast && ast.selectionSet && ast.selectionSet.selections && ast.selectionSet.selections.length) {
    return ast.selectionSet.selections;
  }

  return [];
}

function isFragment(ast) {
  return ast.kind === 'InlineFragment' || ast.kind === 'FragmentSpread';
}

function getAST(ast, info) {
  if (ast.kind === 'FragmentSpread') {
    var fragmentName = ast.name.value;
    return info.fragments[fragmentName];
  }

  return ast;
}

function getArguments(ast) {
  return ast.arguments.map(function (argument) {
    return _defineProperty({}, argument.name.value, {
      kind: argument.value.kind,
      value: argument.value.value
    });
  });
}

function flattenAST(ast, info, obj) {
  obj = obj || {};
  return getSelections(ast).reduce(function (flattened, a) {
    if (isFragment(a)) {
      flattened = flattenAST(getAST(a, info), info, flattened);
    } else {
      var name = a.name.value;

      if (flattened[name] && flattened[name] !== '__arguments') {
        _extends(flattened[name], flattenAST(a, info, flattened[name]));
      } else {
        flattened[name] = flattenAST(a, info);
      }

      if (options.processArguments) {
        // check if the current field has arguments
        if (a.arguments && a.arguments.length) {
          _extends(flattened[name], {
            __arguments: getArguments(a)
          });
        }
      }
    }

    return flattened;
  }, obj);
}

module.exports = function graphqlFields(info) {
  var obj = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var opts = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {
    processArguments: false
  };
  var fields = info.fieldNodes || info.fieldASTs;
  options.processArguments = opts.processArguments;
  return fields.reduce(function (o, ast) {
    return flattenAST(ast, info, o);
  }, obj) || {};
};