"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = y[op[0] & 2 ? "return" : op[0] ? "throw" : "next"]) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [0, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var _this = this;
Object.defineProperty(exports, "__esModule", { value: true });
var Boom = require("boom");
var GraphiQL = require("apollo-server-module-graphiql");
var apollo_server_core_1 = require("apollo-server-core");
var graphqlHapi = {
    name: 'graphql',
    register: function (server, options) {
        if (!options || !options.graphqlOptions) {
            throw new Error('Apollo Server requires options.');
        }
        server.route({
            method: ['GET', 'POST'],
            path: options.path || '/graphql',
            vhost: options.vhost || undefined,
            config: options.route || {},
            handler: function (request, h) { return __awaiter(_this, void 0, void 0, function () {
                var gqlResponse, response, error_1, response, err_1;
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            _a.trys.push([0, 2, , 3]);
                            return [4, apollo_server_core_1.runHttpQuery([request], {
                                    method: request.method.toUpperCase(),
                                    options: options.graphqlOptions,
                                    query: request.method === 'post' ? request.payload : request.query,
                                })];
                        case 1:
                            gqlResponse = _a.sent();
                            response = h.response(gqlResponse);
                            response.type('application/json');
                            return [2, response];
                        case 2:
                            error_1 = _a.sent();
                            if ('HttpQueryError' !== error_1.name) {
                                throw Boom.boomify(error_1);
                            }
                            if (true === error_1.isGraphQLError) {
                                response = h.response(error_1.message);
                                response.code(error_1.statusCode);
                                response.type('application/json');
                                return [2, response];
                            }
                            err_1 = new Boom(error_1.message, { statusCode: error_1.statusCode });
                            if (error_1.headers) {
                                Object.keys(error_1.headers).forEach(function (header) {
                                    err_1.output.headers[header] = error_1.headers[header];
                                });
                            }
                            err_1.output.payload.message = error_1.message;
                            throw err_1;
                        case 3: return [2];
                    }
                });
            }); },
        });
    },
};
exports.graphqlHapi = graphqlHapi;
var graphiqlHapi = {
    name: 'graphiql',
    register: function (server, options) {
        if (!options || !options.graphiqlOptions) {
            throw new Error('Apollo Server GraphiQL requires options.');
        }
        server.route({
            method: 'GET',
            path: options.path || '/graphiql',
            config: options.route || {},
            handler: function (request, h) { return __awaiter(_this, void 0, void 0, function () {
                var graphiqlString, response;
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0: return [4, GraphiQL.resolveGraphiQLString(request.query, options.graphiqlOptions, request)];
                        case 1:
                            graphiqlString = _a.sent();
                            response = h.response(graphiqlString);
                            response.type('text/html');
                            return [2, response];
                    }
                });
            }); },
        });
    },
};
exports.graphiqlHapi = graphiqlHapi;
//# sourceMappingURL=hapiApollo.js.map