'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends2 = require('babel-runtime/helpers/extends');

var _extends3 = _interopRequireDefault(_extends2);

exports.Fn = Fn;

var _lodash = require('lodash');

var _arg = require('./arg');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

function Fn(config) {
  var _this = this;

  // Required
  this.name = config.name; // Name of function

  // Return type of function.
  // This SHOULD be supplied. We use it for UI and autocomplete hinting,
  // We may also use it for optimizations in the future.
  this.type = config.type;
  this.aliases = config.aliases || [];

  // Function to run function (context, args)
  this.fn = function () {
    return Promise.resolve(config.fn.apply(config, arguments));
  };

  // Optional
  this.help = config.help || ''; // A short help text
  this.args = (0, _lodash.mapValues)(config.args || {}, function (arg, name) {
    return new _arg.Arg((0, _extends3.default)({ name: name }, arg));
  });

  this.context = config.context || {};

  this.accepts = function (type) {
    if (!_this.context.types) return true; // If you don't tell us about context, we'll assume you don't care what you get
    return (0, _lodash.includes)(_this.context.types, type); // Otherwise, check it
  };
}