/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.managers;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ls.core.internal.AbstractProjectImporter;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;

public class InvisibleProjectImporter
extends AbstractProjectImporter {
    @Override
    public boolean applies(IProgressMonitor monitor) throws OperationCanceledException, CoreException {
        IPath rootPath;
        IPath workspaceLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        if (workspaceLocation.equals((Object)(rootPath = ResourceUtils.filePathFromURI(this.rootFolder.toPath().toUri().toString())))) {
            return false;
        }
        return ProjectUtils.getVisibleProjects(rootPath).isEmpty();
    }

    @Override
    public void importToWorkspace(IProgressMonitor monitor) throws OperationCanceledException, CoreException {
        IPath sourcePath;
        PreferenceManager preferencesManager = JavaLanguageServerPlugin.getPreferencesManager();
        if (preferencesManager == null || preferencesManager.getPreferences() == null) {
            return;
        }
        Collection<IPath> triggerFiles = preferencesManager.getPreferences().getTriggerFiles();
        if (triggerFiles == null || triggerFiles.isEmpty()) {
            return;
        }
        IPath rootPath = ResourceUtils.filePathFromURI(this.rootFolder.toPath().toUri().toString());
        Optional<IPath> triggerJavaFile = triggerFiles.stream().filter(triggerFile -> rootPath.isPrefixOf(triggerFile)).findFirst();
        if (!triggerJavaFile.isPresent()) {
            return;
        }
        String packageName = this.getPackageName(triggerJavaFile.get(), rootPath);
        IPath sourceDirectory = this.inferSourceDirectory(triggerJavaFile.get().toFile().toPath(), packageName);
        if (sourceDirectory == null || !rootPath.isPrefixOf(sourceDirectory)) {
            return;
        }
        String invisibleProjectName = ProjectUtils.getWorkspaceInvisibleProjectName(rootPath);
        IProject invisibleProject = ResourcesPlugin.getWorkspace().getRoot().getProject(invisibleProjectName);
        Path libFolder = new Path("lib");
        IFolder workspaceLinkFolder = invisibleProject.getFolder("_");
        IPath relativeSourcePath = sourceDirectory.makeRelativeTo(rootPath);
        IPath iPath = sourcePath = relativeSourcePath.isEmpty() ? workspaceLinkFolder.getFullPath() : workspaceLinkFolder.getFolder(relativeSourcePath).getFullPath();
        if (!invisibleProject.exists()) {
            try {
                JavaLanguageServerPlugin.logInfo("Try to create an invisible project for the workspace " + rootPath);
                invisibleProject = ProjectUtils.createInvisibleProjectIfNotExist(rootPath);
                List<IProject> subProjects = ProjectUtils.getVisibleProjects(rootPath);
                List<IPath> subProjectPaths = subProjects.stream().map(project -> {
                    IPath relativePath = project.getLocation().makeRelativeTo(rootPath);
                    return workspaceLinkFolder.getFolder(relativePath).getFullPath();
                }).collect(Collectors.toList());
                subProjectPaths.add((IPath)libFolder);
                IJavaProject javaProject = JavaCore.create((IProject)invisibleProject);
                ProjectUtils.addSourcePath(sourcePath, subProjectPaths.toArray(new IPath[0]), javaProject);
                JavaLanguageServerPlugin.logInfo("Successfully created a workspace invisible project " + invisibleProjectName);
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException("Failed to create the invisible project.", e);
                return;
            }
        }
        IJavaProject javaProject = JavaCore.create((IProject)invisibleProject);
        ProjectUtils.updateBinaries(javaProject, rootPath.append((IPath)libFolder), monitor);
    }

    @Override
    public void reset() {
    }

    private String getPackageName(IPath javaFile, IPath workspaceRoot) {
        IProject project = JavaLanguageServerPlugin.getProjectsManager().getDefaultProject();
        if (project == null || !project.isAccessible()) {
            return "";
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        return InvisibleProjectImporter.getPackageName(javaFile, workspaceRoot, javaProject);
    }

    public static String getPackageName(IPath javaFile, IPath workspaceRoot, IJavaProject javaProject) {
        File nioFile = javaFile.toFile();
        try {
            String content = com.google.common.io.Files.toString((File)nioFile, (Charset)StandardCharsets.UTF_8);
            if (StringUtils.isBlank((CharSequence)content)) {
                File found = InvisibleProjectImporter.findNearbyNonEmptyFile(nioFile);
                if (found == null) {
                    return InvisibleProjectImporter.inferPackageNameFromPath(javaFile, workspaceRoot);
                }
                nioFile = found;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return JDTUtils.getPackageName(javaProject, nioFile.toURI());
    }

    private static File findNearbyNonEmptyFile(File nioFile) throws IOException {
        java.nio.file.Path directory = nioFile.getParentFile().toPath();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Stream<java.nio.file.Path> walk = Files.walk(directory, 1, new FileVisitOption[0]);){
                Optional<java.nio.file.Path> found = walk.filter(path -> Files.isRegularFile(path, new LinkOption[0])).filter(file2 -> {
                    try {
                        return file2.toString().endsWith(".java") && !Objects.equals(nioFile.getName(), file2.toFile().getName()) && Files.size(file2) > 0L;
                    }
                    catch (IOException e) {
                        return false;
                    }
                }).findFirst();
                if (found.isPresent()) {
                    return found.get().toFile();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private static String inferPackageNameFromPath(IPath javaFile, IPath workspaceRoot) {
        IPath parentPath = javaFile.removeTrailingSeparator().removeLastSegments(1);
        List<String> segments = Arrays.asList(parentPath.segments());
        int index = segments.lastIndexOf("src");
        if (index > -1) {
            return String.join((CharSequence)".", segments.subList(index + 1, segments.size()));
        }
        IPath relativePath = parentPath.makeRelativeTo(workspaceRoot);
        return String.join((CharSequence)".", relativePath.segments());
    }

    private IPath inferSourceDirectory(java.nio.file.Path filePath, String packageName) {
        String packagePath = packageName.replace(".", "/");
        java.nio.file.Path sourcePath = filePath.getParent();
        if (StringUtils.isBlank((CharSequence)packagePath)) {
            return ResourceUtils.filePathFromURI(sourcePath.toUri().toString());
        }
        if (sourcePath.endsWith(Paths.get(packagePath, new String[0]))) {
            int packageCount = packageName.split("\\.").length;
            while (packageCount > 0) {
                sourcePath = sourcePath.getParent();
                --packageCount;
            }
            return ResourceUtils.filePathFromURI(sourcePath.toUri().toString());
        }
        return null;
    }
}

