/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.managers;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.ls.core.internal.managers.ProjectsManager;

public interface IBuildSupport {
    public boolean applies(IProject var1);

    public boolean isBuildFile(IResource var1);

    default public void update(IProject resource, boolean force, IProgressMonitor monitor) throws CoreException {
    }

    default public void update(IProject resource, IProgressMonitor monitor) throws CoreException {
        this.update(resource, false, monitor);
    }

    default public boolean fileChanged(IResource resource, ProjectsManager.CHANGE_TYPE changeType, IProgressMonitor monitor) throws CoreException {
        this.refresh(resource, changeType, monitor);
        return false;
    }

    default public void refresh(IResource resource, ProjectsManager.CHANGE_TYPE changeType, IProgressMonitor monitor) throws CoreException {
        if (resource == null) {
            return;
        }
        if (changeType == ProjectsManager.CHANGE_TYPE.DELETED) {
            resource = resource.getParent();
        }
        if (resource != null) {
            resource.refreshLocal(2, monitor);
        }
    }

    default public void discoverSource(IClassFile classFile, IProgressMonitor monitor) throws CoreException {
    }
}

