/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.javadoc;

import com.overzealous.remark.Options;
import com.overzealous.remark.Remark;
import java.io.Reader;
import java.lang.reflect.Field;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.javadoc.AbstractJavaDocConverter;
import org.jsoup.safety.Cleaner;
import org.jsoup.safety.Whitelist;

public class JavaDoc2MarkdownConverter
extends AbstractJavaDocConverter {
    private static Remark remark;

    static {
        Options options = new Options();
        options.tables = Options.Tables.CONVERT_TO_CODE_BLOCK;
        options.hardwraps = true;
        options.inlineLinks = true;
        options.autoLinks = true;
        options.reverseHtmlSmartPunctuation = true;
        remark = new Remark(options);
        try {
            Field cleanerField = Remark.class.getDeclaredField("cleaner");
            cleanerField.setAccessible(true);
            Cleaner c = (Cleaner)cleanerField.get(remark);
            Field whitelistField = Cleaner.class.getDeclaredField("whitelist");
            whitelistField.setAccessible(true);
            Whitelist w = (Whitelist)whitelistField.get(c);
            w.addProtocols("a", "href", new String[]{"file", "jdt"});
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            JavaLanguageServerPlugin.logException("Unable to modify jsoup to include file and jdt protocols", e);
        }
    }

    public JavaDoc2MarkdownConverter(Reader reader) {
        super(reader);
    }

    public JavaDoc2MarkdownConverter(String javadoc) {
        super(javadoc);
    }

    @Override
    String convert(String rawHtml) {
        return remark.convert(rawHtml);
    }
}

