/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.managers.ProjectsManager;
import org.eclipse.lsp4j.DidChangeWorkspaceFoldersParams;
import org.eclipse.lsp4j.WorkspaceFolder;

public class WorkspaceFolderChangeHandler {
    private ProjectsManager projectManager;

    WorkspaceFolderChangeHandler(ProjectsManager projectManager) {
        this.projectManager = projectManager;
    }

    public void update(DidChangeWorkspaceFoldersParams params) {
        IPath rootPath;
        ArrayList<IPath> addedRootPaths = new ArrayList<IPath>();
        ArrayList<IPath> removedRootPaths = new ArrayList<IPath>();
        for (WorkspaceFolder folder : params.getEvent().getAdded()) {
            rootPath = ResourceUtils.canonicalFilePathFromURI(folder.getUri());
            if (rootPath == null) continue;
            addedRootPaths.add(rootPath);
        }
        for (WorkspaceFolder folder : params.getEvent().getRemoved()) {
            rootPath = ResourceUtils.canonicalFilePathFromURI(folder.getUri());
            if (rootPath == null) continue;
            removedRootPaths.add(rootPath);
        }
        this.projectManager.updateWorkspaceFolders(addedRootPaths, removedRootPaths);
    }
}

