/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.internal.jobs.JobMessages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.ProgressProvider;
import org.eclipse.jdt.ls.core.internal.CancellableProgressMonitor;
import org.eclipse.jdt.ls.core.internal.JavaClientConnection;
import org.eclipse.jdt.ls.core.internal.ProgressReport;
import org.eclipse.jdt.ls.core.internal.ServiceStatus;
import org.eclipse.jdt.ls.core.internal.StatusReport;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class ProgressReporterManager
extends ProgressProvider {
    private JavaClientConnection.JavaLanguageClient client;
    private long delay;
    private PreferenceManager preferenceManager;

    public ProgressReporterManager(JavaClientConnection.JavaLanguageClient client, PreferenceManager preferenceManager) {
        this.client = client;
        this.preferenceManager = preferenceManager;
        this.delay = 200L;
    }

    public IProgressMonitor createMonitor(Job job) {
        if (job.belongsTo((Object)"java-ls-initialization-jobs")) {
            return new ServerStatusMonitor();
        }
        IProgressMonitor monitor = this.createJobMonitor(job);
        return monitor;
    }

    private IProgressMonitor createJobMonitor(Job job) {
        return new ProgressReporter(job);
    }

    public IProgressMonitor getDefaultMonitor() {
        return new ProgressReporter();
    }

    public IProgressMonitor getProgressReporter(CancelChecker checker) {
        return new ProgressReporter(checker);
    }

    public IProgressMonitor createProgressGroup() {
        return this.getDefaultMonitor();
    }

    public void setReportThrottle(long delay) {
        this.delay = delay;
    }

    private class ProgressReporter
    extends CancellableProgressMonitor {
        protected Job job;
        protected int totalWork;
        protected String taskName;
        protected String subTaskName;
        protected int progress;
        protected long lastReport;
        protected String progressId;

        public ProgressReporter() {
            super(null);
            this.lastReport = 0L;
            this.progressId = UUID.randomUUID().toString();
        }

        public ProgressReporter(Job job) {
            this();
            this.job = job;
        }

        public ProgressReporter(CancelChecker checker) {
            super(checker);
            this.lastReport = 0L;
        }

        public void setTaskName(String name) {
            super.setTaskName(name);
            this.taskName = name;
        }

        public void beginTask(String task, int totalWork) {
            this.taskName = task;
            this.totalWork = totalWork;
            this.sendProgress();
        }

        public void subTask(String name) {
            this.subTaskName = name;
            this.sendProgress();
        }

        public void worked(int work) {
            this.progress += work;
            this.sendProgress();
        }

        @Override
        public void done() {
            super.done();
            this.sendProgress();
        }

        @Override
        public boolean isDone() {
            return super.isDone() || this.totalWork > 0 && this.progress >= this.totalWork;
        }

        private void sendProgress() {
            if (this.job != null && this.job.isSystem() || JobMessages.jobs_blocked0.equals(this.taskName)) {
                return;
            }
            long currentTime = System.currentTimeMillis();
            if (this.lastReport == 0L || this.isDone() || currentTime - this.lastReport >= ProgressReporterManager.this.delay) {
                this.lastReport = currentTime;
                this.sendStatus();
            }
        }

        protected void sendStatus() {
            if (ProgressReporterManager.this.client == null || ProgressReporterManager.this.preferenceManager == null || ProgressReporterManager.this.preferenceManager.getClientPreferences() == null || !ProgressReporterManager.this.preferenceManager.getClientPreferences().isProgressReportSupported()) {
                return;
            }
            ProgressReport progressReport = new ProgressReport(this.progressId);
            String task = (String)StringUtils.defaultIfBlank((CharSequence)this.taskName, (CharSequence)(this.job == null || StringUtils.isBlank((CharSequence)this.job.getName()) ? "Background task" : this.job.getName()));
            progressReport.setTask(task);
            progressReport.setSubTask(this.subTaskName);
            progressReport.setTotalWork(this.totalWork);
            progressReport.setWorkDone(this.progress);
            progressReport.setComplete(this.isDone());
            String subTask = this.subTaskName == null ? "" : " - " + this.subTaskName;
            progressReport.setStatus(this.formatMessage(String.valueOf(task) + subTask));
            ProgressReporterManager.this.client.sendProgressReport(progressReport);
        }

        protected String formatMessage(String task) {
            return this.totalWork > 0 ? String.format("%s - %.0f%%", task, (double)this.progress / (double)this.totalWork * 100.0) : task;
        }
    }

    private class ServerStatusMonitor
    extends ProgressReporter {
        private ServerStatusMonitor() {
        }

        @Override
        protected String formatMessage(String task) {
            String message;
            String string = message = this.taskName == null || this.taskName.length() == 0 ? "" : "- " + this.taskName;
            if (task != null && task.length() > 0) {
                message = String.valueOf(message) + " - " + task;
            }
            return String.format("%.0f%% Starting Java Language Server %s", (double)this.progress / (double)this.totalWork * 100.0, message);
        }

        @Override
        protected void sendStatus() {
            if (ProgressReporterManager.this.client == null) {
                return;
            }
            String message = this.formatMessage(this.subTaskName);
            ProgressReporterManager.this.client.sendStatusReport(new StatusReport().withType(ServiceStatus.Starting.name()).withMessage(message));
        }
    }
}

