/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Optional;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.corext.codemanipulation.AddCustomConstructorOperation;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility2Core;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.handlers.JdtDomModels;
import org.eclipse.jdt.ls.core.internal.preferences.Preferences;
import org.eclipse.jdt.ls.core.internal.text.correction.SourceAssistProcessor;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class GenerateConstructorsHandler {
    public static CheckConstructorsResponse checkConstructorsStatus(CodeActionParams params) {
        IType type = SourceAssistProcessor.getSelectionType(params);
        return GenerateConstructorsHandler.checkConstructorStatus(type);
    }

    public static CheckConstructorsResponse checkConstructorStatus(IType type) {
        if (type == null || type.getCompilationUnit() == null) {
            return new CheckConstructorsResponse();
        }
        try {
            RefactoringASTParser astParser = new RefactoringASTParser(12);
            CompilationUnit astRoot = astParser.parse((ITypeRoot)type.getCompilationUnit(), true);
            ITypeBinding typeBinding = ASTNodes.getTypeBinding((CompilationUnit)astRoot, (IType)type);
            if (typeBinding == null) {
                return new CheckConstructorsResponse();
            }
            IMethodBinding[] superConstructors = GenerateConstructorsHandler.getVisibleConstructors(astRoot, typeBinding);
            HashMap<IJavaElement, IVariableBinding> fieldsToBindings = new HashMap<IJavaElement, IVariableBinding>();
            IVariableBinding[] iVariableBindingArray = typeBinding.getDeclaredFields();
            int n = iVariableBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                ASTNode declaringNode;
                IVariableBinding field = iVariableBindingArray[n2];
                if (!(field.isSynthetic() || Modifier.isStatic((int)field.getModifiers()) || Modifier.isFinal((int)field.getModifiers()) && (declaringNode = astRoot.findDeclaringNode((IBinding)field)) instanceof VariableDeclarationFragment && ((VariableDeclarationFragment)declaringNode).getInitializer() != null)) {
                    fieldsToBindings.put(field.getJavaElement(), field);
                }
                ++n2;
            }
            ArrayList<IVariableBinding> fields = new ArrayList<IVariableBinding>();
            IField[] iFieldArray = type.getFields();
            int n3 = iFieldArray.length;
            n = 0;
            while (n < n3) {
                IField field = iFieldArray[n];
                IVariableBinding fieldBinding = (IVariableBinding)fieldsToBindings.remove(field);
                if (fieldBinding != null) {
                    fields.add(fieldBinding);
                }
                ++n;
            }
            return new CheckConstructorsResponse((JdtDomModels.LspMethodBinding[])Arrays.stream(superConstructors).map(binding -> new JdtDomModels.LspMethodBinding((IMethodBinding)binding)).toArray(JdtDomModels.LspMethodBinding[]::new), (JdtDomModels.LspVariableBinding[])fields.stream().map(binding -> new JdtDomModels.LspVariableBinding((IVariableBinding)binding)).toArray(JdtDomModels.LspVariableBinding[]::new));
        }
        catch (JavaModelException e) {
            JavaLanguageServerPlugin.logException("Failed to check constructor status", e);
            return new CheckConstructorsResponse();
        }
    }

    private static IMethodBinding getObjectConstructor(AST ast) {
        ITypeBinding binding = ast.resolveWellKnownType("java.lang.Object");
        return Bindings.findMethodInType((ITypeBinding)binding, (String)"Object", (ITypeBinding[])new ITypeBinding[0]);
    }

    private static IMethodBinding[] getVisibleConstructors(CompilationUnit astRoot, ITypeBinding typeBinding) {
        if (typeBinding.isEnum()) {
            return new IMethodBinding[]{GenerateConstructorsHandler.getObjectConstructor(astRoot.getAST())};
        }
        return StubUtility2Core.getVisibleConstructors((ITypeBinding)typeBinding, (boolean)false, (boolean)true);
    }

    public static WorkspaceEdit generateConstructors(GenerateConstructorsParams params) {
        IType type = SourceAssistProcessor.getSelectionType(params.context);
        TextEdit edit = GenerateConstructorsHandler.generateConstructors(type, params.constructors, params.fields);
        return edit == null ? null : SourceAssistProcessor.convertToWorkspaceEdit(type.getCompilationUnit(), edit);
    }

    public static TextEdit generateConstructors(IType type, JdtDomModels.LspMethodBinding[] constructors, JdtDomModels.LspVariableBinding[] fields) {
        Preferences preferences = JavaLanguageServerPlugin.getPreferencesManager().getPreferences();
        CodeGenerationSettings settings = new CodeGenerationSettings();
        settings.createComments = preferences.isCodeGenerationTemplateGenerateComments();
        return GenerateConstructorsHandler.generateConstructors(type, constructors, fields, settings);
    }

    public static TextEdit generateConstructors(IType type, JdtDomModels.LspMethodBinding[] constructors, JdtDomModels.LspVariableBinding[] fields, CodeGenerationSettings settings) {
        if (type == null || type.getCompilationUnit() == null || constructors == null || constructors.length == 0) {
            return null;
        }
        try {
            RefactoringASTParser astParser = new RefactoringASTParser(12);
            CompilationUnit astRoot = astParser.parse((ITypeRoot)type.getCompilationUnit(), true);
            ITypeBinding typeBinding = ASTNodes.getTypeBinding((CompilationUnit)astRoot, (IType)type);
            if (typeBinding != null) {
                HashMap<String, IVariableBinding> fieldBindings = new HashMap<String, IVariableBinding>();
                IVariableBinding[] iVariableBindingArray = typeBinding.getDeclaredFields();
                int n = iVariableBindingArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IVariableBinding binding2 = iVariableBindingArray[n2];
                    fieldBindings.put(binding2.getKey(), binding2);
                    ++n2;
                }
                IVariableBinding[] selectedFields = (IVariableBinding[])Arrays.stream(fields).map(field -> (IVariableBinding)fieldBindings.get(field.bindingKey)).filter(binding -> binding != null).toArray(IVariableBinding[]::new);
                IMethodBinding[] superConstructors = GenerateConstructorsHandler.getVisibleConstructors(astRoot, typeBinding);
                MultiTextEdit textEdit = new MultiTextEdit();
                JdtDomModels.LspMethodBinding[] lspMethodBindingArray = constructors;
                int n3 = constructors.length;
                int n4 = 0;
                while (n4 < n3) {
                    JdtDomModels.LspMethodBinding constructor = lspMethodBindingArray[n4];
                    Optional<IMethodBinding> selectedSuperConstructor = Arrays.stream(superConstructors).filter(superConstructor -> GenerateConstructorsHandler.compareConstructor(superConstructor, constructor)).findAny();
                    if (selectedSuperConstructor.isPresent()) {
                        IMethodBinding superConstructor2 = selectedSuperConstructor.get();
                        AddCustomConstructorOperation constructorOperation = new AddCustomConstructorOperation(astRoot, typeBinding, selectedFields, superConstructor2, null, settings, false, false);
                        constructorOperation.setOmitSuper(superConstructor2.getParameterTypes().length == 0);
                        constructorOperation.setVisibility(typeBinding.isEnum() ? 2 : 1);
                        constructorOperation.run(null);
                        textEdit.addChild(constructorOperation.getResultingEdit());
                    }
                    ++n4;
                }
                return textEdit;
            }
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException("Failed to generate constructors", e);
        }
        return null;
    }

    private static boolean compareConstructor(IMethodBinding binding, JdtDomModels.LspMethodBinding lspBinding) {
        if (lspBinding == null) {
            return binding == null;
        }
        if (binding == null) {
            return lspBinding == null;
        }
        Object[] parameters = (String[])Arrays.stream(binding.getParameterTypes()).map(type -> type.getName()).toArray(String[]::new);
        return Arrays.equals(parameters, lspBinding.parameters);
    }

    public static class CheckConstructorsResponse {
        public JdtDomModels.LspMethodBinding[] constructors = new JdtDomModels.LspMethodBinding[0];
        public JdtDomModels.LspVariableBinding[] fields = new JdtDomModels.LspVariableBinding[0];

        public CheckConstructorsResponse() {
        }

        public CheckConstructorsResponse(JdtDomModels.LspMethodBinding[] constructors, JdtDomModels.LspVariableBinding[] fields) {
            this.constructors = constructors;
            this.fields = fields;
        }
    }

    public static class GenerateConstructorsParams {
        public CodeActionParams context;
        public JdtDomModels.LspMethodBinding[] constructors;
        public JdtDomModels.LspVariableBinding[] fields;
    }
}

