/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.contentassist.CompletionProposalRequestor;
import org.eclipse.jdt.ls.core.internal.contentassist.JavadocCompletionProposal;
import org.eclipse.jdt.ls.core.internal.contentassist.SnippetCompletionProposal;
import org.eclipse.jdt.ls.core.internal.handlers.CompletionResponses;
import org.eclipse.jdt.ls.core.internal.handlers.JsonRpcHelpers;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionOptions;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class CompletionHandler {
    public static final CompletionOptions DEFAULT_COMPLETION_OPTIONS = new CompletionOptions(Boolean.TRUE, Arrays.asList(".", "@", "#", "*"));

    Either<List<CompletionItem>, CompletionList> completion(CompletionParams position, IProgressMonitor monitor) {
        List<CompletionItem> completionItems = null;
        try {
            ICompilationUnit unit = JDTUtils.resolveCompilationUnit(position.getTextDocument().getUri());
            completionItems = this.computeContentAssist(unit, position.getPosition().getLine(), position.getPosition().getCharacter(), monitor);
        }
        catch (OperationCanceledException ignorable) {
            monitor.setCanceled(true);
        }
        catch (Exception e) {
            JavaLanguageServerPlugin.logException("Problem with codeComplete for " + position.getTextDocument().getUri(), e);
            monitor.setCanceled(true);
        }
        CompletionList $ = new CompletionList();
        if (monitor.isCanceled()) {
            $.setIsIncomplete(true);
            completionItems = null;
            JavaLanguageServerPlugin.logInfo("Completion request cancelled");
        } else {
            JavaLanguageServerPlugin.logInfo("Completion request completed");
        }
        $.setItems(completionItems == null ? Collections.emptyList() : completionItems);
        return Either.forRight((Object)$);
    }

    private List<CompletionItem> computeContentAssist(ICompilationUnit unit, int line, int column, IProgressMonitor monitor) throws JavaModelException {
        IBuffer buffer;
        CompletionResponses.clear();
        if (unit == null) {
            return Collections.emptyList();
        }
        ArrayList<CompletionItem> proposals = new ArrayList<CompletionItem>();
        int offset = JsonRpcHelpers.toOffset(unit.getBuffer(), line, column);
        CompletionProposalRequestor collector = new CompletionProposalRequestor(unit, offset);
        collector.setAllowsRequiredProposals(2, 9, true);
        collector.setAllowsRequiredProposals(2, 23, true);
        collector.setAllowsRequiredProposals(2, 21, true);
        collector.setAllowsRequiredProposals(6, 9, true);
        collector.setAllowsRequiredProposals(6, 23, true);
        collector.setAllowsRequiredProposals(6, 22, true);
        collector.setAllowsRequiredProposals(26, 9, true);
        collector.setAllowsRequiredProposals(27, 9, true);
        collector.setAllowsRequiredProposals(1, 9, true);
        collector.setAllowsRequiredProposals(9, 9, true);
        collector.setFavoriteReferences(this.getFavoriteStaticMembers());
        if (offset > -1 && !monitor.isCanceled() && (buffer = unit.getBuffer()) != null && buffer.getLength() >= offset) {
            ProgressMonitorWrapper subMonitor = new ProgressMonitorWrapper(monitor){
                private long timeLimit;
                private static final long TIMEOUT = 5000L;

                public void beginTask(String name, int totalWork) {
                    this.timeLimit = System.currentTimeMillis() + 5000L;
                }

                public boolean isCanceled() {
                    return super.isCanceled() || this.timeLimit <= System.currentTimeMillis();
                }
            };
            try {
                unit.codeComplete(offset, (CompletionRequestor)collector, (IProgressMonitor)subMonitor);
                proposals.addAll(collector.getCompletionItems());
                proposals.addAll(SnippetCompletionProposal.getSnippets(unit, collector.getContext(), (IProgressMonitor)subMonitor));
                proposals.addAll(new JavadocCompletionProposal().getProposals(unit, offset, collector, (IProgressMonitor)subMonitor));
            }
            catch (OperationCanceledException e) {
                monitor.setCanceled(true);
            }
        }
        return proposals;
    }

    private String[] getFavoriteStaticMembers() {
        PreferenceManager preferenceManager = JavaLanguageServerPlugin.getPreferencesManager();
        if (preferenceManager != null) {
            return preferenceManager.getPreferences().getJavaCompletionFavoriteMembers();
        }
        return new String[0];
    }
}

