/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.contentassist;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.manipulation.CoreASTProvider;
import org.eclipse.jdt.internal.codeassist.InternalCompletionContext;
import org.eclipse.jdt.internal.codeassist.complete.CompletionOnFieldType;
import org.eclipse.jdt.internal.codeassist.complete.CompletionOnKeyword2;
import org.eclipse.jdt.internal.codeassist.complete.CompletionOnSingleNameReference;
import org.eclipse.jdt.internal.core.manipulation.CodeTemplateContext;
import org.eclipse.jdt.internal.core.manipulation.util.Strings;
import org.eclipse.jdt.internal.corext.dom.TokenScanner;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.contentassist.SortTextHelper;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.ls.core.internal.preferences.CodeGenerationTemplate;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.InsertTextFormat;

public class SnippetCompletionProposal {
    private static final String CLASS_SNIPPET_LABEL = "class";
    private static final String INTERFACE_SNIPPET_LABEL = "interface";
    private static final String CLASS_KEYWORD = "class";
    private static final String INTERFACE_KEYWORD = "interface";
    private static final Set<String> UNSUPPORTED_RESOURCES = Sets.newHashSet((Object[])new String[]{"module-info.java", "package-info.java"});
    private static String PACKAGEHEADER = "package_header";
    private static String CURSOR = "cursor";

    public static List<CompletionItem> getSnippets(ICompilationUnit cu, CompletionContext completionContext, IProgressMonitor monitor) {
        CompletionItem interfaceSnippet;
        CompletionItem classSnippet;
        if (cu == null) {
            throw new IllegalArgumentException("Compilation unit must not be null");
        }
        char[] completionToken = completionContext.getToken();
        boolean isInterfacePrefix = true;
        boolean isClassPrefix = true;
        if (completionToken != null && completionToken.length > 0) {
            String prefix = new String(completionToken);
            isInterfacePrefix = "interface".startsWith(prefix);
            isClassPrefix = "class".startsWith(prefix);
        }
        if (!isInterfacePrefix && !isClassPrefix) {
            return Collections.emptyList();
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (!SnippetCompletionProposal.isSnippetStringSupported() || UNSUPPORTED_RESOURCES.contains(cu.getResource().getName())) {
            return Collections.emptyList();
        }
        boolean needsPublic = SnippetCompletionProposal.needsPublic(cu, completionContext, monitor);
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        ArrayList<CompletionItem> res = new ArrayList<CompletionItem>(2);
        if (isClassPrefix && (classSnippet = SnippetCompletionProposal.getClassSnippet(cu, completionContext, needsPublic, monitor)) != null) {
            res.add(classSnippet);
        }
        if (isInterfacePrefix && (interfaceSnippet = SnippetCompletionProposal.getInterfaceSnippet(cu, completionContext, needsPublic, monitor)) != null) {
            res.add(interfaceSnippet);
        }
        return res;
    }

    private static boolean accept(ICompilationUnit cu, CompletionContext completionContext, boolean acceptClass) {
        if (completionContext != null && completionContext.isExtended()) {
            if (completionContext.isInJavadoc()) {
                return false;
            }
            if (completionContext instanceof InternalCompletionContext) {
                InternalCompletionContext internalCompletionContext = (InternalCompletionContext)completionContext;
                org.eclipse.jdt.internal.compiler.ast.ASTNode node = internalCompletionContext.getCompletionNode();
                if (node instanceof CompletionOnKeyword2) {
                    return true;
                }
                if (node instanceof CompletionOnFieldType) {
                    return true;
                }
                if (acceptClass && node instanceof CompletionOnSingleNameReference) {
                    if (completionContext.getEnclosingElement() instanceof IMethod) {
                        CompilationUnit ast = CoreASTProvider.getInstance().getAST((ITypeRoot)cu, CoreASTProvider.WAIT_YES, null);
                        ASTNode astNode = ASTNodeSearchUtil.getAstNode(ast, completionContext.getTokenStart(), completionContext.getTokenEnd() - completionContext.getTokenStart() + 1);
                        return astNode == null || astNode.getParent() instanceof ExpressionStatement;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean needsPublic(ICompilationUnit cu, CompletionContext completionContext, IProgressMonitor monitor) {
        block14: {
            block13: {
                if (completionContext == null || !completionContext.isExtended()) break block13;
                if (completionContext.isInJavadoc()) {
                    return false;
                }
                if (!(completionContext instanceof InternalCompletionContext) || !((node = (internalCompletionContext = (InternalCompletionContext)completionContext).getCompletionNode()) instanceof CompletionOnKeyword2) && !(node instanceof CompletionOnFieldType) && !(node instanceof CompletionOnSingleNameReference)) break block13;
                if (completionContext.getEnclosingElement() instanceof IMethod) {
                    return false;
                }
                try {
                    scanner = new TokenScanner((ITypeRoot)cu);
                    previous = curr = scanner.readNext(0, true);
                    while (scanner.getCurrentEndOffset() < completionContext.getTokenStart()) {
                        previous = curr;
                        if (monitor.isCanceled()) {
                            return false;
                        }
                        if (curr == 158) break;
                        try {
                            curr = scanner.readNext(true);
                        }
                        catch (CoreException var8_10) {
                            // empty catch block
                        }
                    }
                    if (TokenScanner.isModifier((int)previous)) {
                        return false;
                    }
                }
                catch (CoreException e) {
                    JavaLanguageServerPlugin.logException(e.getMessage(), e);
                }
                if (!(node instanceof CompletionOnSingleNameReference)) break block14;
                ast = CoreASTProvider.getInstance().getAST((ITypeRoot)cu, CoreASTProvider.WAIT_YES, null);
                if (monitor.isCanceled()) {
                    return false;
                }
                astNode = ASTNodeSearchUtil.getAstNode(ast, completionContext.getOffset(), 1);
                if (astNode == null) {
                    return false;
                }
                ** GOTO lbl39
            }
            return false;
lbl-1000:
            // 1 sources

            {
                if (astNode instanceof Initializer) {
                    return false;
                }
                astNode = astNode.getParent();
lbl39:
                // 2 sources

                ** while (astNode != null)
            }
        }
        return true;
    }

    private static CompletionItem getClassSnippet(ICompilationUnit cu, CompletionContext completionContext, boolean needsPublic, IProgressMonitor monitor) {
        if (!SnippetCompletionProposal.accept(cu, completionContext, true)) {
            return null;
        }
        if (monitor.isCanceled()) {
            return null;
        }
        CompletionItem classSnippetItem = new CompletionItem();
        classSnippetItem.setLabel("class");
        classSnippetItem.setFilterText("class");
        classSnippetItem.setSortText(SortTextHelper.convertRelevance(1));
        try {
            if (needsPublic) {
                classSnippetItem.setInsertText(SnippetCompletionProposal.getSnippetContent(cu, CodeGenerationTemplate.CLASSSNIPPET_PUBLIC, cu.findRecommendedLineSeparator(), true));
            } else {
                classSnippetItem.setInsertText(SnippetCompletionProposal.getSnippetContent(cu, CodeGenerationTemplate.CLASSSNIPPET_DEFAULT, cu.findRecommendedLineSeparator(), true));
            }
            SnippetCompletionProposal.setFields(classSnippetItem, cu);
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.log(e.getStatus());
            return null;
        }
        return classSnippetItem;
    }

    private static CompletionItem getInterfaceSnippet(ICompilationUnit cu, CompletionContext completionContext, boolean needsPublic, IProgressMonitor monitor) {
        if (!SnippetCompletionProposal.accept(cu, completionContext, false)) {
            return null;
        }
        if (monitor.isCanceled()) {
            return null;
        }
        CompletionItem interfaceSnippetItem = new CompletionItem();
        interfaceSnippetItem.setFilterText("interface");
        interfaceSnippetItem.setLabel("interface");
        interfaceSnippetItem.setSortText(SortTextHelper.convertRelevance(0));
        try {
            if (needsPublic) {
                interfaceSnippetItem.setInsertText(SnippetCompletionProposal.getSnippetContent(cu, CodeGenerationTemplate.INTERFACESNIPPET_PUBLIC, cu.findRecommendedLineSeparator(), true));
            } else {
                interfaceSnippetItem.setInsertText(SnippetCompletionProposal.getSnippetContent(cu, CodeGenerationTemplate.INTERFACESNIPPET_DEFAULT, cu.findRecommendedLineSeparator(), true));
            }
            SnippetCompletionProposal.setFields(interfaceSnippetItem, cu);
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.log(e.getStatus());
            return null;
        }
        return interfaceSnippetItem;
    }

    private static boolean isSnippetStringSupported() {
        return JavaLanguageServerPlugin.getPreferencesManager() != null && JavaLanguageServerPlugin.getPreferencesManager().getClientPreferences() != null && JavaLanguageServerPlugin.getPreferencesManager().getClientPreferences().isCompletionSnippetsSupported();
    }

    private static void setFields(CompletionItem ci, ICompilationUnit cu) {
        ci.setKind(CompletionItemKind.Snippet);
        ci.setInsertTextFormat(InsertTextFormat.Snippet);
        ci.setDocumentation(ci.getInsertText());
        HashMap<String, String> data = new HashMap<String, String>(3);
        data.put("uri", JDTUtils.toURI(cu));
        data.put("rid", "0");
        data.put("pid", "0");
        ci.setData(data);
    }

    private static String getSnippetContent(ICompilationUnit cu, CodeGenerationTemplate templateSetting, String lineDelimiter, boolean snippetStringSupport) throws CoreException {
        TemplateBuffer buffer;
        Template template = templateSetting.createTemplate(cu.getJavaProject());
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), cu.getJavaProject(), lineDelimiter);
        IPackageDeclaration[] packageDeclarations = cu.getPackageDeclarations();
        String packageName = cu.getParent().getElementName();
        String packageHeader = packageName != null && !packageName.isEmpty() && (packageDeclarations == null || packageDeclarations.length == 0) ? "package " + packageName + ";\n\n" : "";
        context.setVariable(PACKAGEHEADER, packageHeader);
        String typeName = JavaCore.removeJavaLikeExtension((String)cu.getElementName());
        List<IType> types = Arrays.asList(cu.getAllTypes());
        int postfix = 0;
        while (types != null && !types.isEmpty() && types.stream().filter(SnippetCompletionProposal.isTypeExists(typeName)).findFirst().isPresent()) {
            typeName = "Inner" + JavaCore.removeJavaLikeExtension((String)cu.getElementName()) + (postfix == 0 ? "" : "_" + postfix);
            ++postfix;
        }
        if (postfix > 0 && snippetStringSupport) {
            context.setVariable("type_name", "${1:" + typeName + "}");
        } else {
            context.setVariable("type_name", typeName);
        }
        context.setVariable(CURSOR, snippetStringSupport ? "${0}" : "");
        try {
            buffer = context.evaluate(template);
        }
        catch (BadLocationException e) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        catch (TemplateException e) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        if (buffer == null) {
            return null;
        }
        String str = buffer.getString();
        if (Strings.containsOnlyWhitespaces((String)str)) {
            return null;
        }
        return str;
    }

    private static Predicate<IType> isTypeExists(String typeName) {
        return type -> type.getElementName().equals(typeName);
    }
}

