/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal;

import com.google.common.base.Preconditions;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.ls.core.internal.Environment;

public class JDTEnvironmentUtils {
    public static final String CLIENT_PORT = "CLIENT_PORT";
    public static final String CLIENT_HOST = "CLIENT_HOST";
    public static final String DEFAULT_CLIENT_HOST = "localhost";
    public static final String SOCKET_STREAM_DEBUG = "socket.stream.debug";

    public static Integer getClientPort() {
        String port = Environment.get(CLIENT_PORT);
        if (port != null) {
            int clientPort = Integer.parseInt(port);
            Preconditions.checkState((clientPort >= 1 && clientPort <= 65535 ? 1 : 0) != 0, (Object)("The port must be an integer between 1 and 65535. It was: '" + port + "'."));
            return clientPort;
        }
        return null;
    }

    public static String getClientHost() {
        return Environment.get(CLIENT_HOST);
    }

    public static boolean inSocketStreamDebugMode() {
        return Boolean.parseBoolean(Environment.get(SOCKET_STREAM_DEBUG, "false")) && (Platform.inDebugMode() || Platform.inDevelopmentMode()) && JDTEnvironmentUtils.getClientHost() != null && JDTEnvironmentUtils.getClientPort() != null;
    }
}

