/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.text.correction;

import com.google.common.collect.Sets;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.manipulation.CoreASTProvider;
import org.eclipse.jdt.core.manipulation.OrganizeImportsOperation;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.ui.text.correction.IProblemLocationCore;
import org.eclipse.jdt.ls.core.internal.ChangeUtil;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.TextEditConverter;
import org.eclipse.jdt.ls.core.internal.codemanipulation.GenerateGetterSetterOperation;
import org.eclipse.jdt.ls.core.internal.corext.util.JdtFlags;
import org.eclipse.jdt.ls.core.internal.corrections.CorrectionMessages;
import org.eclipse.jdt.ls.core.internal.corrections.DiagnosticsHelper;
import org.eclipse.jdt.ls.core.internal.corrections.IInvocationContext;
import org.eclipse.jdt.ls.core.internal.corrections.InnovationContext;
import org.eclipse.jdt.ls.core.internal.handlers.GenerateConstructorsHandler;
import org.eclipse.jdt.ls.core.internal.handlers.GenerateDelegateMethodsHandler;
import org.eclipse.jdt.ls.core.internal.handlers.GenerateToStringHandler;
import org.eclipse.jdt.ls.core.internal.handlers.JdtDomModels;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.jdt.ls.core.internal.text.correction.ActionMessages;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionContext;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.text.edits.TextEdit;

public class SourceAssistProcessor {
    private static final Set<String> UNSUPPORTED_RESOURCES = Sets.newHashSet((Object[])new String[]{"module-info.java", "package-info.java"});
    public static final String COMMAND_ID_ACTION_OVERRIDEMETHODSPROMPT = "java.action.overrideMethodsPrompt";
    public static final String COMMAND_ID_ACTION_HASHCODEEQUALSPROMPT = "java.action.hashCodeEqualsPrompt";
    public static final String COMMAND_ID_ACTION_ORGANIZEIMPORTS = "java.action.organizeImports";
    public static final String COMMAND_ID_ACTION_GENERATETOSTRINGPROMPT = "java.action.generateToStringPrompt";
    public static final String COMMAND_ID_ACTION_GENERATEACCESSORSPROMPT = "java.action.generateAccessorsPrompt";
    public static final String COMMAND_ID_ACTION_GENERATECONSTRUCTORSPROMPT = "java.action.generateConstructorsPrompt";
    public static final String COMMAND_ID_ACTION_GENERATEDELEGATEMETHODSPROMPT = "java.action.generateDelegateMethodsPrompt";
    private PreferenceManager preferenceManager;

    public SourceAssistProcessor(PreferenceManager preferenceManager) {
        this.preferenceManager = preferenceManager;
    }

    public List<Either<Command, CodeAction>> getSourceActionCommands(CodeActionParams params, IInvocationContext context, IProblemLocationCore[] locations) {
        ArrayList<Either<Command, CodeAction>> $ = new ArrayList<Either<Command, CodeAction>>();
        ICompilationUnit cu = context.getCompilationUnit();
        IType type = SourceAssistProcessor.getSelectionType(context);
        if (this.preferenceManager.getClientPreferences().isAdvancedOrganizeImportsSupported()) {
            Optional<Either<Command, CodeAction>> organizeImports = this.getOrganizeImportsAction(params);
            this.addSourceActionCommand($, params.getContext(), organizeImports);
        } else {
            TextEdit organizeImportsEdit = this.getOrganizeImportsProposal(context);
            Optional<Either<Command, CodeAction>> organizeImports = this.convertToWorkspaceEditAction(params.getContext(), context.getCompilationUnit(), CorrectionMessages.ReorgCorrectionsSubProcessor_organizeimports_description, "source.organizeImports", organizeImportsEdit);
            this.addSourceActionCommand($, params.getContext(), organizeImports);
        }
        if (!UNSUPPORTED_RESOURCES.contains(cu.getResource().getName())) {
            Optional<Either<Command, CodeAction>> overrideMethods = this.getOverrideMethodsAction(params);
            this.addSourceActionCommand($, params.getContext(), overrideMethods);
        }
        Optional<Either<Command, CodeAction>> getterSetter = this.getGetterSetterAction(params, context, type);
        this.addSourceActionCommand($, params.getContext(), getterSetter);
        if (this.supportsHashCodeEquals(context, type)) {
            Optional<Either<Command, CodeAction>> hashCodeEquals = this.getHashCodeEqualsAction(params);
            this.addSourceActionCommand($, params.getContext(), hashCodeEquals);
        }
        if (this.supportsGenerateToString(type)) {
            boolean nonStaticFields = true;
            try {
                nonStaticFields = this.hasFields(type, false);
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
            if (nonStaticFields) {
                Optional<Either<Command, CodeAction>> generateToStringCommand = this.getGenerateToStringAction(params);
                this.addSourceActionCommand($, params.getContext(), generateToStringCommand);
            } else {
                TextEdit toStringEdit = GenerateToStringHandler.generateToString(type, new JdtDomModels.LspVariableBinding[0]);
                Optional<Either<Command, CodeAction>> generateToStringCommand = this.convertToWorkspaceEditAction(params.getContext(), context.getCompilationUnit(), ActionMessages.GenerateToStringAction_label, "source.generate.toString", toStringEdit);
                this.addSourceActionCommand($, params.getContext(), generateToStringCommand);
            }
        }
        Optional<Either<Command, CodeAction>> generateConstructors = this.getGenerateConstructorsAction(params, context, type);
        this.addSourceActionCommand($, params.getContext(), generateConstructors);
        Optional<Either<Command, CodeAction>> generateDelegateMethods = this.getGenerateDelegateMethodsAction(params, context, type);
        this.addSourceActionCommand($, params.getContext(), generateDelegateMethods);
        return $;
    }

    private void addSourceActionCommand(List<Either<Command, CodeAction>> result, CodeActionContext context, Optional<Either<Command, CodeAction>> target) {
        if (!target.isPresent()) {
            return;
        }
        Either<Command, CodeAction> targetAction = target.get();
        if (context.getOnly() != null && !context.getOnly().isEmpty()) {
            String actionKind;
            Stream acceptedActionKinds = context.getOnly().stream();
            String string = actionKind = targetAction.getLeft() == null ? ((CodeAction)targetAction.getRight()).getKind() : ((Command)targetAction.getLeft()).getCommand();
            if (!acceptedActionKinds.filter(kind -> actionKind != null && actionKind.startsWith((String)kind)).findFirst().isPresent()) {
                return;
            }
        }
        result.add(targetAction);
    }

    private TextEdit getOrganizeImportsProposal(IInvocationContext context) {
        ICompilationUnit unit = context.getCompilationUnit();
        CompilationUnit astRoot = context.getASTRoot();
        OrganizeImportsOperation op = new OrganizeImportsOperation(unit, astRoot, true, false, true, null);
        try {
            return op.createTextEdit(null);
        }
        catch (CoreException | OperationCanceledException e) {
            JavaLanguageServerPlugin.logException("Resolve organize imports source action", e);
            return null;
        }
    }

    private Optional<Either<Command, CodeAction>> getOrganizeImportsAction(CodeActionParams params) {
        Command command = new Command(CorrectionMessages.ReorgCorrectionsSubProcessor_organizeimports_description, COMMAND_ID_ACTION_ORGANIZEIMPORTS, Collections.singletonList(params));
        CodeAction codeAction = new CodeAction(CorrectionMessages.ReorgCorrectionsSubProcessor_organizeimports_description);
        codeAction.setKind("source.organizeImports");
        codeAction.setCommand(command);
        codeAction.setDiagnostics(Collections.EMPTY_LIST);
        return Optional.of(Either.forRight((Object)codeAction));
    }

    private Optional<Either<Command, CodeAction>> getOverrideMethodsAction(CodeActionParams params) {
        if (!this.preferenceManager.getClientPreferences().isOverrideMethodsPromptSupported()) {
            return Optional.empty();
        }
        Command command = new Command(ActionMessages.OverrideMethodsAction_label, COMMAND_ID_ACTION_OVERRIDEMETHODSPROMPT, Collections.singletonList(params));
        if (this.preferenceManager.getClientPreferences().isSupportedCodeActionKind("source.overrideMethods")) {
            CodeAction codeAction = new CodeAction(ActionMessages.OverrideMethodsAction_label);
            codeAction.setKind("source.overrideMethods");
            codeAction.setCommand(command);
            codeAction.setDiagnostics(Collections.EMPTY_LIST);
            return Optional.of(Either.forRight((Object)codeAction));
        }
        return Optional.of(Either.forLeft((Object)command));
    }

    private Optional<Either<Command, CodeAction>> getGetterSetterAction(CodeActionParams params, IInvocationContext context, IType type) {
        try {
            GenerateGetterSetterOperation.AccessorField[] accessors = GenerateGetterSetterOperation.getUnimplementedAccessors(type);
            if (accessors == null || accessors.length == 0) {
                return Optional.empty();
            }
            if (accessors.length == 1 || !this.preferenceManager.getClientPreferences().isAdvancedGenerateAccessorsSupported()) {
                GenerateGetterSetterOperation operation = new GenerateGetterSetterOperation(type, context.getASTRoot(), this.preferenceManager.getPreferences().isCodeGenerationTemplateGenerateComments());
                TextEdit edit = operation.createTextEdit(null, accessors);
                return this.convertToWorkspaceEditAction(params.getContext(), context.getCompilationUnit(), ActionMessages.GenerateGetterSetterAction_label, "source.generate.accessors", edit);
            }
            Command command = new Command(ActionMessages.GenerateGetterSetterAction_ellipsisLabel, COMMAND_ID_ACTION_GENERATEACCESSORSPROMPT, Collections.singletonList(params));
            if (this.preferenceManager.getClientPreferences().isSupportedCodeActionKind("source.generate.accessors")) {
                CodeAction codeAction = new CodeAction(ActionMessages.GenerateGetterSetterAction_ellipsisLabel);
                codeAction.setKind("source.generate.accessors");
                codeAction.setCommand(command);
                codeAction.setDiagnostics(Collections.EMPTY_LIST);
                return Optional.of(Either.forRight((Object)codeAction));
            }
            return Optional.of(Either.forLeft((Object)command));
        }
        catch (CoreException | OperationCanceledException e) {
            JavaLanguageServerPlugin.logException("Failed to generate Getter and Setter source action", e);
            return Optional.empty();
        }
    }

    private boolean supportsHashCodeEquals(IInvocationContext context, IType type) {
        block3: {
            try {
                if (type != null && !type.isAnnotation() && !type.isInterface() && !type.isEnum() && type.getCompilationUnit() != null) break block3;
                return false;
            }
            catch (JavaModelException e) {
                return false;
            }
        }
        RefactoringASTParser astParser = new RefactoringASTParser(12);
        CompilationUnit astRoot = astParser.parse((ITypeRoot)type.getCompilationUnit(), true);
        ITypeBinding typeBinding = ASTNodes.getTypeBinding((CompilationUnit)astRoot, (IType)type);
        return typeBinding == null ? false : Arrays.stream(typeBinding.getDeclaredFields()).filter(f -> !Modifier.isStatic(f.getModifiers())).findAny().isPresent();
    }

    private Optional<Either<Command, CodeAction>> getHashCodeEqualsAction(CodeActionParams params) {
        if (!this.preferenceManager.getClientPreferences().isHashCodeEqualsPromptSupported()) {
            return Optional.empty();
        }
        Command command = new Command(ActionMessages.GenerateHashCodeEqualsAction_label, COMMAND_ID_ACTION_HASHCODEEQUALSPROMPT, Collections.singletonList(params));
        if (this.preferenceManager.getClientPreferences().isSupportedCodeActionKind("source.generate.hashCodeEquals")) {
            CodeAction codeAction = new CodeAction(ActionMessages.GenerateHashCodeEqualsAction_label);
            codeAction.setKind("source.generate.hashCodeEquals");
            codeAction.setCommand(command);
            codeAction.setDiagnostics(Collections.EMPTY_LIST);
            return Optional.of(Either.forRight((Object)codeAction));
        }
        return Optional.of(Either.forLeft((Object)command));
    }

    private boolean supportsGenerateToString(IType type) {
        try {
            if (type == null || type.isAnnotation() || type.isInterface() || type.isEnum() || type.isAnonymous() || type.getCompilationUnit() == null) {
                return false;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return true;
    }

    private Optional<Either<Command, CodeAction>> getGenerateToStringAction(CodeActionParams params) {
        if (!this.preferenceManager.getClientPreferences().isGenerateToStringPromptSupported()) {
            return Optional.empty();
        }
        Command command = new Command(ActionMessages.GenerateToStringAction_label, COMMAND_ID_ACTION_GENERATETOSTRINGPROMPT, Collections.singletonList(params));
        if (this.preferenceManager.getClientPreferences().isSupportedCodeActionKind("source.generate.toString")) {
            CodeAction codeAction = new CodeAction(ActionMessages.GenerateToStringAction_label);
            codeAction.setKind("source.generate.toString");
            codeAction.setCommand(command);
            codeAction.setDiagnostics(Collections.EMPTY_LIST);
            return Optional.of(Either.forRight((Object)codeAction));
        }
        return Optional.of(Either.forLeft((Object)command));
    }

    private Optional<Either<Command, CodeAction>> getGenerateConstructorsAction(CodeActionParams params, IInvocationContext context, IType type) {
        try {
            if (type == null || type.isAnnotation() || type.isInterface() || type.isAnonymous() || type.getCompilationUnit() == null) {
                return Optional.empty();
            }
        }
        catch (JavaModelException e) {
            return Optional.empty();
        }
        if (this.preferenceManager.getClientPreferences().isGenerateConstructorsPromptSupported()) {
            GenerateConstructorsHandler.CheckConstructorsResponse status = GenerateConstructorsHandler.checkConstructorStatus(type);
            if (status.constructors.length == 1 && status.fields.length == 0) {
                TextEdit edit = GenerateConstructorsHandler.generateConstructors(type, status.constructors, status.fields);
                return this.convertToWorkspaceEditAction(params.getContext(), type.getCompilationUnit(), ActionMessages.GenerateConstructorsAction_label, "source.generate.constructors", edit);
            }
            Command command = new Command(ActionMessages.GenerateConstructorsAction_ellipsisLabel, COMMAND_ID_ACTION_GENERATECONSTRUCTORSPROMPT, Collections.singletonList(params));
            if (this.preferenceManager.getClientPreferences().isSupportedCodeActionKind("source.generate.constructors")) {
                CodeAction codeAction = new CodeAction(ActionMessages.GenerateConstructorsAction_ellipsisLabel);
                codeAction.setKind("source.generate.constructors");
                codeAction.setCommand(command);
                codeAction.setDiagnostics(Collections.EMPTY_LIST);
                return Optional.of(Either.forRight((Object)codeAction));
            }
            return Optional.of(Either.forLeft((Object)command));
        }
        return Optional.empty();
    }

    private Optional<Either<Command, CodeAction>> getGenerateDelegateMethodsAction(CodeActionParams params, IInvocationContext context, IType type) {
        try {
            if (!this.preferenceManager.getClientPreferences().isGenerateDelegateMethodsPromptSupported() || !GenerateDelegateMethodsHandler.supportsGenerateDelegateMethods(type)) {
                return Optional.empty();
            }
        }
        catch (JavaModelException e) {
            return Optional.empty();
        }
        Command command = new Command(ActionMessages.GenerateDelegateMethodsAction_label, COMMAND_ID_ACTION_GENERATEDELEGATEMETHODSPROMPT, Collections.singletonList(params));
        if (this.preferenceManager.getClientPreferences().isSupportedCodeActionKind("source.generate.delegateMethods")) {
            CodeAction codeAction = new CodeAction(ActionMessages.GenerateDelegateMethodsAction_label);
            codeAction.setKind("source.generate.delegateMethods");
            codeAction.setCommand(command);
            codeAction.setDiagnostics(Collections.EMPTY_LIST);
            return Optional.of(Either.forRight((Object)codeAction));
        }
        return Optional.of(Either.forLeft((Object)command));
    }

    private Optional<Either<Command, CodeAction>> convertToWorkspaceEditAction(CodeActionContext context, ICompilationUnit cu, String name, String kind, TextEdit edit) {
        WorkspaceEdit workspaceEdit = SourceAssistProcessor.convertToWorkspaceEdit(cu, edit);
        if (!ChangeUtil.hasChanges(workspaceEdit)) {
            return Optional.empty();
        }
        Command command = new Command(name, "java.apply.workspaceEdit", Collections.singletonList(workspaceEdit));
        if (this.preferenceManager.getClientPreferences().isSupportedCodeActionKind(kind)) {
            CodeAction codeAction = new CodeAction(name);
            codeAction.setKind(kind);
            codeAction.setCommand(command);
            codeAction.setDiagnostics(context.getDiagnostics());
            return Optional.of(Either.forRight((Object)codeAction));
        }
        return Optional.of(Either.forLeft((Object)command));
    }

    private boolean hasFields(IType type, boolean includeStatic) throws JavaModelException {
        IField[] iFieldArray = type.getFields();
        int n = iFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            IField field = iFieldArray[n2];
            if (includeStatic || !JdtFlags.isStatic((IMember)field)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static WorkspaceEdit convertToWorkspaceEdit(ICompilationUnit cu, TextEdit edit) {
        if (cu == null || edit == null) {
            return null;
        }
        WorkspaceEdit workspaceEdit = new WorkspaceEdit();
        TextEditConverter converter = new TextEditConverter(cu, edit);
        String uri = JDTUtils.toURI(cu);
        workspaceEdit.getChanges().put(uri, converter.convert());
        return workspaceEdit;
    }

    public static IType getSelectionType(IInvocationContext context) {
        ICompilationUnit unit = context.getCompilationUnit();
        ASTNode node = context.getCoveredNode();
        if (node == null) {
            node = context.getCoveringNode();
        }
        ITypeBinding typeBinding = null;
        while (node != null && !(node instanceof CompilationUnit)) {
            if (node instanceof AbstractTypeDeclaration) {
                typeBinding = ((AbstractTypeDeclaration)node).resolveBinding();
                break;
            }
            if (node instanceof AnonymousClassDeclaration) {
                typeBinding = ((AnonymousClassDeclaration)node).resolveBinding();
                break;
            }
            node = node.getParent();
        }
        if (typeBinding != null && typeBinding.getJavaElement() instanceof IType) {
            return (IType)typeBinding.getJavaElement();
        }
        return unit.findPrimaryType();
    }

    public static IType getSelectionType(CodeActionParams params) {
        InnovationContext context = SourceAssistProcessor.getInnovationContext(params);
        return context == null ? null : SourceAssistProcessor.getSelectionType(context);
    }

    public static InnovationContext getInnovationContext(CodeActionParams params) {
        ICompilationUnit unit = JDTUtils.resolveCompilationUnit(params.getTextDocument().getUri());
        if (unit == null) {
            return null;
        }
        int start = DiagnosticsHelper.getStartOffset(unit, params.getRange());
        int end = DiagnosticsHelper.getEndOffset(unit, params.getRange());
        InnovationContext context = new InnovationContext(unit, start, end - start);
        CompilationUnit astRoot = CoreASTProvider.getInstance().getAST((ITypeRoot)unit, CoreASTProvider.WAIT_YES, (IProgressMonitor)new NullProgressMonitor());
        context.setASTRoot(astRoot);
        return context;
    }

    public static ICompilationUnit getCompilationUnit(CodeActionParams params) {
        return JDTUtils.resolveCompilationUnit(params.getTextDocument().getUri());
    }
}

