/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.text.correction;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.code.PromoteTempToFieldRefactoring;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.code.ExtractConstantRefactoring;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.code.ExtractFieldRefactoring;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.code.ExtractMethodRefactoring;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.code.ExtractTempRefactoring;
import org.eclipse.jdt.ls.core.internal.corrections.CorrectionMessages;
import org.eclipse.jdt.ls.core.internal.corrections.IInvocationContext;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.CUCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.RefactoringCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.text.correction.CUCorrectionCommandProposal;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.ltk.core.refactoring.Refactoring;

public class ExtractProposalUtility {
    public static final String APPLY_REFACTORING_COMMAND_ID = "java.action.applyRefactoringCommand";
    public static final String EXTRACT_VARIABLE_ALL_OCCURRENCE_COMMAND = "extractVariableAllOccurrence";
    public static final String EXTRACT_VARIABLE_COMMAND = "extractVariable";
    public static final String EXTRACT_CONSTANT_COMMAND = "extractConstant";
    public static final String EXTRACT_METHOD_COMMAND = "extractMethod";
    public static final String EXTRACT_FIELD_COMMAND = "extractField";
    public static final String CONVERT_VARIABLE_TO_FIELD_COMMAND = "convertVariableToField";

    public static List<CUCorrectionProposal> getExtractVariableProposals(CodeActionParams params, IInvocationContext context, boolean problemsAtLocation) throws CoreException {
        return ExtractProposalUtility.getExtractVariableProposals(params, context, problemsAtLocation, false);
    }

    public static List<CUCorrectionProposal> getExtractVariableCommandProposals(CodeActionParams params, IInvocationContext context, boolean problemsAtLocation) throws CoreException {
        return ExtractProposalUtility.getExtractVariableProposals(params, context, problemsAtLocation, true);
    }

    public static CUCorrectionProposal getExtractMethodProposal(CodeActionParams params, IInvocationContext context, ASTNode coveringNode, boolean problemsAtLocation) throws CoreException {
        return ExtractProposalUtility.getExtractMethodProposal(params, context, coveringNode, problemsAtLocation, null, false);
    }

    public static CUCorrectionProposal getExtractMethodCommandProposal(CodeActionParams params, IInvocationContext context, ASTNode coveringNode, boolean problemsAtLocation) throws CoreException {
        return ExtractProposalUtility.getExtractMethodProposal(params, context, coveringNode, problemsAtLocation, null, true);
    }

    private static List<CUCorrectionProposal> getExtractVariableProposals(CodeActionParams params, IInvocationContext context, boolean problemsAtLocation, boolean returnAsCommand) throws CoreException {
        if (!ExtractProposalUtility.supportsExtractVariable(context)) {
            return null;
        }
        ArrayList<CUCorrectionProposal> proposals = new ArrayList<CUCorrectionProposal>();
        CUCorrectionProposal proposal = ExtractProposalUtility.getExtractVariableAllOccurrenceProposal(params, context, problemsAtLocation, null, returnAsCommand);
        if (proposal != null) {
            proposals.add(proposal);
        }
        if ((proposal = ExtractProposalUtility.getExtractVariableProposal(params, context, problemsAtLocation, null, returnAsCommand)) != null) {
            proposals.add(proposal);
        }
        if ((proposal = ExtractProposalUtility.getExtractConstantProposal(params, context, problemsAtLocation, null, returnAsCommand)) != null) {
            proposals.add(proposal);
        }
        return proposals;
    }

    private static boolean supportsExtractVariable(IInvocationContext context) {
        Expression expression;
        ITypeBinding binding;
        ASTNode node = context.getCoveredNode();
        if (!(node instanceof Expression)) {
            if (context.getSelectionLength() != 0) {
                return false;
            }
            node = context.getCoveringNode();
            if (!(node instanceof Expression)) {
                return false;
            }
        }
        return (binding = (expression = (Expression)node).resolveTypeBinding()) != null && !Bindings.isVoidType((ITypeBinding)binding);
    }

    public static CUCorrectionProposal getExtractVariableAllOccurrenceProposal(CodeActionParams params, IInvocationContext context, boolean problemsAtLocation, Map formatterOptions, boolean returnAsCommand) throws CoreException {
        ICompilationUnit cu = context.getCompilationUnit();
        ExtractTempRefactoring extractTempRefactoring = new ExtractTempRefactoring(context.getASTRoot(), context.getSelectionOffset(), context.getSelectionLength(), formatterOptions);
        if (extractTempRefactoring.checkInitialConditions((IProgressMonitor)new NullProgressMonitor()).isOK()) {
            String label = CorrectionMessages.QuickAssistProcessor_extract_to_local_all_description;
            int relevance = context.getSelectionLength() == 0 ? 0 : (problemsAtLocation ? 3 : 6);
            if (returnAsCommand) {
                return new CUCorrectionCommandProposal(label, "refactor.extract.variable", cu, relevance, APPLY_REFACTORING_COMMAND_ID, Arrays.asList(EXTRACT_VARIABLE_ALL_OCCURRENCE_COMMAND, params));
            }
            extractTempRefactoring.setReplaceAllOccurrences(true);
            LinkedProposalModelCore linkedProposalModel = new LinkedProposalModelCore();
            extractTempRefactoring.setLinkedProposalModel(linkedProposalModel);
            extractTempRefactoring.setCheckResultForCompileProblems(false);
            RefactoringCorrectionProposal proposal = new RefactoringCorrectionProposal(label, "refactor.extract.variable", cu, extractTempRefactoring, relevance){

                @Override
                protected void init(Refactoring refactoring) throws CoreException {
                    ExtractTempRefactoring etr = (ExtractTempRefactoring)refactoring;
                    etr.setTempName(etr.guessTempName());
                }
            };
            proposal.setLinkedProposalModel(linkedProposalModel);
            return proposal;
        }
        return null;
    }

    public static CUCorrectionProposal getExtractVariableProposal(CodeActionParams params, IInvocationContext context, boolean problemsAtLocation, Map formatterOptions, boolean returnAsCommand) throws CoreException {
        ICompilationUnit cu = context.getCompilationUnit();
        ExtractTempRefactoring extractTempRefactoringSelectedOnly = new ExtractTempRefactoring(context.getASTRoot(), context.getSelectionOffset(), context.getSelectionLength(), formatterOptions);
        extractTempRefactoringSelectedOnly.setReplaceAllOccurrences(false);
        if (extractTempRefactoringSelectedOnly.checkInitialConditions((IProgressMonitor)new NullProgressMonitor()).isOK()) {
            String label = CorrectionMessages.QuickAssistProcessor_extract_to_local_description;
            int relevance = context.getSelectionLength() == 0 ? -1 : (problemsAtLocation ? 2 : 5);
            if (returnAsCommand) {
                return new CUCorrectionCommandProposal(label, "refactor.extract.variable", cu, relevance, APPLY_REFACTORING_COMMAND_ID, Arrays.asList(EXTRACT_VARIABLE_COMMAND, params));
            }
            LinkedProposalModelCore linkedProposalModel = new LinkedProposalModelCore();
            extractTempRefactoringSelectedOnly.setLinkedProposalModel(linkedProposalModel);
            extractTempRefactoringSelectedOnly.setCheckResultForCompileProblems(false);
            RefactoringCorrectionProposal proposal = new RefactoringCorrectionProposal(label, "refactor.extract.variable", cu, extractTempRefactoringSelectedOnly, relevance){

                @Override
                protected void init(Refactoring refactoring) throws CoreException {
                    ExtractTempRefactoring etr = (ExtractTempRefactoring)refactoring;
                    etr.setTempName(etr.guessTempName());
                }
            };
            proposal.setLinkedProposalModel(linkedProposalModel);
            return proposal;
        }
        return null;
    }

    public static CUCorrectionProposal getGenericExtractFieldProposal(CodeActionParams params, IInvocationContext context, boolean problemsAtLocation, Map formatterOptions, String initializeIn, boolean returnAsCommand) throws CoreException {
        CUCorrectionProposal proposal = ExtractProposalUtility.getConvertVariableToFieldProposal(params, context, problemsAtLocation, formatterOptions, initializeIn, returnAsCommand);
        if (proposal != null) {
            return proposal;
        }
        return ExtractProposalUtility.getExtractFieldProposal(params, context, problemsAtLocation, formatterOptions, initializeIn, returnAsCommand);
    }

    public static CUCorrectionProposal getExtractFieldProposal(CodeActionParams params, IInvocationContext context, boolean problemsAtLocation, Map formatterOptions, String initializeIn, boolean returnAsCommand) throws CoreException {
        if (!ExtractProposalUtility.supportsExtractVariable(context)) {
            return null;
        }
        ICompilationUnit cu = context.getCompilationUnit();
        ExtractFieldRefactoring extractFieldRefactoringSelectedOnly = new ExtractFieldRefactoring(context.getASTRoot(), context.getSelectionOffset(), context.getSelectionLength());
        extractFieldRefactoringSelectedOnly.setFormatterOptions(formatterOptions);
        if (extractFieldRefactoringSelectedOnly.checkInitialConditions((IProgressMonitor)new NullProgressMonitor()).isOK()) {
            InitializeScope scope = InitializeScope.fromName(initializeIn);
            if (scope != null) {
                extractFieldRefactoringSelectedOnly.setInitializeIn(scope.ordinal());
            }
            String label = CorrectionMessages.QuickAssistProcessor_extract_to_field_description;
            int relevance = context.getSelectionLength() == 0 ? -1 : (problemsAtLocation ? 2 : 5);
            if (returnAsCommand) {
                ArrayList<String> scopes = new ArrayList<String>();
                if (extractFieldRefactoringSelectedOnly.canEnableSettingDeclareInMethod()) {
                    scopes.add(InitializeScope.CURRENT_METHOD.getName());
                }
                if (extractFieldRefactoringSelectedOnly.canEnableSettingDeclareInFieldDeclaration()) {
                    scopes.add(InitializeScope.FIELD_DECLARATION.getName());
                }
                if (extractFieldRefactoringSelectedOnly.canEnableSettingDeclareInConstructors()) {
                    scopes.add(InitializeScope.CLASS_CONSTRUCTORS.getName());
                }
                return new CUCorrectionCommandProposal(label, "refactor.extract.field", cu, relevance, APPLY_REFACTORING_COMMAND_ID, Arrays.asList(EXTRACT_FIELD_COMMAND, params, new ExtractFieldInfo(scopes)));
            }
            LinkedProposalModelCore linkedProposalModel = new LinkedProposalModelCore();
            extractFieldRefactoringSelectedOnly.setLinkedProposalModel(linkedProposalModel);
            RefactoringCorrectionProposal proposal = new RefactoringCorrectionProposal(label, "refactor.extract.field", cu, extractFieldRefactoringSelectedOnly, relevance){

                @Override
                protected void init(Refactoring refactoring) throws CoreException {
                    ExtractFieldRefactoring etr = (ExtractFieldRefactoring)refactoring;
                    etr.setFieldName(etr.guessFieldName());
                }
            };
            proposal.setLinkedProposalModel(linkedProposalModel);
            return proposal;
        }
        return null;
    }

    public static CUCorrectionProposal getExtractConstantProposal(CodeActionParams params, IInvocationContext context, boolean problemsAtLocation, Map formatterOptions, boolean returnAsCommand) throws CoreException {
        ICompilationUnit cu = context.getCompilationUnit();
        ExtractConstantRefactoring extractConstRefactoring = new ExtractConstantRefactoring(context.getASTRoot(), context.getSelectionOffset(), context.getSelectionLength(), formatterOptions);
        if (extractConstRefactoring.checkInitialConditions((IProgressMonitor)new NullProgressMonitor()).isOK()) {
            String label = CorrectionMessages.QuickAssistProcessor_extract_to_constant_description;
            int relevance = context.getSelectionLength() == 0 ? -2 : (problemsAtLocation ? 1 : 4);
            if (returnAsCommand) {
                return new CUCorrectionCommandProposal(label, "refactor.extract.constant", cu, relevance, APPLY_REFACTORING_COMMAND_ID, Arrays.asList(EXTRACT_CONSTANT_COMMAND, params));
            }
            LinkedProposalModelCore linkedProposalModel = new LinkedProposalModelCore();
            extractConstRefactoring.setLinkedProposalModel(linkedProposalModel);
            extractConstRefactoring.setCheckResultForCompileProblems(false);
            RefactoringCorrectionProposal proposal = new RefactoringCorrectionProposal(label, "refactor.extract.constant", cu, extractConstRefactoring, relevance){

                @Override
                protected void init(Refactoring refactoring) throws CoreException {
                    ExtractConstantRefactoring etr = (ExtractConstantRefactoring)refactoring;
                    etr.setConstantName(etr.guessConstantName());
                }
            };
            proposal.setLinkedProposalModel(linkedProposalModel);
            return proposal;
        }
        return null;
    }

    public static CUCorrectionProposal getConvertVariableToFieldProposal(CodeActionParams params, IInvocationContext context, boolean problemsAtLocation, Map formatterOptions, String initializeIn, boolean returnAsCommand) throws CoreException {
        SimpleName name;
        IBinding binding;
        ASTNode node = context.getCoveredNode();
        if (!(node instanceof SimpleName)) {
            if (context.getSelectionLength() != 0) {
                return null;
            }
            node = context.getCoveringNode();
            if (!(node instanceof SimpleName)) {
                return null;
            }
        }
        if (!((binding = (name = (SimpleName)node).resolveBinding()) instanceof IVariableBinding)) {
            return null;
        }
        IVariableBinding varBinding = (IVariableBinding)binding;
        if (varBinding.isField() || varBinding.isParameter()) {
            return null;
        }
        ASTNode decl = context.getASTRoot().findDeclaringNode((IBinding)varBinding);
        if (decl == null || decl.getLocationInParent() != VariableDeclarationStatement.FRAGMENTS_PROPERTY) {
            return null;
        }
        PromoteTempToFieldRefactoring refactoring = new PromoteTempToFieldRefactoring((VariableDeclaration)decl);
        refactoring.setFormatterOptions(formatterOptions);
        if (refactoring.checkInitialConditions((IProgressMonitor)new NullProgressMonitor()).isOK()) {
            InitializeScope scope = InitializeScope.fromName(initializeIn);
            if (scope != null) {
                refactoring.setInitializeIn(scope.ordinal());
            }
            String label = CorrectionMessages.QuickAssistProcessor_extract_to_field_description;
            if (returnAsCommand) {
                ArrayList<String> scopes = new ArrayList<String>();
                if (refactoring.canEnableSettingDeclareInMethod()) {
                    scopes.add(InitializeScope.CURRENT_METHOD.getName());
                }
                if (refactoring.canEnableSettingDeclareInFieldDeclaration()) {
                    scopes.add(InitializeScope.FIELD_DECLARATION.getName());
                }
                if (refactoring.canEnableSettingDeclareInConstructors()) {
                    scopes.add(InitializeScope.CLASS_CONSTRUCTORS.getName());
                }
                return new CUCorrectionCommandProposal(label, "refactor.extract.field", context.getCompilationUnit(), 5, APPLY_REFACTORING_COMMAND_ID, Arrays.asList(CONVERT_VARIABLE_TO_FIELD_COMMAND, params, new ExtractFieldInfo(scopes)));
            }
            LinkedProposalModelCore linkedProposalModel = new LinkedProposalModelCore();
            refactoring.setLinkedProposalModel(linkedProposalModel);
            RefactoringCorrectionProposal proposal = new RefactoringCorrectionProposal(label, "refactor.extract.field", context.getCompilationUnit(), (Refactoring)refactoring, 5){

                @Override
                protected void init(Refactoring refactoring) throws CoreException {
                    PromoteTempToFieldRefactoring etr = (PromoteTempToFieldRefactoring)refactoring;
                    String[] names = etr.guessFieldNames();
                    if (names.length > 0) {
                        etr.setFieldName(names[0]);
                    }
                }
            };
            proposal.setLinkedProposalModel(linkedProposalModel);
            return proposal;
        }
        return null;
    }

    public static CUCorrectionProposal getExtractMethodProposal(CodeActionParams params, IInvocationContext context, ASTNode coveringNode, boolean problemsAtLocation, Map formattingOptions, boolean returnAsCommand) throws CoreException {
        if (!(coveringNode instanceof Expression || coveringNode instanceof Statement || coveringNode instanceof Block)) {
            return null;
        }
        if (coveringNode instanceof Block) {
            List statements = ((Block)coveringNode).statements();
            int startIndex = ExtractProposalUtility.getIndex(context.getSelectionOffset(), statements);
            if (startIndex == -1) {
                return null;
            }
            int endIndex = ExtractProposalUtility.getIndex(context.getSelectionOffset() + context.getSelectionLength(), statements);
            if (endIndex == -1 || endIndex <= startIndex) {
                return null;
            }
        }
        ICompilationUnit cu = context.getCompilationUnit();
        ExtractMethodRefactoring extractMethodRefactoring = new ExtractMethodRefactoring(context.getASTRoot(), context.getSelectionOffset(), context.getSelectionLength(), formattingOptions);
        String uniqueMethodName = ExtractProposalUtility.getUniqueMethodName(coveringNode, "extracted");
        extractMethodRefactoring.setMethodName(uniqueMethodName);
        if (extractMethodRefactoring.checkInitialConditions((IProgressMonitor)new NullProgressMonitor()).isOK()) {
            int relevance;
            String label = CorrectionMessages.QuickAssistProcessor_extractmethod_description;
            int n = relevance = problemsAtLocation ? 1 : 4;
            if (returnAsCommand) {
                return new CUCorrectionCommandProposal(label, "refactor.extract.function", cu, relevance, APPLY_REFACTORING_COMMAND_ID, Arrays.asList(EXTRACT_METHOD_COMMAND, params));
            }
            LinkedProposalModelCore linkedProposalModel = new LinkedProposalModelCore();
            extractMethodRefactoring.setLinkedProposalModel(linkedProposalModel);
            RefactoringCorrectionProposal proposal = new RefactoringCorrectionProposal(label, "refactor.extract.function", cu, extractMethodRefactoring, relevance);
            proposal.setLinkedProposalModel(linkedProposalModel);
            return proposal;
        }
        return null;
    }

    private static String getUniqueMethodName(ASTNode astNode, String suggestedName) throws JavaModelException {
        while (astNode != null && !(astNode instanceof TypeDeclaration) && !(astNode instanceof AnonymousClassDeclaration)) {
            astNode = astNode.getParent();
        }
        if (astNode instanceof TypeDeclaration) {
            ITypeBinding typeBinding = ((TypeDeclaration)astNode).resolveBinding();
            if (typeBinding == null) {
                return suggestedName;
            }
            IType type = (IType)typeBinding.getJavaElement();
            if (type == null) {
                return suggestedName;
            }
            IMethod[] methods = type.getMethods();
            int suggestedPostfix = 2;
            String resultName = suggestedName;
            while (suggestedPostfix < 1000) {
                if (!ExtractProposalUtility.hasMethod(methods, resultName)) {
                    return resultName;
                }
                resultName = String.valueOf(suggestedName) + suggestedPostfix++;
            }
        }
        return suggestedName;
    }

    private static boolean hasMethod(IMethod[] methods, String name) {
        IMethod[] iMethodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            if (name.equals(method.getElementName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static int getIndex(int offset, List<Statement> statements) {
        int i = 0;
        while (i < statements.size()) {
            Statement s = statements.get(i);
            if (offset <= s.getStartPosition()) {
                return i;
            }
            if (offset < s.getStartPosition() + s.getLength()) {
                return -1;
            }
            ++i;
        }
        return statements.size();
    }

    public static class ExtractFieldInfo {
        List<String> initializedScopes;

        public ExtractFieldInfo(List<String> scopes) {
            this.initializedScopes = scopes;
        }
    }

    public static enum InitializeScope {
        FIELD_DECLARATION("Field declaration"),
        CURRENT_METHOD("Current method"),
        CLASS_CONSTRUCTORS("Class constructors");

        private final String name;

        private InitializeScope(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static InitializeScope fromName(String name) {
            if (name != null) {
                InitializeScope[] initializeScopeArray = InitializeScope.values();
                int n = initializeScopeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    InitializeScope scope = initializeScopeArray[n2];
                    if (scope.name.equals(name)) {
                        return scope;
                    }
                    ++n2;
                }
            }
            return null;
        }
    }
}

