/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.text.correction;

import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.ls.core.internal.corrections.ASTResolving;
import org.eclipse.jdt.ls.core.internal.corrections.CorrectionMessages;
import org.eclipse.jdt.ls.core.internal.corrections.IInvocationContext;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.ASTRewriteCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.ChangeCorrectionProposal;

public class AdvancedQuickAssistProcessor {
    public static boolean getSplitAndConditionProposals(IInvocationContext context, ASTNode node, Collection<ChangeCorrectionProposal> resultingCollections) {
        InfixExpression.Operator andOperator = InfixExpression.Operator.CONDITIONAL_AND;
        if (!(node instanceof InfixExpression)) {
            return false;
        }
        InfixExpression infixExpression = (InfixExpression)node;
        if (infixExpression.getOperator() != andOperator) {
            return false;
        }
        int offset = AdvancedQuickAssistProcessor.isOperatorSelected(infixExpression, context.getSelectionOffset(), context.getSelectionLength());
        if (offset == -1) {
            return false;
        }
        Statement statement = ASTResolving.findParentStatement((ASTNode)node);
        if (!(statement instanceof IfStatement)) {
            return false;
        }
        IfStatement ifStatement = (IfStatement)statement;
        InfixExpression topInfixExpression = infixExpression;
        while (topInfixExpression.getParent() instanceof InfixExpression && ((InfixExpression)topInfixExpression.getParent()).getOperator() == andOperator) {
            topInfixExpression = (InfixExpression)topInfixExpression.getParent();
        }
        if (ifStatement.getExpression() != topInfixExpression) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        AST ast = ifStatement.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        Expression[] newOperands = new Expression[2];
        AdvancedQuickAssistProcessor.breakInfixOperationAtOperation(rewrite, (Expression)topInfixExpression, andOperator, offset, true, newOperands);
        Expression leftCondition = newOperands[0];
        Expression rightCondition = newOperands[1];
        rewrite.set((ASTNode)ifStatement, (StructuralPropertyDescriptor)IfStatement.EXPRESSION_PROPERTY, (Object)leftCondition, null);
        IfStatement innerIf = ast.newIfStatement();
        innerIf.setExpression(rightCondition);
        innerIf.setThenStatement((Statement)rewrite.createMoveTarget((ASTNode)ifStatement.getThenStatement()));
        Block innerBlock = ast.newBlock();
        innerBlock.statements().add(innerIf);
        Statement elseStatement = ifStatement.getElseStatement();
        if (elseStatement != null) {
            innerIf.setElseStatement((Statement)rewrite.createCopyTarget((ASTNode)elseStatement));
        }
        rewrite.replace((ASTNode)ifStatement.getThenStatement(), (ASTNode)innerBlock, null);
        String label = CorrectionMessages.AdvancedQuickAssistProcessor_splitAndCondition_description;
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, "quickfix", context.getCompilationUnit(), rewrite, 1);
        resultingCollections.add(proposal);
        return true;
    }

    private static boolean isSelectingOperator(ASTNode n1, ASTNode n2, int offset, int length) {
        if (offset + length <= n2.getStartPosition() && offset >= ASTNodes.getExclusiveEnd((ASTNode)n1)) {
            return true;
        }
        if (n1.getStartPosition() == offset && ASTNodes.getExclusiveEnd((ASTNode)n2) == offset + length) {
            return !(n1 instanceof InfixExpression) && !(n2 instanceof InfixExpression);
        }
        return false;
    }

    private static int isOperatorSelected(InfixExpression infixExpression, int offset, int length) {
        Expression right;
        Expression left = infixExpression.getLeftOperand();
        if (AdvancedQuickAssistProcessor.isSelectingOperator((ASTNode)left, (ASTNode)(right = infixExpression.getRightOperand()), offset, length)) {
            return ASTNodes.getExclusiveEnd((ASTNode)left);
        }
        List extended = infixExpression.extendedOperands();
        int i = 0;
        while (i < extended.size()) {
            left = right;
            if (AdvancedQuickAssistProcessor.isSelectingOperator((ASTNode)left, (ASTNode)(right = (ASTNode)extended.get(i)), offset, length)) {
                return ASTNodes.getExclusiveEnd((ASTNode)left);
            }
            ++i;
        }
        return -1;
    }

    public static boolean getSplitOrConditionProposals(IInvocationContext context, ASTNode node, Collection<ChangeCorrectionProposal> resultingCollections) {
        InfixExpression.Operator orOperator = InfixExpression.Operator.CONDITIONAL_OR;
        if (!(node instanceof InfixExpression)) {
            return false;
        }
        InfixExpression infixExpression = (InfixExpression)node;
        if (infixExpression.getOperator() != orOperator) {
            return false;
        }
        int offset = AdvancedQuickAssistProcessor.isOperatorSelected(infixExpression, context.getSelectionOffset(), context.getSelectionLength());
        if (offset == -1) {
            return false;
        }
        Statement statement = ASTResolving.findParentStatement((ASTNode)node);
        if (!(statement instanceof IfStatement)) {
            return false;
        }
        IfStatement ifStatement = (IfStatement)statement;
        InfixExpression topInfixExpression = infixExpression;
        while (topInfixExpression.getParent() instanceof InfixExpression && ((InfixExpression)topInfixExpression.getParent()).getOperator() == orOperator) {
            topInfixExpression = (InfixExpression)topInfixExpression.getParent();
        }
        if (ifStatement.getExpression() != topInfixExpression) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        AST ast = ifStatement.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        Expression[] newOperands = new Expression[2];
        AdvancedQuickAssistProcessor.breakInfixOperationAtOperation(rewrite, (Expression)topInfixExpression, orOperator, offset, true, newOperands);
        Expression leftCondition = newOperands[0];
        Expression rightCondition = newOperands[1];
        rewrite.replace((ASTNode)ifStatement.getExpression(), (ASTNode)leftCondition, null);
        IfStatement secondIf = ast.newIfStatement();
        secondIf.setExpression(rightCondition);
        secondIf.setThenStatement((Statement)rewrite.createCopyTarget((ASTNode)ifStatement.getThenStatement()));
        Statement elseStatement = ifStatement.getElseStatement();
        if (elseStatement == null) {
            rewrite.set((ASTNode)ifStatement, (StructuralPropertyDescriptor)IfStatement.ELSE_STATEMENT_PROPERTY, (Object)secondIf, null);
        } else {
            rewrite.replace((ASTNode)elseStatement, (ASTNode)secondIf, null);
            secondIf.setElseStatement((Statement)rewrite.createMoveTarget((ASTNode)elseStatement));
        }
        String label = CorrectionMessages.AdvancedQuickAssistProcessor_splitOrCondition_description;
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, "quickfix", context.getCompilationUnit(), rewrite, 1);
        resultingCollections.add(proposal);
        return true;
    }

    private static void breakInfixOperationAtOperation(ASTRewrite rewrite, Expression expression, InfixExpression.Operator operator, int operatorOffset, boolean removeParentheses, Expression[] res) {
        if (expression.getStartPosition() + expression.getLength() <= operatorOffset) {
            res[0] = AdvancedQuickAssistProcessor.combineOperands(rewrite, res[0], expression, removeParentheses, operator);
            return;
        }
        if (operatorOffset <= expression.getStartPosition()) {
            res[1] = AdvancedQuickAssistProcessor.combineOperands(rewrite, res[1], expression, removeParentheses, operator);
            return;
        }
        if (!(expression instanceof InfixExpression)) {
            throw new IllegalArgumentException("Cannot break up non-infix expression");
        }
        InfixExpression infixExpression = (InfixExpression)expression;
        if (infixExpression.getOperator() != operator) {
            throw new IllegalArgumentException("Incompatible operator");
        }
        AdvancedQuickAssistProcessor.breakInfixOperationAtOperation(rewrite, infixExpression.getLeftOperand(), operator, operatorOffset, removeParentheses, res);
        AdvancedQuickAssistProcessor.breakInfixOperationAtOperation(rewrite, infixExpression.getRightOperand(), operator, operatorOffset, removeParentheses, res);
        List extended = infixExpression.extendedOperands();
        int i = 0;
        while (i < extended.size()) {
            AdvancedQuickAssistProcessor.breakInfixOperationAtOperation(rewrite, (Expression)extended.get(i), operator, operatorOffset, removeParentheses, res);
            ++i;
        }
    }

    private static Expression combineOperands(ASTRewrite rewrite, Expression existing, Expression originalNode, boolean removeParentheses, InfixExpression.Operator operator) {
        if (existing == null && removeParentheses) {
            while (originalNode instanceof ParenthesizedExpression) {
                originalNode = ((ParenthesizedExpression)originalNode).getExpression();
            }
        }
        Expression newRight = (Expression)rewrite.createMoveTarget((ASTNode)originalNode);
        if (originalNode instanceof InfixExpression) {
            ((InfixExpression)newRight).setOperator(((InfixExpression)originalNode).getOperator());
        }
        if (existing == null) {
            return newRight;
        }
        AST ast = rewrite.getAST();
        InfixExpression infix = ast.newInfixExpression();
        infix.setOperator(operator);
        infix.setLeftOperand(existing);
        infix.setRightOperand(newRight);
        return infix;
    }
}

