/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.managers;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;

public class UpdateClasspathJob
extends WorkspaceJob {
    private static final long SCHEDULE_DELAY = 1000L;
    private final Set<UpdateClasspathRequest> queue = new LinkedHashSet<UpdateClasspathRequest>();
    private static final UpdateClasspathJob instance = new UpdateClasspathJob();

    UpdateClasspathJob() {
        super("Update classpath Job");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        ArrayList<UpdateClasspathRequest> requests;
        Set<UpdateClasspathRequest> set = this.queue;
        synchronized (set) {
            requests = new ArrayList<UpdateClasspathRequest>(this.queue);
            this.queue.clear();
        }
        Map reqPerProject = requests.stream().collect(Collectors.groupingBy(UpdateClasspathRequest::getProject, Collectors.mapping(UpdateClasspathRequest::getLibPath, Collectors.toSet())));
        for (Map.Entry reqs : reqPerProject.entrySet()) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            this.updateClasspath(reqs.getKey(), reqs.getValue(), monitor);
        }
        Set<UpdateClasspathRequest> set2 = this.queue;
        synchronized (set2) {
            if (!this.queue.isEmpty()) {
                this.schedule(1000L);
            }
        }
        return Status.OK_STATUS;
    }

    private void updateClasspath(IJavaProject project, Set<IPath> libFolders, IProgressMonitor monitor) throws CoreException {
        ProjectUtils.updateBinaries(project, libFolders, monitor);
    }

    public void updateClasspath(IJavaProject project, IPath libPath) {
        if (project == null || libPath == null) {
            return;
        }
        this.queue(new UpdateClasspathRequest(project, libPath));
        this.schedule(1000L);
    }

    void update(UpdateClasspathRequest updateRequest) {
        this.queue(updateRequest);
        this.schedule(1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void queue(UpdateClasspathRequest updateRequest) {
        Set<UpdateClasspathRequest> set = this.queue;
        synchronized (set) {
            this.queue.add(updateRequest);
        }
    }

    public static UpdateClasspathJob getInstance() {
        return instance;
    }

    static class UpdateClasspathRequest {
        private IJavaProject project;
        private IPath libPath;

        UpdateClasspathRequest(IJavaProject project, IPath libPath) {
            this.project = project;
            this.libPath = libPath;
        }

        IPath getLibPath() {
            return this.libPath;
        }

        public int hashCode() {
            return Objects.hash(this.libPath, this.project);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UpdateClasspathRequest other = (UpdateClasspathRequest)obj;
            return Objects.equals(this.libPath, other.libPath) && Objects.equals(this.project, other.project);
        }

        IJavaProject getProject() {
            return this.project;
        }
    }
}

