/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.managers;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.launching.environments.IExecutionEnvironmentsManager;
import org.eclipse.jdt.ls.core.internal.ActionableNotification;
import org.eclipse.jdt.ls.core.internal.IProjectImporter;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JVMConfigurator;
import org.eclipse.jdt.ls.core.internal.JavaClientConnection;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.JobHelpers;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.ServiceStatus;
import org.eclipse.jdt.ls.core.internal.StatusFactory;
import org.eclipse.jdt.ls.core.internal.managers.DefaultProjectBuildSupport;
import org.eclipse.jdt.ls.core.internal.managers.EclipseBuildSupport;
import org.eclipse.jdt.ls.core.internal.managers.FormatterManager;
import org.eclipse.jdt.ls.core.internal.managers.GradleBuildSupport;
import org.eclipse.jdt.ls.core.internal.managers.IBuildSupport;
import org.eclipse.jdt.ls.core.internal.managers.InvisibleProjectBuildSupport;
import org.eclipse.jdt.ls.core.internal.managers.MavenBuildSupport;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.jdt.ls.core.internal.preferences.Preferences;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.DidChangeWatchedFilesRegistrationOptions;
import org.eclipse.lsp4j.FileSystemWatcher;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.TextDocumentIdentifier;

public class ProjectsManager
implements ISaveParticipant {
    public static final String DEFAULT_PROJECT_NAME = "jdt.ls-java-project";
    private static final Set<String> watchers = new LinkedHashSet<String>();
    private PreferenceManager preferenceManager;
    private JavaClientConnection.JavaLanguageClient client;
    private static final List<String> basicWatchers = Arrays.asList("**/*.java", "**/pom.xml", "**/*.gradle", "**/gradle.properties", "**/.project", "**/.classpath", "**/.settings/*.prefs", "**/src/**");
    private Job registerWatcherJob = new Job("Register Watchers"){

        protected IStatus run(IProgressMonitor monitor) {
            JobHelpers.waitForJobsToComplete();
            ProjectsManager.this.registerWatchers();
            return Status.OK_STATUS;
        }
    };

    public ProjectsManager(PreferenceManager preferenceManager) {
        this.preferenceManager = preferenceManager;
    }

    public void initializeProjects(Collection<IPath> rootPaths, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        this.deleteInvalidProjects(rootPaths, (IProgressMonitor)subMonitor.split(10));
        GradleBuildSupport.cleanGradleModels((IProgressMonitor)subMonitor.split(10));
        this.createJavaProject(this.getDefaultProject(), (IProgressMonitor)subMonitor.split(10));
        this.cleanupResources(this.getDefaultProject());
        this.importProjects(rootPaths, (IProgressMonitor)subMonitor.split(70));
        subMonitor.done();
    }

    private void importProjects(Collection<IPath> rootPaths, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(rootPaths.size() * 100));
        for (IPath rootPath : rootPaths) {
            File rootFolder = rootPath.toFile();
            IProjectImporter importer = this.getImporter(rootFolder, (IProgressMonitor)subMonitor.split(30));
            if (importer == null) continue;
            importer.importToWorkspace((IProgressMonitor)subMonitor.split(70));
        }
    }

    public Job updateWorkspaceFolders(final Collection<IPath> addedRootPaths, final Collection<IPath> removedRootPaths) {
        Job[] removedJobs;
        JavaLanguageServerPlugin.sendStatus(ServiceStatus.Message, "Updating workspace folders: Adding " + addedRootPaths.size() + " folder(s), removing " + removedRootPaths.size() + " folders.");
        Job[] jobArray = removedJobs = Job.getJobManager().find(removedRootPaths);
        int n = removedJobs.length;
        int n2 = 0;
        while (n2 < n) {
            Job removedJob = jobArray[n2];
            if (removedJob.belongsTo((Object)"org.eclipse.jdt.ls.core.jobs.updateWorkspaceFolders") || removedJob.belongsTo((Object)"java-ls-initialization-jobs")) {
                removedJob.cancel();
            }
            ++n2;
        }
        WorkspaceJob job = new WorkspaceJob("Updating workspace folders"){

            public boolean belongsTo(Object family) {
                Collection addedRootPathsSet = addedRootPaths.stream().collect(Collectors.toSet());
                boolean equalToRootPaths = false;
                if (family instanceof Collection) {
                    equalToRootPaths = addedRootPathsSet.equals(((Collection)family).stream().collect(Collectors.toSet()));
                }
                return "org.eclipse.jdt.ls.core.jobs.updateWorkspaceFolders".equals(family) || "org.eclipse.jdt.ls.core.jobs".equals(family) || equalToRootPaths;
            }

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                IStatus status = Status.OK_STATUS;
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(addedRootPaths.size() + removedRootPaths.size()));
                try {
                    IProject[] projects;
                    long start = System.currentTimeMillis();
                    IProject[] iProjectArray = projects = ProjectsManager.getWorkspaceRoot().getProjects();
                    int n = projects.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IProject project = iProjectArray[n2];
                        if (ResourceUtils.isContainedIn(project.getLocation(), removedRootPaths)) {
                            try {
                                project.delete(false, true, (IProgressMonitor)subMonitor.split(1));
                            }
                            catch (CoreException e) {
                                JavaLanguageServerPlugin.logException("Problems removing '" + project.getName() + "' from workspace.", e);
                            }
                        }
                        ++n2;
                    }
                    ProjectsManager.this.importProjects(addedRootPaths, (IProgressMonitor)subMonitor.split(addedRootPaths.size()));
                    ProjectsManager.this.registerWatcherJob.schedule();
                    long elapsed = System.currentTimeMillis() - start;
                    JavaLanguageServerPlugin.logInfo("Updated workspace folders in " + elapsed + " ms: Added " + addedRootPaths.size() + " folder(s), removed" + removedRootPaths.size() + " folders.");
                    JavaLanguageServerPlugin.logInfo(ProjectsManager.this.getWorkspaceInfo());
                    return Status.OK_STATUS;
                }
                catch (CoreException e) {
                    String msg = "Error updating workspace folders";
                    JavaLanguageServerPlugin.logError(msg);
                    status = StatusFactory.newErrorStatus(msg, e);
                    GradleBuildSupport.cleanGradleModels(monitor);
                    return status;
                }
            }
        };
        job.setRule((ISchedulingRule)ProjectsManager.getWorkspaceRoot());
        job.schedule();
        return job;
    }

    public void cleanupResources(IProject project) throws CoreException {
        IJavaProject javaProj = JavaCore.create((IProject)project);
        if (javaProj == null) {
            return;
        }
        Arrays.stream(javaProj.getPackageFragments()).filter(packageFragment -> {
            try {
                return packageFragment.containsJavaResources() && packageFragment.getKind() == 1;
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException("Unable to collect " + project.getName() + "' package fragements", e);
                return false;
            }
        }).flatMap(packageFragment -> {
            try {
                return Arrays.stream(packageFragment.getCompilationUnits());
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException("Unable to collect " + project.getName() + "'s compilation units", e);
                return null;
            }
        }).forEach(cu -> {
            try {
                File f;
                IResource resource = cu.getResource();
                if (resource.isLinked() && !(f = new File(cu.getUnderlyingResource().getLocationURI())).exists()) {
                    cu.delete(true, null);
                }
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException("Unable to delete missing compilation unit (" + cu.getElementName() + ") from " + project.getName(), e);
            }
        });
    }

    private void deleteInvalidProjects(Collection<IPath> rootPaths, IProgressMonitor monitor) {
        List workspaceProjects = rootPaths.stream().map(rootPath -> ProjectUtils.getWorkspaceInvisibleProjectName(rootPath)).collect(Collectors.toList());
        IProject[] iProjectArray = ProjectsManager.getWorkspaceRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (!project.equals((Object)this.getDefaultProject())) {
                if (project.exists() && (ResourceUtils.isContainedIn(project.getLocation(), rootPaths) || ProjectUtils.isGradleProject(project)) || workspaceProjects.contains(project.getName())) {
                    try {
                        project.getDescription();
                    }
                    catch (CoreException e) {
                        try {
                            project.delete(true, monitor);
                        }
                        catch (CoreException e1) {
                            JavaLanguageServerPlugin.logException(e1.getMessage(), e1);
                        }
                    }
                } else {
                    try {
                        project.delete(false, true, monitor);
                    }
                    catch (CoreException e1) {
                        JavaLanguageServerPlugin.logException(e1.getMessage(), e1);
                    }
                }
            }
            ++n2;
        }
    }

    private static IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public void fileChanged(String uriString, CHANGE_TYPE changeType) {
        block15: {
            if (uriString == null) {
                return;
            }
            IResource resource = JDTUtils.getFileOrFolder(uriString);
            if (resource == null) {
                return;
            }
            String formatterUrl = this.preferenceManager.getPreferences().getFormatterUrl();
            if (formatterUrl != null) {
                try {
                    URL url = this.getUrl(formatterUrl);
                    if (url != null) {
                        URI formatterUri = url.toURI();
                        URI uri = JDTUtils.toURI(uriString);
                        if (uri != null && uri.equals(formatterUri) && JavaLanguageServerPlugin.getInstance().getProtocol() != null) {
                            if (changeType == CHANGE_TYPE.DELETED || changeType == CHANGE_TYPE.CREATED) {
                                this.registerWatchers();
                            }
                            FormatterManager.configureFormatter(this.preferenceManager, this);
                        }
                    }
                }
                catch (URISyntaxException url) {
                    // empty catch block
                }
            }
            try {
                IBuildSupport buildSupport;
                boolean requireConfigurationUpdate;
                Optional<IBuildSupport> bs = this.getBuildSupport(resource.getProject());
                if (!bs.isPresent() || !(requireConfigurationUpdate = (buildSupport = bs.get()).fileChanged(resource, changeType, (IProgressMonitor)new NullProgressMonitor()))) break block15;
                Preferences.FeatureStatus status = this.preferenceManager.getPreferences().getUpdateBuildConfigurationStatus();
                switch (status) {
                    case automatic: {
                        this.updateProject(resource.getProject(), false);
                        break;
                    }
                    case disabled: {
                        break;
                    }
                    default: {
                        if (this.client != null) {
                            String cmd = "java.projectConfiguration.status";
                            TextDocumentIdentifier uri = new TextDocumentIdentifier(uriString);
                            ActionableNotification updateProjectConfigurationNotification = new ActionableNotification().withSeverity(MessageType.Info).withMessage("A build file was modified. Do you want to synchronize the Java classpath/configuration?").withCommands(Arrays.asList(new Command("Never", cmd, Arrays.asList(new Object[]{uri, Preferences.FeatureStatus.disabled})), new Command("Now", cmd, Arrays.asList(new Object[]{uri, Preferences.FeatureStatus.interactive})), new Command("Always", cmd, Arrays.asList(new Object[]{uri, Preferences.FeatureStatus.automatic}))));
                            this.client.sendActionableNotification(updateProjectConfigurationNotification);
                        }
                        break;
                    }
                }
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException("Problem refreshing workspace", e);
            }
        }
    }

    public URL getUrl(String formatterUrl) {
        URL url;
        block4: {
            url = null;
            try {
                url = new URL(ResourceUtils.toClientUri(formatterUrl));
            }
            catch (MalformedURLException e1) {
                File file = this.findFile(formatterUrl);
                if (file == null || !file.isFile()) break block4;
                try {
                    url = file.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    JavaLanguageServerPlugin.logInfo("Invalid formatter:" + formatterUrl);
                }
            }
        }
        return url;
    }

    public boolean isBuildFile(IResource resource) {
        return this.buildSupports().filter(bs -> bs.isBuildFile(resource)).findAny().isPresent();
    }

    private IProjectImporter getImporter(File rootFolder, IProgressMonitor monitor) throws OperationCanceledException, CoreException {
        Collection<IProjectImporter> importers = this.importers();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)importers.size());
        for (IProjectImporter importer : importers) {
            importer.initialize(rootFolder);
            if (!importer.applies((IProgressMonitor)subMonitor.split(1))) continue;
            return importer;
        }
        return null;
    }

    public IProject getDefaultProject() {
        return ProjectsManager.getWorkspaceRoot().getProject(DEFAULT_PROJECT_NAME);
    }

    private Collection<IProjectImporter> importers() {
        TreeMap<Integer, IProjectImporter> importers = new TreeMap<Integer, IProjectImporter>();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.jdt.ls.core", "importers");
        IConfigurationElement[] configs = extensionPoint.getConfigurationElements();
        int i = 0;
        while (i < configs.length) {
            try {
                Integer order = Integer.valueOf(configs[i].getAttribute("order"));
                importers.put(order, (IProjectImporter)configs[i].createExecutableExtension("class"));
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.log(e.getStatus());
            }
            ++i;
        }
        return importers.values();
    }

    public IProject createJavaProject(IProject project, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        return this.createJavaProject(project, null, "src", "bin", monitor);
    }

    public IProject createJavaProject(IProject project, IPath projectLocation, String src, String bin, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        if (project.exists()) {
            return project;
        }
        JavaLanguageServerPlugin.logInfo("Creating the Java project " + project.getName());
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(project.getName());
        if (projectLocation != null) {
            description.setLocation(projectLocation);
        }
        project.create(description, monitor);
        project.open(monitor);
        description = project.getDescription();
        description.setNatureIds(new String[]{"org.eclipse.jdt.core.javanature"});
        project.setDescription(description, monitor);
        IJavaProject javaProject = JavaCore.create((IProject)project);
        JVMConfigurator.configureJVMSettings(javaProject);
        if (StringUtils.isNotBlank((String)bin)) {
            IFolder output = project.getFolder(bin);
            if (!output.exists()) {
                output.create(true, true, monitor);
            }
            javaProject.setOutputLocation(output.getFullPath(), monitor);
        }
        ArrayList<IClasspathEntry> classpaths = new ArrayList<IClasspathEntry>();
        if (StringUtils.isNotBlank((String)src)) {
            IFolder source = project.getFolder(src);
            if (!source.exists()) {
                source.create(true, true, monitor);
            }
            IPackageFragmentRoot root = javaProject.getPackageFragmentRoot((IResource)source);
            IClasspathEntry srcClasspath = JavaCore.newSourceEntry((IPath)root.getPath());
            classpaths.add(srcClasspath);
        }
        IClasspathEntry jre = JavaRuntime.getDefaultJREContainerEntry();
        classpaths.add(jre);
        javaProject.setRawClasspath(classpaths.toArray(new IClasspathEntry[0]), monitor);
        JavaLanguageServerPlugin.logInfo("Finished creating the Java project " + project.getName());
        return project;
    }

    public Job updateProject(final IProject project, final boolean force) {
        if (project == null || !ProjectUtils.isMavenProject(project) && !ProjectUtils.isGradleProject(project)) {
            return null;
        }
        JavaLanguageServerPlugin.sendStatus(ServiceStatus.Message, "Updating " + project.getName() + " configuration");
        WorkspaceJob job = new WorkspaceJob("Update project " + project.getName()){

            public boolean belongsTo(Object family) {
                return "org.eclipse.jdt.ls.core.jobs.updateProject".equals(family) || ("org.eclipse.jdt.ls.core.jobs." + project.getName()).equals(family) || "org.eclipse.jdt.ls.core.jobs".equals(family);
            }

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                IStatus status = Status.OK_STATUS;
                String projectName = project.getName();
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100).checkCanceled();
                try {
                    long start = System.currentTimeMillis();
                    project.refreshLocal(2, (IProgressMonitor)progress.split(5));
                    Optional<IBuildSupport> buildSupport = ProjectsManager.this.getBuildSupport(project);
                    if (buildSupport.isPresent()) {
                        buildSupport.get().update(project, force, (IProgressMonitor)progress.split(95));
                        ProjectsManager.this.registerWatcherJob.schedule();
                    }
                    long elapsed = System.currentTimeMillis() - start;
                    JavaLanguageServerPlugin.logInfo("Updated " + projectName + " in " + elapsed + " ms");
                }
                catch (CoreException e) {
                    String msg = "Error updating " + projectName;
                    JavaLanguageServerPlugin.logError(msg);
                    status = StatusFactory.newErrorStatus(msg, e);
                }
                return status;
            }
        };
        job.schedule();
        return job;
    }

    public Optional<IBuildSupport> getBuildSupport(IProject project) {
        return this.buildSupports().filter(bs -> bs.applies(project)).findFirst();
    }

    private Stream<IBuildSupport> buildSupports() {
        return Stream.of(new GradleBuildSupport(), new MavenBuildSupport(), new InvisibleProjectBuildSupport(), new DefaultProjectBuildSupport(this), new EclipseBuildSupport());
    }

    public void setConnection(JavaClientConnection.JavaLanguageClient client) {
        this.client = client;
    }

    private String getWorkspaceInfo() {
        StringBuilder b = new StringBuilder();
        b.append("Projects:\n");
        IProject[] iProjectArray = ProjectsManager.getWorkspaceRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            b.append(project.getName()).append(": ").append(project.getLocation().toOSString()).append('\n');
            if (ProjectUtils.isJavaProject(project)) {
                IJavaProject javaProject = JavaCore.create((IProject)project);
                try {
                    IClasspathEntry[] cpEntries;
                    b.append("  resolved classpath:\n");
                    IClasspathEntry[] iClasspathEntryArray = cpEntries = javaProject.getRawClasspath();
                    int n3 = cpEntries.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IClasspathEntry cpe = iClasspathEntryArray[n4];
                        b.append("  ").append(cpe.getPath().toString()).append('\n');
                        if (cpe.getEntryKind() == 5) {
                            IPackageFragmentRoot[] roots;
                            IPackageFragmentRoot[] iPackageFragmentRootArray = roots = javaProject.findPackageFragmentRoots(cpe);
                            int n5 = roots.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                IPackageFragmentRoot root = iPackageFragmentRootArray[n6];
                                b.append("    ").append(root.getPath().toString()).append('\n');
                                ++n6;
                            }
                        }
                        ++n4;
                    }
                }
                catch (CoreException coreException) {}
            } else {
                b.append("  non-Java project\n");
            }
            ++n2;
        }
        b.append("Java Runtimes:\n");
        IVMInstall defaultVMInstall = JavaRuntime.getDefaultVMInstall();
        b.append("  default: ");
        if (defaultVMInstall != null) {
            b.append(defaultVMInstall.getInstallLocation().toString());
        } else {
            b.append("-");
        }
        IExecutionEnvironmentsManager eem = JavaRuntime.getExecutionEnvironmentsManager();
        IExecutionEnvironment[] iExecutionEnvironmentArray = eem.getExecutionEnvironments();
        int n7 = iExecutionEnvironmentArray.length;
        int n8 = 0;
        while (n8 < n7) {
            IExecutionEnvironment ee = iExecutionEnvironmentArray[n8];
            IVMInstall[] vms = ee.getCompatibleVMs();
            b.append("  ").append(ee.getDescription()).append(": ");
            if (vms.length > 0) {
                b.append(vms[0].getInstallLocation().toString());
            } else {
                b.append("-");
            }
            b.append("\n");
            ++n8;
        }
        return b.toString();
    }

    public void doneSaving(ISaveContext context) {
    }

    public void prepareToSave(ISaveContext context) throws CoreException {
        if (context.getKind() == 1) {
            GradleBuildSupport.saveModels();
        }
    }

    public void rollback(ISaveContext context) {
    }

    public void saving(ISaveContext context) throws CoreException {
    }

    public boolean setAutoBuilding(boolean enable) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription description = workspace.getDescription();
        boolean changed = description.isAutoBuilding() ^ enable;
        if (changed) {
            description.setAutoBuilding(enable);
            workspace.setDescription(description);
        }
        return changed;
    }

    public List<FileSystemWatcher> registerWatchers() {
        JavaLanguageServerPlugin.logInfo(">> registerFeature 'workspace/didChangeWatchedFiles'");
        if (this.preferenceManager.getClientPreferences().isWorkspaceChangeWatchedFilesDynamicRegistered()) {
            HashSet<IPath> sources = new HashSet<IPath>();
            try {
                IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                IProject[] iProjectArray = projects;
                int n = projects.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaProject javaProject;
                    IProject project = iProjectArray[n2];
                    if (!DEFAULT_PROJECT_NAME.equals(project.getName()) && (javaProject = JavaCore.create((IProject)project)) != null && javaProject.exists()) {
                        IPath libFolderPath;
                        IPath realFolderPath;
                        IClasspathEntry[] classpath;
                        IClasspathEntry[] iClasspathEntryArray = classpath = javaProject.getRawClasspath();
                        int n3 = classpath.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IPath location;
                            IFolder folder;
                            IPath path;
                            IClasspathEntry entry = iClasspathEntryArray[n4];
                            if (!(entry.getEntryKind() != 3 || (path = entry.getPath()) == null || path.toString().contains("/src/") || path.toString().endsWith("/src") || !(folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(path)).exists() || folder.isDerived() || (location = folder.getLocation()) == null || ResourceUtils.isContainedIn(location, sources))) {
                                sources.add(location);
                            }
                            if (entry.getEntryKind() == 1) {
                                path = entry.getPath();
                                IFile resource = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
                                if (resource != null && !resource.isDerived() && (location = resource.getLocation()) != null && !ResourceUtils.isContainedIn(location, sources)) {
                                    sources.add(location);
                                }
                            }
                            ++n4;
                        }
                        if (!ProjectUtils.isVisibleProject(project) && (realFolderPath = project.getFolder("_").getLocation()) != null && !ResourceUtils.isContainedIn(libFolderPath = realFolderPath.append("lib"), sources)) {
                            sources.add(libFolderPath);
                        }
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                JavaLanguageServerPlugin.logException(e.getMessage(), e);
            }
            ArrayList<FileSystemWatcher> fileWatchers = new ArrayList<FileSystemWatcher>();
            String formatterUrl = this.preferenceManager.getPreferences().getFormatterUrl();
            if (formatterUrl != null) {
                Path formatterPath;
                File file = new File(formatterUrl);
                if (!file.isFile()) {
                    file = this.findFile(formatterUrl);
                }
                if (file != null && file.isFile() && !ResourceUtils.isContainedIn((IPath)(formatterPath = new Path(file.getAbsolutePath())), sources)) {
                    sources.add((IPath)formatterPath);
                }
            }
            LinkedHashSet<String> patterns = new LinkedHashSet<String>(basicWatchers);
            patterns.addAll(sources.stream().map(ResourceUtils::toGlobPattern).collect(Collectors.toList()));
            for (String pattern : patterns) {
                FileSystemWatcher watcher = new FileSystemWatcher(pattern);
                fileWatchers.add(watcher);
            }
            if (!patterns.equals(watchers)) {
                JavaLanguageServerPlugin.logInfo(">> registerFeature 'workspace/didChangeWatchedFiles'");
                DidChangeWatchedFilesRegistrationOptions didChangeWatchedFilesRegistrationOptions = new DidChangeWatchedFilesRegistrationOptions(fileWatchers);
                JavaLanguageServerPlugin.getInstance().unregisterCapability(Preferences.WORKSPACE_WATCHED_FILES_ID, "workspace/didChangeWatchedFiles");
                JavaLanguageServerPlugin.getInstance().registerCapability(Preferences.WORKSPACE_WATCHED_FILES_ID, "workspace/didChangeWatchedFiles", didChangeWatchedFilesRegistrationOptions);
                watchers.clear();
                watchers.addAll(patterns);
            }
            return fileWatchers;
        }
        return Collections.emptyList();
    }

    public File findFile(String formatterUrl) {
        File file = new File(formatterUrl);
        if (file.exists()) {
            return file;
        }
        Collection<IPath> rootPaths = this.preferenceManager.getPreferences().getRootPaths();
        if (rootPaths != null) {
            for (IPath rootPath : rootPaths) {
                File f = new File(rootPath.toOSString(), formatterUrl);
                if (!f.isFile()) continue;
                return f;
            }
        }
        return null;
    }

    public static enum CHANGE_TYPE {
        CREATED,
        CHANGED,
        DELETED;

    }
}

