/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.managers;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.managers.EclipseBuildSupport;
import org.eclipse.jdt.ls.core.internal.managers.IBuildSupport;
import org.eclipse.jdt.ls.core.internal.managers.ProjectsManager;
import org.eclipse.jdt.ls.core.internal.managers.UpdateClasspathJob;

public class InvisibleProjectBuildSupport
extends EclipseBuildSupport
implements IBuildSupport {
    static final String LIB_FOLDER = "lib";

    @Override
    public boolean applies(IProject project) {
        return project != null && project.isAccessible() && !ProjectUtils.isVisibleProject(project);
    }

    @Override
    public boolean fileChanged(IResource resource, ProjectsManager.CHANGE_TYPE changeType, IProgressMonitor monitor) throws CoreException {
        IPath libFolderPath;
        if (resource == null || !this.applies(resource.getProject())) {
            return false;
        }
        this.refresh(resource, changeType, monitor);
        IProject invisibleProject = resource.getProject();
        IPath realFolderPath = invisibleProject.getFolder("_").getLocation();
        if (realFolderPath != null && (libFolderPath = realFolderPath.append(LIB_FOLDER)).isPrefixOf(resource.getLocation())) {
            UpdateClasspathJob.getInstance().updateClasspath(JavaCore.create((IProject)invisibleProject), libFolderPath);
        }
        return false;
    }
}

