/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.managers;

import java.io.File;
import java.io.FilenameFilter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.buildship.core.BuildConfiguration;
import org.eclipse.buildship.core.GradleCore;
import org.eclipse.buildship.core.GradleDistribution;
import org.eclipse.buildship.core.SynchronizationResult;
import org.eclipse.buildship.core.WrapperGradleDistribution;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.preferences.PersistentModel;
import org.eclipse.buildship.core.internal.util.gradle.GradleVersion;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.ls.core.internal.AbstractProjectImporter;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.managers.BasicFileDetector;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;

public class GradleProjectImporter
extends AbstractProjectImporter {
    public static final String GRADLE_HOME = "GRADLE_HOME";
    private static final String BUILD_GRADLE_DESCRIPTOR = "build.gradle";
    public static final GradleDistribution DEFAULT_DISTRIBUTION = GradleDistribution.forVersion((String)GradleVersion.current().getVersion());
    public static final String IMPORTING_GRADLE_PROJECTS = "Importing Gradle project(s)";
    private Collection<Path> directories;

    @Override
    public boolean applies(IProgressMonitor monitor) throws CoreException {
        if (this.rootFolder == null) {
            return false;
        }
        PreferenceManager preferencesManager = JavaLanguageServerPlugin.getPreferencesManager();
        if (preferencesManager != null && !preferencesManager.getPreferences().isImportGradleEnabled()) {
            return false;
        }
        if (this.directories == null) {
            BasicFileDetector gradleDetector = new BasicFileDetector(this.rootFolder.toPath(), BUILD_GRADLE_DESCRIPTOR).includeNested(false).addExclusions("**/build");
            this.directories = gradleDetector.scan(monitor);
        }
        return !this.directories.isEmpty();
    }

    @Override
    public void importToWorkspace(IProgressMonitor monitor) throws CoreException {
        if (!this.applies(monitor)) {
            return;
        }
        int projectSize = this.directories.size();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(projectSize + 1));
        subMonitor.setTaskName(IMPORTING_GRADLE_PROJECTS);
        JavaLanguageServerPlugin.logInfo(IMPORTING_GRADLE_PROJECTS);
        subMonitor.worked(1);
        this.directories.forEach(d -> this.importDir((Path)d, (IProgressMonitor)subMonitor.newChild(1)));
        subMonitor.done();
    }

    private void importDir(Path rootFolder, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        this.startSynchronization(rootFolder, monitor);
    }

    public static GradleDistribution getGradleDistribution(Path rootFolder) {
        File gradleHomeFile;
        if (JavaLanguageServerPlugin.getPreferencesManager() != null && JavaLanguageServerPlugin.getPreferencesManager().getPreferences().isGradleWrapperEnabled() && Files.exists(rootFolder.resolve("gradlew"), new LinkOption[0])) {
            return GradleDistribution.fromBuild();
        }
        if (JavaLanguageServerPlugin.getPreferencesManager() != null && JavaLanguageServerPlugin.getPreferencesManager().getPreferences().getGradleVersion() != null) {
            List versions = CorePlugin.publishedGradleVersions().getVersions();
            GradleVersion gradleVersion = null;
            String versionString = JavaLanguageServerPlugin.getPreferencesManager().getPreferences().getGradleVersion();
            GradleVersion requiredVersion = GradleVersion.version((String)versionString);
            for (GradleVersion version : versions) {
                if (version.compareTo(requiredVersion) != 0) continue;
                gradleVersion = version;
            }
            if (gradleVersion != null) {
                return GradleDistribution.forVersion((String)gradleVersion.getVersion());
            }
            JavaLanguageServerPlugin.logInfo("Invalid gradle version" + versionString);
        }
        if ((gradleHomeFile = GradleProjectImporter.getGradleHomeFile()) != null) {
            return GradleDistribution.forLocalInstallation((File)gradleHomeFile);
        }
        return DEFAULT_DISTRIBUTION;
    }

    public static File getGradleHomeFile() {
        Map<String, String> env = System.getenv();
        Properties sysprops = System.getProperties();
        return GradleProjectImporter.getGradleHomeFile(env, sysprops);
    }

    public static File getGradleHomeFile(Map<String, String> env, Properties sysprops) {
        File gradleHomeFile;
        if (JavaLanguageServerPlugin.getPreferencesManager() != null && JavaLanguageServerPlugin.getPreferencesManager().getPreferences().getGradleHome() != null) {
            return new File(JavaLanguageServerPlugin.getPreferencesManager().getPreferences().getGradleHome());
        }
        String gradleHome = env.get(GRADLE_HOME);
        if (gradleHome == null || !new File(gradleHome).isDirectory()) {
            gradleHome = sysprops.getProperty(GRADLE_HOME);
        }
        if (gradleHome != null && (gradleHomeFile = new File(gradleHome)).isDirectory()) {
            return gradleHomeFile;
        }
        return null;
    }

    protected void startSynchronization(Path rootFolder, IProgressMonitor monitor) {
        File location = rootFolder.toFile();
        boolean shouldSynchronize = GradleProjectImporter.shouldSynchronize(location);
        List<IProject> projects = ProjectUtils.getGradleProjects();
        for (IProject project : projects) {
            File projectDir;
            File file = projectDir = project.getLocation() == null ? null : project.getLocation().toFile();
            if (!location.equals(projectDir)) continue;
            shouldSynchronize = GradleProjectImporter.checkGradlePersistence(shouldSynchronize, project, projectDir);
            break;
        }
        if (shouldSynchronize) {
            BuildConfiguration build = GradleProjectImporter.getBuildConfiguration(rootFolder);
            SynchronizationResult result = GradleCore.getWorkspace().createBuild(build).synchronize(monitor);
            if (!result.getStatus().isOK()) {
                JavaLanguageServerPlugin.log(result.getStatus());
            }
        }
    }

    public static BuildConfiguration getBuildConfiguration(Path rootFolder) {
        GradleDistribution distribution = GradleProjectImporter.getGradleDistribution(rootFolder);
        boolean overrideWorkspaceConfiguration = !(distribution instanceof WrapperGradleDistribution);
        String javaHomeStr = JavaLanguageServerPlugin.getPreferencesManager().getPreferences().getJavaHome();
        File javaHome = javaHomeStr == null ? null : new File(javaHomeStr);
        List<Object> gradleArguments = JavaLanguageServerPlugin.getPreferencesManager() != null ? JavaLanguageServerPlugin.getPreferencesManager().getPreferences().getGradleArguments() : new ArrayList();
        List<Object> gradleJvmArguments = JavaLanguageServerPlugin.getPreferencesManager() != null ? JavaLanguageServerPlugin.getPreferencesManager().getPreferences().getGradleJvmArguments() : new ArrayList();
        BuildConfiguration build = BuildConfiguration.forRootProjectDirectory((File)rootFolder.toFile()).overrideWorkspaceConfiguration(overrideWorkspaceConfiguration).gradleDistribution(distribution).javaHome(javaHome).arguments(gradleArguments).jvmArguments(gradleJvmArguments).build();
        return build;
    }

    public static boolean shouldSynchronize(File location) {
        boolean shouldSynchronize = true;
        List<IProject> projects = ProjectUtils.getGradleProjects();
        for (IProject project : projects) {
            File projectDir;
            File file = projectDir = project.getLocation() == null ? null : project.getLocation().toFile();
            if (!location.equals(projectDir)) continue;
            shouldSynchronize = GradleProjectImporter.checkGradlePersistence(shouldSynchronize, project, projectDir);
            break;
        }
        return shouldSynchronize;
    }

    private static boolean checkGradlePersistence(boolean shouldSynchronize, IProject project, File projectDir) {
        File persistentFile;
        PersistentModel model = CorePlugin.modelPersistence().loadModel(project);
        if (model.isPresent() && (persistentFile = CorePlugin.getInstance().getStateLocation().append("project-preferences").append(project.getName()).toFile()).exists()) {
            final long modified = persistentFile.lastModified();
            if (projectDir.exists()) {
                File[] files = projectDir.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        if (name != null && name.endsWith(".gradle")) {
                            return new File(dir, name).lastModified() > modified;
                        }
                        return false;
                    }
                });
                shouldSynchronize = files != null && files.length > 0;
            }
        }
        return shouldSynchronize;
    }

    @Override
    public void reset() {
    }
}

