/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.managers;

import java.io.File;
import java.util.Optional;
import org.eclipse.buildship.core.GradleBuild;
import org.eclipse.buildship.core.GradleCore;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.event.Event;
import org.eclipse.buildship.core.internal.util.file.FileUtils;
import org.eclipse.buildship.core.internal.workspace.WorkbenchShutdownEvent;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.managers.IBuildSupport;
import org.eclipse.jdt.ls.core.internal.managers.ProjectsManager;

public class GradleBuildSupport
implements IBuildSupport {
    public static final String GRADLE_SUFFIX = ".gradle";
    public static final String GRADLE_PROPERTIES = "gradle.properties";

    @Override
    public boolean applies(IProject project) {
        return ProjectUtils.isGradleProject(project);
    }

    @Override
    public void update(IProject project, boolean force, IProgressMonitor monitor) throws CoreException {
        if (!this.applies(project)) {
            return;
        }
        JavaLanguageServerPlugin.logInfo("Starting Gradle update for " + project.getName());
        Optional build = GradleCore.getWorkspace().getBuild(project);
        if (build.isPresent()) {
            ((GradleBuild)build.get()).synchronize(monitor);
        }
    }

    @Override
    public boolean isBuildFile(IResource resource) {
        if (resource != null && resource.getType() == 1 && (resource.getName().endsWith(GRADLE_SUFFIX) || resource.getName().equals(GRADLE_PROPERTIES)) && ProjectUtils.isGradleProject(resource.getProject())) {
            block4: {
                if (ProjectUtils.isJavaProject(resource.getProject())) break block4;
                return true;
            }
            try {
                IJavaProject javaProject = JavaCore.create((IProject)resource.getProject());
                IPath outputLocation = javaProject.getOutputLocation();
                return outputLocation == null || !outputLocation.isPrefixOf(resource.getFullPath());
            }
            catch (JavaModelException e) {
                JavaLanguageServerPlugin.logException(e.getMessage(), e);
            }
        }
        return false;
    }

    public static void cleanGradleModels(IProgressMonitor monitor) {
        File projectPreferences = CorePlugin.getInstance().getStateLocation().append("project-preferences").toFile();
        if (projectPreferences.isDirectory()) {
            File[] projectFiles;
            File[] fileArray = projectFiles = projectPreferences.listFiles();
            int n = projectFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File projectFile = fileArray[n2];
                String projectName = projectFile.getName();
                if (!ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).exists()) {
                    FileUtils.deleteRecursively((File)projectFile);
                }
                ++n2;
            }
        }
    }

    @Override
    public boolean fileChanged(IResource resource, ProjectsManager.CHANGE_TYPE changeType, IProgressMonitor monitor) throws CoreException {
        if (resource == null || !this.applies(resource.getProject())) {
            return false;
        }
        return IBuildSupport.super.fileChanged(resource, changeType, monitor) || this.isBuildFile(resource);
    }

    public static void saveModels() {
        CorePlugin.listenerRegistry().dispatch((Event)new WorkbenchShutdownEvent());
    }
}

