/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.managers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.StatusFactory;

public class DigestStore {
    private Map<String, String> fileDigests;
    private File stateFile;
    private static final String SERIALIZATION_FILE_NAME = ".file-digests";

    public DigestStore(File stateLocation) {
        this.stateFile = new File(stateLocation, SERIALIZATION_FILE_NAME);
        this.fileDigests = this.stateFile.isFile() ? this.deserializeFileDigests() : new HashMap<String, String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean updateDigest(Path p) throws CoreException {
        try {
            String digest = this.computeDigest(p);
            Map<String, String> map = this.fileDigests;
            synchronized (map) {
                if (!digest.equals(this.fileDigests.get(p.toString()))) {
                    this.fileDigests.put(p.toString(), digest);
                    this.serializeFileDigests();
                    return true;
                }
                return false;
            }
        }
        catch (IOException | NoSuchAlgorithmException e) {
            throw new CoreException(StatusFactory.newErrorStatus("Exception updating digest for " + p, e));
        }
    }

    private void serializeFileDigests() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (ObjectOutputStream outStream = new ObjectOutputStream(new FileOutputStream(this.stateFile));){
                outStream.writeObject(this.fileDigests);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            JavaLanguageServerPlugin.logException("Exception occured while serialization of file digests", e);
        }
    }

    private Map<String, String> deserializeFileDigests() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(this.stateFile));){
                return (Map)ois.readObject();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | ClassNotFoundException e) {
            JavaLanguageServerPlugin.logException("Exception occured while deserialization of file digests", e);
            return new HashMap<String, String>();
        }
    }

    private String computeDigest(Path path) throws IOException, NoSuchAlgorithmException {
        byte[] fileBytes = Files.readAllBytes(path);
        byte[] digest = MessageDigest.getInstance("MD5").digest(fileBytes);
        return Arrays.toString(digest);
    }
}

