/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.javadoc;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.internal.corext.util.MethodOverrideTester;
import org.eclipse.jdt.ls.core.internal.javadoc.JavaDoc2MarkdownConverter;
import org.eclipse.jdt.ls.core.internal.javadoc.JavaDoc2PlainTextConverter;
import org.eclipse.jdt.ls.core.internal.javadoc.JavaDocCommentReader;

public final class JavadocContentAccess {
    public static final String PACKAGE_INFO_JAVA = "package-info.java";
    public static final String PACKAGE_INFO_CLASS = "package-info.class";

    private JavadocContentAccess() {
    }

    private static Reader internalGetContentReader(IMember member) throws JavaModelException {
        JavaDocCommentReader reader;
        IBuffer buf = member.getOpenable().getBuffer();
        if (buf == null) {
            return null;
        }
        ISourceRange javadocRange = member.getJavadocRange();
        if (javadocRange != null && !JavadocContentAccess.containsOnlyInheritDoc(reader = new JavaDocCommentReader(buf, javadocRange.getOffset(), javadocRange.getOffset() + javadocRange.getLength() - 1), javadocRange.getLength())) {
            reader.reset();
            return reader;
        }
        return null;
    }

    private static Reader internalGetContentReader(IPackageFragment fragment) throws JavaModelException {
        Javadoc javadocNode;
        String source;
        IPackageFragmentRoot root = (IPackageFragmentRoot)fragment.getAncestor(3);
        boolean isBinary = root.getKind() == 2;
        Object packageInfo = isBinary ? fragment.getClassFile(PACKAGE_INFO_CLASS) : fragment.getCompilationUnit(PACKAGE_INFO_JAVA);
        if (packageInfo != null && packageInfo.exists() && (source = packageInfo.getSource()) != null && (javadocNode = JavadocContentAccess.getPackageJavadocNode((IJavaElement)fragment, source)) != null) {
            int start = javadocNode.getStartPosition();
            int length = javadocNode.getLength();
            return new JavaDocCommentReader(source, start, start + length - 1);
        }
        return null;
    }

    private static Javadoc getPackageJavadocNode(IJavaElement element, String cuSource) {
        PackageDeclaration packDecl;
        CompilationUnit cu = JavadocContentAccess.createAST(element, cuSource);
        if (cu != null && (packDecl = cu.getPackage()) != null) {
            return packDecl.getJavadoc();
        }
        return null;
    }

    private static CompilationUnit createAST(IJavaElement element, String cuSource) {
        ASTParser parser = ASTParser.newParser((int)12);
        IJavaProject javaProject = element.getJavaProject();
        parser.setProject(javaProject);
        Map options = javaProject.getOptions(true);
        options.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
        parser.setCompilerOptions(options);
        parser.setSource(cuSource.toCharArray());
        return (CompilationUnit)parser.createAST(null);
    }

    private static boolean containsOnlyInheritDoc(Reader reader, int length) {
        char[] content = new char[length];
        try {
            reader.read(content, 0, length);
        }
        catch (IOException e) {
            return false;
        }
        return new String(content).trim().equals("{@inheritDoc}");
    }

    public static Reader getMarkdownContentReader(IMember member) throws JavaModelException {
        Reader contentReader = JavadocContentAccess.getHTMLContentReader(member, true, true);
        if (contentReader != null) {
            try {
                return new JavaDoc2MarkdownConverter(contentReader).getAsReader();
            }
            catch (IOException e) {
                throw new JavaModelException((Throwable)e, 1009);
            }
        }
        return null;
    }

    public static Reader getPlainTextContentReader(IMember member) throws JavaModelException {
        Reader contentReader = JavadocContentAccess.getHTMLContentReader(member, true, true);
        if (contentReader != null) {
            try {
                return new JavaDoc2PlainTextConverter(contentReader).getAsReader();
            }
            catch (IOException e) {
                throw new JavaModelException((Throwable)e, 1009);
            }
        }
        return null;
    }

    static Reader getHTMLContentReader(IMember member, boolean allowInherited, boolean useAttachedJavadoc) throws JavaModelException {
        String s;
        Reader contentReader = JavadocContentAccess.internalGetContentReader(member);
        if (contentReader != null) {
            return contentReader;
        }
        if (useAttachedJavadoc && member.getOpenable().getBuffer() == null && (s = member.getAttachedJavadoc(null)) != null) {
            return new StringReader(s);
        }
        if (allowInherited && member.getElementType() == 9) {
            return JavadocContentAccess.findDocInHierarchy((IMethod)member, useAttachedJavadoc);
        }
        return null;
    }

    public static Reader getMarkdownContentReader(IPackageFragment fragment, boolean useAttachedJavadoc) throws JavaModelException {
        Reader contentReader = JavadocContentAccess.internalGetContentReader(fragment);
        if (contentReader == null && useAttachedJavadoc) {
            boolean isBinary;
            IPackageFragmentRoot root = (IPackageFragmentRoot)fragment.getAncestor(3);
            boolean bl = isBinary = root.getKind() == 2;
            if (isBinary) {
                String s = null;
                try {
                    s = fragment.getAttachedJavadoc(null);
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
                if (s != null) {
                    contentReader = new StringReader(s);
                }
            }
        }
        if (contentReader != null) {
            try {
                return new JavaDoc2MarkdownConverter(contentReader).getAsReader();
            }
            catch (IOException e) {
                throw new JavaModelException((Throwable)e, 1009);
            }
        }
        return null;
    }

    private static Reader findDocInHierarchy(IMethod method, boolean useAttachedJavadoc) throws JavaModelException {
        IType[] superTypes;
        if (!method.getJavaProject().exists()) {
            return null;
        }
        IType type = method.getDeclaringType();
        ITypeHierarchy hierarchy = type.newSupertypeHierarchy(null);
        MethodOverrideTester tester = new MethodOverrideTester(type, hierarchy);
        IType[] iTypeArray = superTypes = hierarchy.getAllSupertypes(type);
        int n = superTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Reader reader;
            IType curr = iTypeArray[n2];
            IMethod overridden = tester.findOverriddenMethodInType(curr, method);
            if (overridden != null && (reader = JavadocContentAccess.getHTMLContentReader((IMember)overridden, false, useAttachedJavadoc)) != null) {
                return reader;
            }
            ++n2;
        }
        return null;
    }
}

