/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.TextDocumentPositionParams;

public class NavigateToDefinitionHandler {
    private final PreferenceManager preferenceManager;

    public NavigateToDefinitionHandler(PreferenceManager preferenceManager) {
        this.preferenceManager = preferenceManager;
    }

    public List<? extends Location> definition(TextDocumentPositionParams position, IProgressMonitor monitor) {
        ITypeRoot unit = JDTUtils.resolveTypeRoot(position.getTextDocument().getUri());
        Location location = null;
        if (unit != null && !monitor.isCanceled()) {
            location = this.computeDefinitionNavigation(unit, position.getPosition().getLine(), position.getPosition().getCharacter(), monitor);
        }
        return location == null ? null : Arrays.asList(location);
    }

    private Location computeDefinitionNavigation(ITypeRoot unit, int line, int column, IProgressMonitor monitor) {
        IJavaElement element;
        block5: {
            element = JDTUtils.findElementAtSelection(unit, line, column, this.preferenceManager, monitor);
            if (element != null) break block5;
            return null;
        }
        try {
            ICompilationUnit compilationUnit = (ICompilationUnit)element.getAncestor(5);
            IClassFile cf = (IClassFile)element.getAncestor(6);
            if (compilationUnit != null || cf != null && cf.getSourceRange() != null) {
                return NavigateToDefinitionHandler.fixLocation(element, JDTUtils.toLocation(element), unit.getJavaProject());
            }
            if (element instanceof IMember && ((IMember)element).getClassFile() != null) {
                return NavigateToDefinitionHandler.fixLocation(element, JDTUtils.toLocation(((IMember)element).getClassFile()), unit.getJavaProject());
            }
        }
        catch (JavaModelException e) {
            JavaLanguageServerPlugin.logException("Problem computing definition for" + unit.getElementName(), e);
        }
        return null;
    }

    private static Location fixLocation(IJavaElement element, Location location, IJavaProject javaProject) {
        if (location == null) {
            return null;
        }
        if (!javaProject.equals(element.getJavaProject()) && element.getJavaProject().getProject().getName().equals("jdt.ls-java-project") && location.getUri().contains("jdt.ls-java-project")) {
            String patched = StringUtils.replaceOnce((String)location.getUri(), (String)"jdt.ls-java-project", (String)javaProject.getProject().getName());
            try {
                IClassFile cf = (IClassFile)JavaCore.create((String)JDTUtils.toURI(patched).getQuery());
                if (cf != null && cf.exists()) {
                    location.setUri(patched);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return location;
    }
}

