/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalPositionGroupCore;
import org.eclipse.jdt.internal.ui.text.correction.IProblemLocationCore;
import org.eclipse.jdt.ls.core.internal.ChangeUtil;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JSONUtility;
import org.eclipse.jdt.ls.core.internal.corrections.DiagnosticsHelper;
import org.eclipse.jdt.ls.core.internal.corrections.IInvocationContext;
import org.eclipse.jdt.ls.core.internal.corrections.InnovationContext;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.CUCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.RefactoringCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.handlers.CodeActionHandler;
import org.eclipse.jdt.ls.core.internal.handlers.FormatterHandler;
import org.eclipse.jdt.ls.core.internal.text.correction.ExtractProposalUtility;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.FormattingOptions;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.ltk.core.refactoring.Change;

public class GetRefactorEditHandler {
    public static final String RENAME_COMMAND = "java.action.rename";

    public static RefactorWorkspaceEdit getEditsForRefactor(GetRefactorEditParams params) {
        LinkedProposalPositionGroupCore linkedPositionGroup;
        LinkedProposalPositionGroupCore.PositionInformation highlightPosition;
        RefactoringCorrectionProposal proposal;
        ICompilationUnit unit;
        block12: {
            unit = JDTUtils.resolveCompilationUnit(params.context.getTextDocument().getUri());
            if (unit == null) {
                return null;
            }
            int start = DiagnosticsHelper.getStartOffset(unit, params.context.getRange());
            int end = DiagnosticsHelper.getEndOffset(unit, params.context.getRange());
            InnovationContext context = new InnovationContext(unit, start, end - start);
            context.setASTRoot(CodeActionHandler.getASTRoot(unit));
            IProblemLocationCore[] locations = CodeActionHandler.getProblemLocationCores(unit, params.context.getContext().getDiagnostics());
            boolean problemsAtLocation = locations.length != 0;
            try {
                String initializeIn;
                Map<String, String> formatterOptions = params.options == null ? null : FormatterHandler.getOptions(params.options, unit);
                proposal = null;
                if ("extractVariable".equals(params.command) || "extractVariableAllOccurrence".equals(params.command) || "extractConstant".equals(params.command)) {
                    proposal = (RefactoringCorrectionProposal)GetRefactorEditHandler.getExtractVariableProposal(params.context, context, problemsAtLocation, params.command, formatterOptions);
                } else if ("extractMethod".equals(params.command)) {
                    proposal = (RefactoringCorrectionProposal)GetRefactorEditHandler.getExtractMethodProposal(params.context, context, context.getCoveringNode(), problemsAtLocation, formatterOptions);
                } else if ("convertVariableToField".equals(params.command)) {
                    initializeIn = params.commandArguments != null && !params.commandArguments.isEmpty() ? JSONUtility.toModel(params.commandArguments.get(0), String.class) : null;
                    proposal = (RefactoringCorrectionProposal)ExtractProposalUtility.getConvertVariableToFieldProposal(params.context, context, problemsAtLocation, formatterOptions, initializeIn, false);
                } else if ("extractField".equals(params.command)) {
                    initializeIn = params.commandArguments != null && !params.commandArguments.isEmpty() ? JSONUtility.toModel(params.commandArguments.get(0), String.class) : null;
                    proposal = (RefactoringCorrectionProposal)ExtractProposalUtility.getExtractFieldProposal(params.context, context, problemsAtLocation, formatterOptions, initializeIn, false);
                }
                if (proposal != null) break block12;
                return null;
            }
            catch (CoreException coreException) {
                return null;
            }
        }
        Change change = proposal.getChange();
        WorkspaceEdit edit = ChangeUtil.convertToWorkspaceEdit(change);
        LinkedProposalModelCore linkedProposalModel = proposal.getLinkedProposalModel();
        Command additionalCommand = null;
        if (linkedProposalModel != null && (highlightPosition = GetRefactorEditHandler.getFirstTrackedNodePosition(linkedPositionGroup = linkedProposalModel.getPositionGroup("name", false))) != null) {
            int offset = highlightPosition.getOffset();
            int length = highlightPosition.getLength();
            RenamePosition renamePosition = new RenamePosition(JDTUtils.toURI(unit), offset, length);
            additionalCommand = new Command("Rename", RENAME_COMMAND, Arrays.asList(renamePosition));
        }
        return new RefactorWorkspaceEdit(edit, additionalCommand);
    }

    private static LinkedProposalPositionGroupCore.PositionInformation getFirstTrackedNodePosition(LinkedProposalPositionGroupCore positionGroup) {
        if (positionGroup == null) {
            return null;
        }
        LinkedProposalPositionGroupCore.PositionInformation[] positions = positionGroup.getPositions();
        if (positions == null || positions.length == 0) {
            return null;
        }
        return positions[0];
    }

    private static CUCorrectionProposal getExtractVariableProposal(CodeActionParams params, IInvocationContext context, boolean problemsAtLocation, String refactorType, Map formatterOptions) throws CoreException {
        if ("extractVariableAllOccurrence".equals(refactorType)) {
            return ExtractProposalUtility.getExtractVariableAllOccurrenceProposal(params, context, problemsAtLocation, formatterOptions, false);
        }
        if ("extractVariable".equals(refactorType)) {
            return ExtractProposalUtility.getExtractVariableProposal(params, context, problemsAtLocation, formatterOptions, false);
        }
        if ("extractConstant".equals(refactorType)) {
            return ExtractProposalUtility.getExtractConstantProposal(params, context, problemsAtLocation, formatterOptions, false);
        }
        return null;
    }

    private static CUCorrectionProposal getExtractMethodProposal(CodeActionParams params, IInvocationContext context, ASTNode coveringNode, boolean problemsAtLocation, Map formatterOptions) throws CoreException {
        return ExtractProposalUtility.getExtractMethodProposal(params, context, coveringNode, problemsAtLocation, formatterOptions, false);
    }

    public static class GetRefactorEditParams {
        public String command;
        public List<Object> commandArguments;
        public CodeActionParams context;
        public FormattingOptions options;

        public GetRefactorEditParams(String command, CodeActionParams context) {
            this(command, null, context);
        }

        public GetRefactorEditParams(String command, List<Object> commandArguments, CodeActionParams context) {
            this(command, commandArguments, context, null);
        }

        public GetRefactorEditParams(String command, List<Object> commandArguments, CodeActionParams context, FormattingOptions options) {
            this.command = command;
            this.commandArguments = commandArguments;
            this.context = context;
            this.options = options;
        }
    }

    public static class RefactorWorkspaceEdit {
        public WorkspaceEdit edit;
        public Command command;

        public RefactorWorkspaceEdit(WorkspaceEdit edit) {
            this.edit = edit;
        }

        public RefactorWorkspaceEdit(WorkspaceEdit edit, Command command) {
            this.edit = edit;
            this.command = command;
        }
    }

    public static class RenamePosition {
        public String uri;
        public int offset;
        public int length;

        public RenamePosition(String uri, int offset, int length) {
            this.uri = uri;
            this.offset = offset;
            this.length = length;
        }
    }
}

