/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.manipulation.CoreASTProvider;
import org.eclipse.jdt.internal.ui.text.correction.IProblemLocationCore;
import org.eclipse.jdt.internal.ui.text.correction.ProblemLocationCore;
import org.eclipse.jdt.ls.core.internal.ChangeUtil;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.corrections.DiagnosticsHelper;
import org.eclipse.jdt.ls.core.internal.corrections.InnovationContext;
import org.eclipse.jdt.ls.core.internal.corrections.QuickFixProcessor;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.CUCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.ChangeCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.jdt.ls.core.internal.text.correction.CUCorrectionCommandProposal;
import org.eclipse.jdt.ls.core.internal.text.correction.QuickAssistProcessor;
import org.eclipse.jdt.ls.core.internal.text.correction.SourceAssistProcessor;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionContext;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class CodeActionHandler {
    public static final String COMMAND_ID_APPLY_EDIT = "java.apply.workspaceEdit";
    private QuickFixProcessor quickFixProcessor = new QuickFixProcessor();
    private QuickAssistProcessor quickAssistProcessor;
    private SourceAssistProcessor sourceAssistProcessor;
    private PreferenceManager preferenceManager;

    public CodeActionHandler(PreferenceManager preferenceManager) {
        this.preferenceManager = preferenceManager;
        this.sourceAssistProcessor = new SourceAssistProcessor(preferenceManager);
        this.quickAssistProcessor = new QuickAssistProcessor(preferenceManager);
    }

    public List<Either<Command, CodeAction>> getCodeActionCommands(CodeActionParams params, IProgressMonitor monitor) {
        List<ChangeCorrectionProposal> corrections;
        ICompilationUnit unit = JDTUtils.resolveCompilationUnit(params.getTextDocument().getUri());
        if (unit == null) {
            return Collections.emptyList();
        }
        int start = DiagnosticsHelper.getStartOffset(unit, params.getRange());
        int end = DiagnosticsHelper.getEndOffset(unit, params.getRange());
        InnovationContext context = new InnovationContext(unit, start, end - start);
        context.setASTRoot(CodeActionHandler.getASTRoot(unit));
        IProblemLocationCore[] locations = CodeActionHandler.getProblemLocationCores(unit, params.getContext().getDiagnostics());
        ArrayList<Either<Command, CodeAction>> $ = new ArrayList<Either<Command, CodeAction>>();
        ArrayList<ChangeCorrectionProposal> candidates = new ArrayList<ChangeCorrectionProposal>();
        try {
            corrections = this.quickFixProcessor.getCorrections(context, locations);
            candidates.addAll(corrections);
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException("Problem resolving quick fix code actions", e);
        }
        try {
            corrections = this.quickAssistProcessor.getAssists(params, context, locations);
            candidates.addAll(corrections);
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException("Problem resolving quick assist code actions", e);
        }
        candidates.sort(new CUCorrectionProposalComparator());
        if (params.getContext().getOnly() != null && !params.getContext().getOnly().isEmpty()) {
            ArrayList<ChangeCorrectionProposal> resultList = new ArrayList<ChangeCorrectionProposal>();
            for (ChangeCorrectionProposal proposal : candidates) {
                Stream acceptedActionKinds = params.getContext().getOnly().stream();
                if (!acceptedActionKinds.filter(kind -> proposal.getKind() != null && proposal.getKind().startsWith((String)kind)).findFirst().isPresent()) continue;
                resultList.add(proposal);
            }
            candidates = resultList;
        }
        try {
            for (ChangeCorrectionProposal proposal : candidates) {
                Optional<Either<Command, CodeAction>> codeActionFromProposal = this.getCodeActionFromProposal(proposal, params.getContext());
                if (!codeActionFromProposal.isPresent() || $.contains(codeActionFromProposal.get())) continue;
                $.add(codeActionFromProposal.get());
            }
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException("Problem converting proposal to code actions", e);
        }
        $.addAll(this.sourceAssistProcessor.getSourceActionCommands(params, context, locations));
        return $;
    }

    private Optional<Either<Command, CodeAction>> getCodeActionFromProposal(ChangeCorrectionProposal proposal, CodeActionContext context) throws CoreException {
        Command command;
        String name = proposal.getName();
        ICompilationUnit unit = null;
        if (proposal instanceof CUCorrectionProposal) {
            unit = ((CUCorrectionProposal)proposal).getCompilationUnit();
        }
        if (proposal instanceof CUCorrectionCommandProposal) {
            CUCorrectionCommandProposal commandProposal = (CUCorrectionCommandProposal)proposal;
            command = new Command(name, commandProposal.getCommand(), commandProposal.getCommandArguments());
        } else {
            WorkspaceEdit edit = ChangeUtil.convertToWorkspaceEdit(proposal.getChange());
            if (!ChangeUtil.hasChanges(edit)) {
                return Optional.empty();
            }
            command = new Command(name, COMMAND_ID_APPLY_EDIT, Collections.singletonList(edit));
        }
        if (this.preferenceManager.getClientPreferences().isSupportedCodeActionKind(proposal.getKind())) {
            CodeAction codeAction = new CodeAction(name);
            codeAction.setKind(proposal.getKind());
            codeAction.setCommand(command);
            codeAction.setDiagnostics(context.getDiagnostics());
            return Optional.of(Either.forRight((Object)codeAction));
        }
        return Optional.of(Either.forLeft((Object)command));
    }

    public static IProblemLocationCore[] getProblemLocationCores(ICompilationUnit unit, List<Diagnostic> diagnostics) {
        IProblemLocationCore[] locations = new IProblemLocationCore[diagnostics.size()];
        int i = 0;
        while (i < diagnostics.size()) {
            Diagnostic diagnostic = diagnostics.get(i);
            int problemId = CodeActionHandler.getProblemId(diagnostic);
            int start = DiagnosticsHelper.getStartOffset(unit, diagnostic.getRange());
            int end = DiagnosticsHelper.getEndOffset(unit, diagnostic.getRange());
            boolean isError = diagnostic.getSeverity() == DiagnosticSeverity.Error;
            locations[i] = new ProblemLocationCore(start, end - start, problemId, new String[0], isError, "org.eclipse.jdt.core.problem");
            ++i;
        }
        return locations;
    }

    private static int getProblemId(Diagnostic diagnostic) {
        int $ = 0;
        try {
            $ = Integer.parseInt(diagnostic.getCode());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return $;
    }

    public static CompilationUnit getASTRoot(ICompilationUnit unit) {
        return CoreASTProvider.getInstance().getAST((ITypeRoot)unit, CoreASTProvider.WAIT_YES, (IProgressMonitor)new NullProgressMonitor());
    }

    private static class CUCorrectionProposalComparator
    implements Comparator<ChangeCorrectionProposal> {
        private CUCorrectionProposalComparator() {
        }

        @Override
        public int compare(ChangeCorrectionProposal p1, ChangeCorrectionProposal p2) {
            String k1 = p1.getKind();
            String k2 = p2.getKind();
            if (!(StringUtils.isBlank((CharSequence)k1) || StringUtils.isBlank((CharSequence)k2) || k1.equals(k2))) {
                return k1.compareTo(k2);
            }
            int r1 = p1.getRelevance();
            int r2 = p2.getRelevance();
            int relevanceDif = r2 - r1;
            if (relevanceDif != 0) {
                return relevanceDif;
            }
            return p1.getName().compareToIgnoreCase(p2.getName());
        }
    }
}

