/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corrections.proposals;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.refactoring.structure.ImportRemover;
import org.eclipse.jdt.ls.core.internal.BindingLabelProvider;
import org.eclipse.jdt.ls.core.internal.Messages;
import org.eclipse.jdt.ls.core.internal.corext.dom.DimensionRewrite;
import org.eclipse.jdt.ls.core.internal.corext.dom.TypeAnnotationRewrite;
import org.eclipse.jdt.ls.core.internal.corext.fix.TypeParametersFix;
import org.eclipse.jdt.ls.core.internal.corrections.CorrectionMessages;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.ASTRewriteCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.JavadocTagsSubProcessor;
import org.eclipse.jdt.ls.core.internal.hover.JavaElementLabels;

public class TypeChangeCorrectionProposal
extends ASTRewriteCorrectionProposal {
    private final IBinding fBinding;
    private final CompilationUnit fAstRoot;
    private final ITypeBinding fNewType;
    private final ITypeBinding[] fTypeProposals;
    private final ImportRewrite.TypeLocation fTypeLocation;
    private final boolean fIsNewTypeVar;
    private static String VAR_TYPE = "var";

    public TypeChangeCorrectionProposal(ICompilationUnit targetCU, IBinding binding, CompilationUnit astRoot, ITypeBinding newType, boolean offerSuperTypeProposals, int relevance) {
        this(targetCU, binding, astRoot, newType, false, offerSuperTypeProposals, relevance);
    }

    public TypeChangeCorrectionProposal(ICompilationUnit targetCU, IBinding binding, CompilationUnit astRoot, ITypeBinding oldType, int relevance) {
        this(targetCU, binding, astRoot, oldType, true, false, relevance);
    }

    private TypeChangeCorrectionProposal(ICompilationUnit targetCU, IBinding binding, CompilationUnit astRoot, ITypeBinding newType, boolean isNewTypeVar, boolean offerSuperTypeProposals, int relevance) {
        super("", "quickfix", targetCU, (ASTRewrite)null, relevance);
        Assert.isTrue((binding != null && (binding.getKind() == 4 || binding.getKind() == 3) && Bindings.isDeclarationBinding((IBinding)binding) ? 1 : 0) != 0);
        this.fBinding = binding;
        this.fAstRoot = astRoot;
        this.fIsNewTypeVar = isNewTypeVar;
        if (offerSuperTypeProposals) {
            this.fTypeProposals = ASTResolving.getRelaxingTypes((AST)astRoot.getAST(), (ITypeBinding)newType);
            this.sortTypes(this.fTypeProposals);
            this.fNewType = this.fTypeProposals[0];
        } else {
            this.fNewType = !this.fIsNewTypeVar ? newType : null;
            this.fTypeProposals = null;
        }
        String typeName = isNewTypeVar ? VAR_TYPE : BindingLabelProvider.getBindingLabel((IBinding)this.fNewType, JavaElementLabels.ALL_DEFAULT);
        if (binding.getKind() == 3) {
            IVariableBinding varBinding = (IVariableBinding)binding;
            Object[] args = new String[]{BasicElementLabels.getJavaElementName((String)varBinding.getName()), BasicElementLabels.getJavaElementName((String)typeName)};
            if (varBinding.isField()) {
                this.fTypeLocation = ImportRewrite.TypeLocation.FIELD;
                this.setDisplayName(Messages.format(CorrectionMessages.TypeChangeCompletionProposal_field_name, args));
            } else if (astRoot.findDeclaringNode(binding) instanceof SingleVariableDeclaration) {
                this.fTypeLocation = ImportRewrite.TypeLocation.PARAMETER;
                this.setDisplayName(Messages.format(CorrectionMessages.TypeChangeCompletionProposal_param_name, args));
            } else {
                this.fTypeLocation = ImportRewrite.TypeLocation.LOCAL_VARIABLE;
                this.setDisplayName(Messages.format(CorrectionMessages.TypeChangeCompletionProposal_variable_name, args));
            }
        } else {
            Object[] args = new String[]{binding.getName(), typeName};
            this.fTypeLocation = ImportRewrite.TypeLocation.RETURN_TYPE;
            this.setDisplayName(Messages.format(CorrectionMessages.TypeChangeCompletionProposal_method_name, args));
        }
    }

    @Override
    protected ASTRewrite getRewrite() throws CoreException {
        ASTNode boundNode = this.fAstRoot.findDeclaringNode(this.fBinding);
        ASTNode declNode = null;
        CompilationUnit newRoot = this.fAstRoot;
        if (boundNode != null) {
            declNode = boundNode;
        } else {
            newRoot = ASTResolving.createQuickFixAST((ICompilationUnit)this.getCompilationUnit(), null);
            declNode = newRoot.findDeclaringNode(this.fBinding.getKey());
        }
        if (declNode != null) {
            AST ast = declNode.getAST();
            ASTRewrite rewrite = ASTRewrite.create((AST)ast);
            ImportRewrite imports = this.createImportRewrite(newRoot);
            ContextSensitiveImportRewriteContext context = new ContextSensitiveImportRewriteContext(newRoot, declNode.getStartPosition(), imports);
            ImportRemover remover = new ImportRemover(this.getCompilationUnit().getJavaProject(), newRoot);
            Object type = this.fIsNewTypeVar ? ast.newSimpleType(ast.newName(VAR_TYPE)) : imports.addImport(this.fNewType, ast, (ImportRewrite.ImportRewriteContext)context, this.fTypeLocation);
            if (declNode instanceof MethodDeclaration) {
                TagElement returnTag;
                MethodDeclaration methodDecl = (MethodDeclaration)declNode;
                Type origReturnType = methodDecl.getReturnType2();
                rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)MethodDeclaration.RETURN_TYPE2_PROPERTY, type, null);
                DimensionRewrite.removeAllChildren((ASTNode)methodDecl, MethodDeclaration.EXTRA_DIMENSIONS2_PROPERTY, rewrite, null);
                TypeAnnotationRewrite.removePureTypeAnnotations((ASTNode)methodDecl, MethodDeclaration.MODIFIERS2_PROPERTY, rewrite, null);
                Javadoc javadoc = methodDecl.getJavadoc();
                if (javadoc != null && origReturnType != null && origReturnType.isPrimitiveType() && ((PrimitiveType)origReturnType).getPrimitiveTypeCode() == PrimitiveType.VOID && (returnTag = JavadocTagsSubProcessor.findTag(javadoc, "@return", null)) == null) {
                    returnTag = ast.newTagElement();
                    returnTag.setTagName("@return");
                    TextElement commentStart = ast.newTextElement();
                    returnTag.fragments().add(commentStart);
                    ListRewrite tagsRewriter = rewrite.getListRewrite((ASTNode)javadoc, Javadoc.TAGS_PROPERTY);
                    JavadocTagsSubProcessor.insertTag(tagsRewriter, returnTag, null);
                }
            } else if (declNode instanceof AnnotationTypeMemberDeclaration) {
                AnnotationTypeMemberDeclaration methodDecl = (AnnotationTypeMemberDeclaration)declNode;
                rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)AnnotationTypeMemberDeclaration.TYPE_PROPERTY, type, null);
            } else if (declNode instanceof VariableDeclarationFragment) {
                ASTNode parent = declNode.getParent();
                if (parent instanceof FieldDeclaration) {
                    FieldDeclaration fieldDecl = (FieldDeclaration)parent;
                    if (fieldDecl.fragments().size() > 1 && fieldDecl.getParent() instanceof AbstractTypeDeclaration) {
                        VariableDeclarationFragment placeholder = (VariableDeclarationFragment)rewrite.createMoveTarget(declNode);
                        FieldDeclaration newField = ast.newFieldDeclaration(placeholder);
                        newField.setType((Type)type);
                        AbstractTypeDeclaration typeDecl = (AbstractTypeDeclaration)fieldDecl.getParent();
                        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)typeDecl, typeDecl.getBodyDeclarationsProperty());
                        if (fieldDecl.fragments().indexOf(declNode) == 0) {
                            listRewrite.insertBefore((ASTNode)newField, parent, null);
                        } else {
                            listRewrite.insertAfter((ASTNode)newField, parent, null);
                        }
                    } else {
                        rewrite.set((ASTNode)fieldDecl, (StructuralPropertyDescriptor)FieldDeclaration.TYPE_PROPERTY, type, null);
                        DimensionRewrite.removeAllChildren(declNode, VariableDeclarationFragment.EXTRA_DIMENSIONS2_PROPERTY, rewrite, null);
                        TypeAnnotationRewrite.removePureTypeAnnotations((ASTNode)fieldDecl, FieldDeclaration.MODIFIERS2_PROPERTY, rewrite, null);
                    }
                } else if (parent instanceof VariableDeclarationStatement) {
                    VariableDeclarationStatement varDecl = (VariableDeclarationStatement)parent;
                    if (varDecl.fragments().size() > 1 && varDecl.getParent() instanceof Block) {
                        VariableDeclarationFragment placeholder = (VariableDeclarationFragment)rewrite.createMoveTarget(declNode);
                        VariableDeclarationStatement newStat = ast.newVariableDeclarationStatement(placeholder);
                        newStat.setType((Type)type);
                        ListRewrite listRewrite = rewrite.getListRewrite(varDecl.getParent(), Block.STATEMENTS_PROPERTY);
                        if (varDecl.fragments().indexOf(declNode) == 0) {
                            listRewrite.insertBefore((ASTNode)newStat, parent, null);
                        } else {
                            listRewrite.insertAfter((ASTNode)newStat, parent, null);
                        }
                        if (this.fIsNewTypeVar) {
                            this.handledInferredParameterizedType((ASTNode)newStat, declNode, ast, rewrite, imports, (ImportRewrite.ImportRewriteContext)context);
                        }
                    } else {
                        Type oldType = (Type)rewrite.get((ASTNode)varDecl, (StructuralPropertyDescriptor)VariableDeclarationStatement.TYPE_PROPERTY);
                        rewrite.set((ASTNode)varDecl, (StructuralPropertyDescriptor)VariableDeclarationStatement.TYPE_PROPERTY, type, null);
                        DimensionRewrite.removeAllChildren(declNode, VariableDeclarationFragment.EXTRA_DIMENSIONS2_PROPERTY, rewrite, null);
                        if (this.fIsNewTypeVar) {
                            this.handledInferredParameterizedType(parent, declNode, ast, rewrite, imports, (ImportRewrite.ImportRewriteContext)context);
                            TypeAnnotationRewrite.removePureTypeAnnotations(parent, VariableDeclarationStatement.MODIFIERS2_PROPERTY, rewrite, null);
                            if (oldType != null) {
                                remover.registerRemovedNode((ASTNode)oldType);
                            }
                        }
                    }
                } else if (parent instanceof VariableDeclarationExpression) {
                    VariableDeclarationExpression varDecl = (VariableDeclarationExpression)parent;
                    Type oldType = (Type)rewrite.get((ASTNode)varDecl, (StructuralPropertyDescriptor)VariableDeclarationExpression.TYPE_PROPERTY);
                    rewrite.set((ASTNode)varDecl, (StructuralPropertyDescriptor)VariableDeclarationExpression.TYPE_PROPERTY, type, null);
                    DimensionRewrite.removeAllChildren(declNode, VariableDeclarationFragment.EXTRA_DIMENSIONS2_PROPERTY, rewrite, null);
                    if (this.fIsNewTypeVar) {
                        this.handledInferredParameterizedType(parent, declNode, ast, rewrite, imports, (ImportRewrite.ImportRewriteContext)context);
                        TypeAnnotationRewrite.removePureTypeAnnotations(parent, VariableDeclarationExpression.MODIFIERS2_PROPERTY, rewrite, null);
                        if (oldType != null) {
                            remover.registerRemovedNode((ASTNode)oldType);
                        }
                    }
                }
            } else if (declNode instanceof SingleVariableDeclaration) {
                SingleVariableDeclaration variableDeclaration = (SingleVariableDeclaration)declNode;
                Type oldType = (Type)rewrite.get((ASTNode)variableDeclaration, (StructuralPropertyDescriptor)SingleVariableDeclaration.TYPE_PROPERTY);
                rewrite.set((ASTNode)variableDeclaration, (StructuralPropertyDescriptor)SingleVariableDeclaration.TYPE_PROPERTY, type, null);
                DimensionRewrite.removeAllChildren(declNode, SingleVariableDeclaration.EXTRA_DIMENSIONS2_PROPERTY, rewrite, null);
                TypeAnnotationRewrite.removePureTypeAnnotations(declNode, SingleVariableDeclaration.MODIFIERS2_PROPERTY, rewrite, null);
                if (this.fIsNewTypeVar && oldType != null) {
                    remover.registerRemovedNode((ASTNode)oldType);
                }
            }
            return rewrite;
        }
        return null;
    }

    private void sortTypes(ITypeBinding[] typeProposals) {
        ITypeBinding oldType = this.fBinding instanceof IMethodBinding ? ((IMethodBinding)this.fBinding).getReturnType() : ((IVariableBinding)this.fBinding).getType();
        if (!oldType.isParameterizedType()) {
            return;
        }
        final ITypeBinding oldTypeDeclaration = oldType.getTypeDeclaration();
        Arrays.sort(typeProposals, new Comparator<ITypeBinding>(){

            @Override
            public int compare(ITypeBinding o1, ITypeBinding o2) {
                return this.rank(o2) - this.rank(o1);
            }

            private int rank(ITypeBinding type) {
                if (type.getTypeDeclaration().equals((Object)oldTypeDeclaration)) {
                    return 1;
                }
                return 0;
            }
        });
    }

    private void handledInferredParameterizedType(ASTNode node, ASTNode declaringNode, AST ast, ASTRewrite rewrite, ImportRewrite importRewrite, ImportRewrite.ImportRewriteContext context) {
        ClassInstanceCreation creation;
        Type type;
        VariableDeclarationFragment varFrag;
        if (ast == null || rewrite == null || importRewrite == null || context == null) {
            return;
        }
        Expression processNode = null;
        List fragments = null;
        if (node instanceof VariableDeclarationStatement) {
            fragments = ((VariableDeclarationStatement)node).fragments();
        } else if (node instanceof VariableDeclarationExpression) {
            fragments = ((VariableDeclarationExpression)node).fragments();
        }
        if (fragments != null && fragments.size() == 1 && (processNode = (varFrag = (VariableDeclarationFragment)fragments.get(0)).getInitializer()) == null && declaringNode instanceof VariableDeclarationFragment) {
            processNode = ((VariableDeclarationFragment)declaringNode).getInitializer();
        }
        ParameterizedType createdType = null;
        if (processNode instanceof ClassInstanceCreation && (type = (creation = (ClassInstanceCreation)processNode).getType()) instanceof ParameterizedType) {
            createdType = (ParameterizedType)type;
        }
        if (createdType == null) {
            return;
        }
        ArrayList<ASTNode> changedNodes = new ArrayList<ASTNode>();
        node.accept((ASTVisitor)new TypeParametersFix.InsertTypeArgumentsVisitor(changedNodes));
        if (changedNodes.isEmpty()) {
            return;
        }
        ITypeBinding binding = createdType.resolveBinding();
        if (binding != null) {
            ITypeBinding[] typeArguments = binding.getTypeArguments();
            ListRewrite argumentsRewrite = rewrite.getListRewrite((ASTNode)createdType, ParameterizedType.TYPE_ARGUMENTS_PROPERTY);
            int i = 0;
            while (i < typeArguments.length) {
                ITypeBinding typeArgument = typeArguments[i];
                Type argumentNode = importRewrite.addImport(typeArgument, ast, context, ImportRewrite.TypeLocation.TYPE_ARGUMENT);
                argumentsRewrite.insertLast((ASTNode)argumentNode, null);
                ++i;
            }
        }
    }
}

