/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corext.util;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.ltk.core.refactoring.TextChange;

public class TextChangeManager {
    private Map<ICompilationUnit, TextChange> fMap = new HashMap<ICompilationUnit, TextChange>(10);
    private final boolean fKeepExecutedTextEdits;

    public TextChangeManager() {
        this(false);
    }

    public TextChangeManager(boolean keepExecutedTextEdits) {
        this.fKeepExecutedTextEdits = keepExecutedTextEdits;
    }

    public void manage(ICompilationUnit cu, TextChange change) {
        this.fMap.put(cu, change);
    }

    public TextChange get(ICompilationUnit cu) {
        TextChange result = this.fMap.get(cu);
        if (result == null) {
            result = new CompilationUnitChange(cu.getElementName(), cu);
            result.setKeepPreviewEdits(this.fKeepExecutedTextEdits);
            this.fMap.put(cu, result);
        }
        return result;
    }

    public TextChange remove(ICompilationUnit unit) {
        return this.fMap.remove(unit);
    }

    public TextChange[] getAllChanges() {
        Set<ICompilationUnit> cuSet = this.fMap.keySet();
        ICompilationUnit[] cus = cuSet.toArray(new ICompilationUnit[cuSet.size()]);
        Arrays.sort(cus, new Comparator<ICompilationUnit>(){

            @Override
            public int compare(ICompilationUnit o1, ICompilationUnit o2) {
                String name1 = o1.getElementName();
                String name2 = o2.getElementName();
                return name1.compareTo(name2);
            }
        });
        TextChange[] textChanges = new TextChange[cus.length];
        int i = 0;
        while (i < cus.length) {
            textChanges[i] = this.fMap.get(cus[i]);
            ++i;
        }
        return textChanges;
    }

    public ICompilationUnit[] getAllCompilationUnits() {
        return this.fMap.keySet().toArray(new ICompilationUnit[this.fMap.keySet().size()]);
    }

    public void clear() {
        this.fMap.clear();
    }

    public boolean containsChangesIn(ICompilationUnit cu) {
        return this.fMap.containsKey(cu);
    }
}

