/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.manipulation.CodeStyleConfiguration;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationPlugin;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.structure.ImportRemover;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.CategorizedTextEditGroup;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class CompilationUnitRewrite {
    private ICompilationUnit fCu;
    private List<TextEditGroup> fTextEditGroups = new ArrayList<TextEditGroup>();
    private CompilationUnit fRoot;
    private ASTRewrite fRewrite;
    private ImportRewrite fImportRewrite;
    private ImportRemover fImportRemover;
    private boolean fResolveBindings = true;
    private boolean fStatementsRecovery = true;
    private boolean fBindingsRecovery = false;
    private final WorkingCopyOwner fOwner;
    private IDocument fRememberContent = null;
    private Map fFormatterOptions;

    public CompilationUnitRewrite(ICompilationUnit cu) {
        this(null, cu, null, null);
    }

    public CompilationUnitRewrite(WorkingCopyOwner owner, ICompilationUnit cu) {
        this(owner, cu, null, null);
    }

    public CompilationUnitRewrite(ICompilationUnit cu, CompilationUnit root) {
        this(null, cu, root, null);
    }

    public CompilationUnitRewrite(WorkingCopyOwner owner, ICompilationUnit cu, CompilationUnit root, Map formatterOptions) {
        this.fOwner = owner;
        this.fCu = cu;
        this.fRoot = root;
        this.fFormatterOptions = formatterOptions;
    }

    public Map getFormatterOptions() {
        return this.fFormatterOptions;
    }

    public void setFormatterOptions(Map formatterOptions) {
        this.fFormatterOptions = formatterOptions;
    }

    public void rememberContent() {
        this.fRememberContent = new Document();
    }

    public void setResolveBindings(boolean resolve) {
        this.fResolveBindings = resolve;
    }

    public void setStatementsRecovery(boolean statementsRecovery) {
        this.fStatementsRecovery = statementsRecovery;
    }

    public void setBindingRecovery(boolean bindingsRecovery) {
        this.fBindingsRecovery = bindingsRecovery;
    }

    public void clearASTRewrite() {
        this.fRewrite = null;
        this.fTextEditGroups = new ArrayList<TextEditGroup>();
    }

    public void clearImportRewrites() {
        this.fImportRewrite = null;
        this.fImportRemover = null;
    }

    public void clearASTAndImportRewrites() {
        this.clearASTRewrite();
        this.clearImportRewrites();
    }

    public CategorizedTextEditGroup createCategorizedGroupDescription(String name, GroupCategorySet set) {
        CategorizedTextEditGroup result = new CategorizedTextEditGroup(name, set);
        this.fTextEditGroups.add((TextEditGroup)result);
        return result;
    }

    public TextEditGroup createGroupDescription(String name) {
        TextEditGroup result = new TextEditGroup(name);
        this.fTextEditGroups.add(result);
        return result;
    }

    public org.eclipse.jdt.core.refactoring.CompilationUnitChange createChange(boolean generateGroups) throws CoreException {
        return this.createChange(generateGroups, null);
    }

    @Deprecated
    public CompilationUnitChange createChange() throws CoreException {
        org.eclipse.jdt.core.refactoring.CompilationUnitChange change = this.createChange(true);
        if (change == null) {
            return null;
        }
        return new CompilationUnitChange(change);
    }

    public org.eclipse.jdt.core.refactoring.CompilationUnitChange createChange(boolean generateGroups, IProgressMonitor monitor) throws CoreException {
        return this.createChange(this.fCu.getElementName(), generateGroups, monitor);
    }

    public org.eclipse.jdt.core.refactoring.CompilationUnitChange createChange(String name, boolean generateGroups, IProgressMonitor monitor) throws CoreException {
        org.eclipse.jdt.core.refactoring.CompilationUnitChange cuChange = new org.eclipse.jdt.core.refactoring.CompilationUnitChange(name, this.fCu);
        MultiTextEdit multiEdit = new MultiTextEdit();
        cuChange.setEdit((TextEdit)multiEdit);
        return this.attachChange(cuChange, generateGroups, monitor);
    }

    public org.eclipse.jdt.core.refactoring.CompilationUnitChange attachChange(org.eclipse.jdt.core.refactoring.CompilationUnitChange cuChange, boolean generateGroups, IProgressMonitor monitor) throws CoreException {
        try {
            TextEdit importsEdit;
            boolean needsImportRewrite;
            boolean needsAstRewrite = this.fRewrite != null;
            boolean needsImportRemoval = this.fImportRemover != null && this.fImportRemover.hasRemovedNodes();
            boolean bl = needsImportRewrite = this.fImportRewrite != null && this.fImportRewrite.hasRecordedChanges() || needsImportRemoval;
            if (!(needsAstRewrite || needsImportRemoval || needsImportRewrite)) {
                return null;
            }
            MultiTextEdit multiEdit = (MultiTextEdit)cuChange.getEdit();
            if (multiEdit == null) {
                multiEdit = new MultiTextEdit();
                cuChange.setEdit((TextEdit)multiEdit);
            }
            if (needsAstRewrite) {
                TextEdit rewriteEdit;
                Map formatter;
                this.clearGroupDescriptionEdits();
                Map map = formatter = this.fFormatterOptions == null ? this.getCu().getJavaProject().getOptions(true) : this.fFormatterOptions;
                if (this.fRememberContent != null) {
                    rewriteEdit = this.fRewrite.rewriteAST(this.fRememberContent, formatter);
                } else {
                    try {
                        Document document = new Document(this.fCu.getSource());
                        rewriteEdit = this.fRewrite.rewriteAST((IDocument)document, formatter);
                    }
                    catch (JavaModelException e) {
                        rewriteEdit = this.fRewrite.rewriteAST();
                    }
                }
                if (!CompilationUnitRewrite.isEmptyEdit(rewriteEdit)) {
                    multiEdit.addChild(rewriteEdit);
                    if (generateGroups) {
                        for (TextEditGroup group : this.fTextEditGroups) {
                            cuChange.addTextEditGroup(group);
                        }
                    }
                }
            }
            if (needsImportRemoval) {
                this.fImportRemover.applyRemoves(this.getImportRewrite());
            }
            if (needsImportRewrite && !CompilationUnitRewrite.isEmptyEdit(importsEdit = this.fImportRewrite.rewriteImports(monitor))) {
                multiEdit.addChild(importsEdit);
                String importUpdateName = RefactoringCoreMessages.ASTData_update_imports;
                cuChange.addTextEditGroup(new TextEditGroup(importUpdateName, importsEdit));
            }
            if (CompilationUnitRewrite.isEmptyEdit((TextEdit)multiEdit)) {
                return null;
            }
            org.eclipse.jdt.core.refactoring.CompilationUnitChange compilationUnitChange = cuChange;
            return compilationUnitChange;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private static boolean isEmptyEdit(TextEdit edit) {
        return edit.getClass() == MultiTextEdit.class && !edit.hasChildren();
    }

    public ICompilationUnit getCu() {
        return this.fCu;
    }

    public CompilationUnit getRoot() {
        if (this.fRoot == null) {
            this.fRoot = new RefactoringASTParser(12).parse((ITypeRoot)this.fCu, this.fOwner, this.fResolveBindings, this.fStatementsRecovery, this.fBindingsRecovery, null);
        }
        return this.fRoot;
    }

    public AST getAST() {
        return this.getRoot().getAST();
    }

    public ASTRewrite getASTRewrite() {
        if (this.fRewrite == null) {
            this.fRewrite = ASTRewrite.create((AST)this.getRoot().getAST());
            if (this.fRememberContent != null) {
                try {
                    this.fRememberContent.set(this.fCu.getSource());
                }
                catch (JavaModelException e) {
                    this.fRememberContent = null;
                }
            }
        }
        return this.fRewrite;
    }

    public ImportRewrite getImportRewrite() {
        if (this.fImportRewrite == null) {
            try {
                this.fImportRewrite = this.fRoot == null && !this.fResolveBindings ? CodeStyleConfiguration.createImportRewrite((ICompilationUnit)this.fCu, (boolean)true) : this.createImportRewrite(this.getRoot(), true);
            }
            catch (CoreException e) {
                JavaManipulationPlugin.log((Throwable)e);
                throw new IllegalStateException(e.getMessage());
            }
        }
        return this.fImportRewrite;
    }

    private ImportRewrite createImportRewrite(CompilationUnit astRoot, boolean restoreExistingImports) {
        ImportRewrite rewrite = CodeStyleConfiguration.createImportRewrite((CompilationUnit)astRoot, (boolean)restoreExistingImports);
        if (astRoot.getAST().hasResolvedBindings()) {
            rewrite.setUseContextToFilterImplicitImports(true);
        }
        return rewrite;
    }

    public ImportRemover getImportRemover() {
        if (this.fImportRemover == null) {
            this.fImportRemover = new ImportRemover(this.fCu.getJavaProject(), this.getRoot());
        }
        return this.fImportRemover;
    }

    private void clearGroupDescriptionEdits() {
        for (TextEditGroup group : this.fTextEditGroups) {
            group.clearTextEdits();
        }
    }
}

