/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corext.refactoring.code;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.jdt.internal.corext.dom.TokenScanner;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.util.CodeAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaStatusContext;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.ls.core.internal.BindingLabelProvider;
import org.eclipse.jdt.ls.core.internal.Messages;
import org.eclipse.jdt.ls.core.internal.corext.dom.LocalVariableIndex;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.code.ExceptionAnalyzer;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.code.LocalTypeAnalyzer;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.code.SnippetFinder;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.code.flow.FlowContext;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.code.flow.FlowInfo;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.code.flow.InOutFlowAnalyzer;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.code.flow.InputFlowAnalyzer;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

class ExtractMethodAnalyzer
extends CodeAnalyzer {
    public static final int ERROR = -2;
    public static final int UNDEFINED = -1;
    public static final int NO = 0;
    public static final int EXPRESSION = 1;
    public static final int ACCESS_TO_LOCAL = 2;
    public static final int RETURN_STATEMENT_VOID = 3;
    public static final int RETURN_STATEMENT_VALUE = 4;
    public static final int MULTIPLE = 5;
    private BodyDeclaration fEnclosingBodyDeclaration;
    private IMethodBinding fEnclosingMethodBinding;
    private int fMaxVariableId;
    private int fReturnKind;
    private Type fReturnType;
    private ITypeBinding fReturnTypeBinding;
    private FlowInfo fInputFlowInfo;
    private FlowContext fInputFlowContext;
    private IVariableBinding[] fArguments;
    private IVariableBinding[] fMethodLocals;
    private ITypeBinding[] fTypeVariables;
    private IVariableBinding fReturnValue;
    private IVariableBinding[] fCallerLocals;
    private IVariableBinding fReturnLocal;
    private ITypeBinding[] fAllExceptions;
    private ITypeBinding fExpressionBinding;
    private boolean fForceStatic;
    private boolean fIsLastStatementSelected;
    private SimpleName fEnclosingLoopLabel;

    public ExtractMethodAnalyzer(ICompilationUnit unit, Selection selection) throws CoreException {
        super(unit, selection, false);
    }

    public BodyDeclaration getEnclosingBodyDeclaration() {
        return this.fEnclosingBodyDeclaration;
    }

    public int getReturnKind() {
        return this.fReturnKind;
    }

    public boolean extractsExpression() {
        return this.fReturnKind == 1;
    }

    public Type getReturnType() {
        return this.fReturnType;
    }

    public ITypeBinding getReturnTypeBinding() {
        return this.fReturnTypeBinding;
    }

    public boolean generateImport() {
        switch (this.fReturnKind) {
            case 1: {
                return true;
            }
        }
        return false;
    }

    public IVariableBinding[] getArguments() {
        return this.fArguments;
    }

    public IVariableBinding[] getMethodLocals() {
        return this.fMethodLocals;
    }

    public IVariableBinding getReturnValue() {
        return this.fReturnValue;
    }

    public IVariableBinding[] getCallerLocals() {
        return this.fCallerLocals;
    }

    public IVariableBinding getReturnLocal() {
        return this.fReturnLocal;
    }

    public ITypeBinding getExpressionBinding() {
        return this.fExpressionBinding;
    }

    public boolean getForceStatic() {
        return this.fForceStatic;
    }

    public ITypeBinding[] getTypeVariables() {
        return this.fTypeVariables;
    }

    boolean isValidDestination(ASTNode node) {
        boolean isInterface;
        boolean bl = isInterface = node instanceof TypeDeclaration && ((TypeDeclaration)node).isInterface();
        return !(node instanceof AnnotationTypeDeclaration) && (!isInterface || JavaModelUtil.is18OrHigher((IJavaProject)this.fCUnit.getJavaProject()));
    }

    public RefactoringStatus checkInitialConditions(ImportRewrite rewriter) {
        int returns;
        RefactoringStatus result = this.getStatus();
        this.checkExpression(result);
        if (result.hasFatalError()) {
            return result;
        }
        ArrayList<ASTNode> validDestinations = new ArrayList<ASTNode>();
        ASTNode destination = ASTResolving.findParentType((ASTNode)this.fEnclosingBodyDeclaration.getParent());
        while (destination != null) {
            if (this.isValidDestination(destination)) {
                validDestinations.add(destination);
            }
            destination = ASTResolving.findParentType((ASTNode)destination.getParent());
        }
        if (validDestinations.size() == 0) {
            result.addFatalError(RefactoringCoreMessages.ExtractMethodAnalyzer_no_valid_destination_type);
            return result;
        }
        this.fReturnKind = -1;
        this.fMaxVariableId = LocalVariableIndex.perform(this.fEnclosingBodyDeclaration);
        if (this.analyzeSelection(result).hasFatalError()) {
            return result;
        }
        int n = returns = this.fReturnKind == 0 ? 0 : 1;
        if (this.fReturnValue != null) {
            this.fReturnKind = 2;
            ++returns;
        }
        if (this.isExpressionSelected()) {
            this.fReturnKind = 1;
            ++returns;
        }
        if (returns > 1) {
            result.addFatalError(RefactoringCoreMessages.ExtractMethodAnalyzer_ambiguous_return_value, JavaStatusContext.create((ITypeRoot)this.fCUnit, (Selection)this.getSelection()));
            this.fReturnKind = 5;
            return result;
        }
        this.initReturnType(rewriter);
        return result;
    }

    private void checkExpression(RefactoringStatus status) {
        ASTNode[] nodes = this.getSelectedNodes();
        if (nodes != null && nodes.length == 1) {
            ASTNode node = nodes[0];
            if (node instanceof Type) {
                status.addFatalError(RefactoringCoreMessages.ExtractMethodAnalyzer_cannot_extract_type_reference, JavaStatusContext.create((ITypeRoot)this.fCUnit, (ASTNode)node));
            } else if (node.getLocationInParent() == SwitchCase.EXPRESSION_PROPERTY) {
                status.addFatalError(RefactoringCoreMessages.ExtractMethodAnalyzer_cannot_extract_switch_case, JavaStatusContext.create((ITypeRoot)this.fCUnit, (ASTNode)node));
            } else if (node instanceof Annotation || ASTNodes.getParent((ASTNode)node, Annotation.class) != null) {
                status.addFatalError(RefactoringCoreMessages.ExtractMethodAnalyzer_cannot_extract_from_annotation, JavaStatusContext.create((ITypeRoot)this.fCUnit, (ASTNode)node));
            }
        }
    }

    private void initReturnType(ImportRewrite rewriter) {
        AST ast = this.fEnclosingBodyDeclaration.getAST();
        this.fReturnType = null;
        this.fReturnTypeBinding = null;
        switch (this.fReturnKind) {
            case 2: {
                VariableDeclaration declaration = ASTNodes.findVariableDeclaration((IVariableBinding)this.fReturnValue, (ASTNode)this.fEnclosingBodyDeclaration);
                this.fReturnType = ASTNodeFactory.newType((AST)ast, (VariableDeclaration)declaration, (ImportRewrite)rewriter, (ImportRewrite.ImportRewriteContext)new ContextSensitiveImportRewriteContext((ASTNode)declaration, rewriter));
                if (declaration.resolveBinding() == null) break;
                this.fReturnTypeBinding = declaration.resolveBinding().getType();
                break;
            }
            case 1: {
                Expression expression = (Expression)this.getFirstSelectedNode();
                this.fExpressionBinding = expression.getNodeType() == 14 ? ((ClassInstanceCreation)expression).getType().resolveBinding() : expression.resolveTypeBinding();
                if (this.fExpressionBinding != null) {
                    if (this.fExpressionBinding.isNullType()) {
                        this.getStatus().addFatalError(RefactoringCoreMessages.ExtractMethodAnalyzer_cannot_extract_null_type, JavaStatusContext.create((ITypeRoot)this.fCUnit, (ASTNode)expression));
                        break;
                    }
                    ITypeBinding normalizedBinding = Bindings.normalizeForDeclarationUse((ITypeBinding)this.fExpressionBinding, (AST)ast);
                    if (normalizedBinding == null) break;
                    ContextSensitiveImportRewriteContext context = new ContextSensitiveImportRewriteContext((ASTNode)this.fEnclosingBodyDeclaration, rewriter);
                    this.fReturnType = rewriter.addImport(normalizedBinding, ast, (ImportRewrite.ImportRewriteContext)context, ImportRewrite.TypeLocation.RETURN_TYPE);
                    this.fReturnTypeBinding = normalizedBinding;
                    break;
                }
                this.fReturnType = ast.newPrimitiveType(PrimitiveType.VOID);
                this.fReturnTypeBinding = ast.resolveWellKnownType("void");
                this.getStatus().addError(RefactoringCoreMessages.ExtractMethodAnalyzer_cannot_determine_return_type, JavaStatusContext.create((ITypeRoot)this.fCUnit, (ASTNode)expression));
                break;
            }
            case 4: {
                LambdaExpression enclosingLambdaExpr = ASTResolving.findEnclosingLambdaExpression((ASTNode)this.getFirstSelectedNode());
                if (enclosingLambdaExpr != null) {
                    this.fReturnType = ASTNodeFactory.newReturnType((LambdaExpression)enclosingLambdaExpr, (AST)ast, (ImportRewrite)rewriter, null);
                    IMethodBinding methodBinding = enclosingLambdaExpr.resolveMethodBinding();
                    this.fReturnTypeBinding = methodBinding != null ? methodBinding.getReturnType() : null;
                    break;
                }
                if (this.fEnclosingBodyDeclaration.getNodeType() != 31) break;
                this.fReturnType = ((MethodDeclaration)this.fEnclosingBodyDeclaration).getReturnType2();
                this.fReturnTypeBinding = this.fReturnType != null ? this.fReturnType.resolveBinding() : null;
                break;
            }
            default: {
                this.fReturnType = ast.newPrimitiveType(PrimitiveType.VOID);
                this.fReturnTypeBinding = ast.resolveWellKnownType("void");
            }
        }
        if (this.fReturnType == null) {
            this.fReturnType = ast.newPrimitiveType(PrimitiveType.VOID);
            this.fReturnTypeBinding = ast.resolveWellKnownType("void");
        }
    }

    public boolean isLiteralNodeSelected() {
        ASTNode[] nodes = this.getSelectedNodes();
        if (nodes.length != 1) {
            return false;
        }
        ASTNode node = nodes[0];
        switch (node.getNodeType()) {
            case 9: 
            case 13: 
            case 33: 
            case 34: {
                return true;
            }
        }
        return false;
    }

    public void checkInput(RefactoringStatus status, String methodName, ASTNode destination) {
        ITypeBinding[] arguments = this.getArgumentTypes();
        ITypeBinding type = ASTNodes.getEnclosingType((ASTNode)destination);
        status.merge(Checks.checkMethodInType((ITypeBinding)type, (String)methodName, (ITypeBinding[])arguments));
        ITypeBinding superClass = type.getSuperclass();
        if (superClass != null) {
            status.merge(Checks.checkMethodInHierarchy((ITypeBinding)superClass, (String)methodName, null, (ITypeBinding[])arguments));
        }
        ITypeBinding[] iTypeBindingArray = type.getInterfaces();
        int n = iTypeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding superInterface = iTypeBindingArray[n2];
            status.merge(Checks.checkMethodInHierarchy((ITypeBinding)superInterface, (String)methodName, null, (ITypeBinding[])arguments));
            ++n2;
        }
    }

    private ITypeBinding[] getArgumentTypes() {
        ITypeBinding[] result = new ITypeBinding[this.fArguments.length];
        int i = 0;
        while (i < this.fArguments.length) {
            result[i] = this.fArguments[i].getType();
            ++i;
        }
        return result;
    }

    private RefactoringStatus analyzeSelection(RefactoringStatus status) {
        String canHandleBranchesProblem;
        this.fInputFlowContext = new FlowContext(0, this.fMaxVariableId + 1);
        this.fInputFlowContext.setConsiderAccessMode(true);
        this.fInputFlowContext.setComputeMode(FlowContext.ARGUMENTS);
        InOutFlowAnalyzer flowAnalyzer = new InOutFlowAnalyzer(this.fInputFlowContext);
        this.fInputFlowInfo = flowAnalyzer.perform(this.getSelectedNodes());
        if (this.fInputFlowInfo.branches() && (canHandleBranchesProblem = this.canHandleBranches()) != null) {
            status.addFatalError(canHandleBranchesProblem, JavaStatusContext.create((ITypeRoot)this.fCUnit, (Selection)this.getSelection()));
            this.fReturnKind = -2;
            return status;
        }
        if (this.fInputFlowInfo.isValueReturn()) {
            this.fReturnKind = 4;
        } else if (this.fInputFlowInfo.isVoidReturn() || this.fInputFlowInfo.isPartialReturn() && this.isVoidMethod() && this.isLastStatementSelected()) {
            this.fReturnKind = 3;
        } else if (this.fInputFlowInfo.isNoReturn() || this.fInputFlowInfo.isThrow() || this.fInputFlowInfo.isUndefined()) {
            this.fReturnKind = 0;
        }
        if (this.fReturnKind == -1) {
            status.addError(RefactoringCoreMessages.FlowAnalyzer_execution_flow, JavaStatusContext.create((ITypeRoot)this.fCUnit, (Selection)this.getSelection()));
            this.fReturnKind = 0;
        }
        this.computeInput();
        this.computeExceptions();
        this.computeOutput(status);
        if (status.hasFatalError()) {
            return status;
        }
        this.adjustArgumentsAndMethodLocals();
        this.compressArrays();
        return status;
    }

    private String canHandleBranches() {
        Block block;
        List statements;
        ASTNode lastStatementInLoop;
        if (this.fReturnValue != null) {
            return RefactoringCoreMessages.ExtractMethodAnalyzer_branch_mismatch;
        }
        ASTNode[] selectedNodes = this.getSelectedNodes();
        ASTNode lastSelectedNode = selectedNodes[selectedNodes.length - 1];
        Statement body = this.getParentLoopBody(lastSelectedNode.getParent());
        if (!(body instanceof Block)) {
            return RefactoringCoreMessages.ExtractMethodAnalyzer_branch_mismatch;
        }
        if (body != lastSelectedNode && lastSelectedNode != (lastStatementInLoop = (ASTNode)(statements = (block = (Block)body).statements()).get(statements.size() - 1))) {
            return RefactoringCoreMessages.ExtractMethodAnalyzer_branch_mismatch;
        }
        final String[] continueMatchesLoopProblem = new String[1];
        int i = 0;
        while (i < selectedNodes.length) {
            ASTNode astNode = selectedNodes[i];
            astNode.accept(new ASTVisitor(){
                ArrayList<String> fLocalLoopLabels = new ArrayList();

                public boolean visit(BreakStatement node) {
                    SimpleName label = node.getLabel();
                    if (label != null && !this.fLocalLoopLabels.contains(label.getIdentifier())) {
                        continueMatchesLoopProblem[0] = Messages.format(RefactoringCoreMessages.ExtractMethodAnalyzer_branch_break_mismatch, new Object[]{"break " + label.getIdentifier()});
                    }
                    return false;
                }

                public boolean visit(LabeledStatement node) {
                    SimpleName label = node.getLabel();
                    if (label != null) {
                        this.fLocalLoopLabels.add(label.getIdentifier());
                    }
                    return true;
                }

                public void endVisit(ContinueStatement node) {
                    SimpleName label = node.getLabel();
                    if (!(label == null || this.fLocalLoopLabels.contains(label.getIdentifier()) || ExtractMethodAnalyzer.this.fEnclosingLoopLabel != null && label.getIdentifier().equals(ExtractMethodAnalyzer.this.fEnclosingLoopLabel.getIdentifier()))) {
                        continueMatchesLoopProblem[0] = Messages.format(RefactoringCoreMessages.ExtractMethodAnalyzer_branch_continue_mismatch, new Object[]{"continue " + label.getIdentifier()});
                    }
                }
            });
            ++i;
        }
        return continueMatchesLoopProblem[0];
    }

    private Statement getParentLoopBody(ASTNode node) {
        Statement stmt = null;
        ASTNode start = node;
        while (!(start == null || start instanceof ForStatement || start instanceof DoStatement || start instanceof WhileStatement || start instanceof EnhancedForStatement || start instanceof SwitchStatement)) {
            start = start.getParent();
        }
        if (start instanceof ForStatement) {
            stmt = ((ForStatement)start).getBody();
        } else if (start instanceof DoStatement) {
            stmt = ((DoStatement)start).getBody();
        } else if (start instanceof WhileStatement) {
            stmt = ((WhileStatement)start).getBody();
        } else if (start instanceof EnhancedForStatement) {
            stmt = ((EnhancedForStatement)start).getBody();
        }
        if (start != null && start.getParent() instanceof LabeledStatement) {
            LabeledStatement labeledStatement = (LabeledStatement)start.getParent();
            this.fEnclosingLoopLabel = labeledStatement.getLabel();
        }
        return stmt;
    }

    private boolean isVoidMethod() {
        ITypeBinding binding = null;
        LambdaExpression enclosingLambdaExpr = ASTResolving.findEnclosingLambdaExpression((ASTNode)this.getFirstSelectedNode());
        if (enclosingLambdaExpr != null) {
            IMethodBinding methodBinding = enclosingLambdaExpr.resolveMethodBinding();
            if (methodBinding != null) {
                binding = methodBinding.getReturnType();
            }
        } else {
            if (this.fEnclosingMethodBinding == null) {
                return true;
            }
            binding = this.fEnclosingMethodBinding.getReturnType();
        }
        return this.fEnclosingBodyDeclaration.getAST().resolveWellKnownType("void").equals((Object)binding);
    }

    public boolean isLastStatementSelected() {
        return this.fIsLastStatementSelected;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void computeLastStatementSelected() {
        ASTNode[] nodes = this.getSelectedNodes();
        if (nodes.length == 0) {
            this.fIsLastStatementSelected = false;
            return;
        }
        Block body = null;
        LambdaExpression enclosingLambdaExpr = ASTResolving.findEnclosingLambdaExpression((ASTNode)this.getFirstSelectedNode());
        if (enclosingLambdaExpr != null) {
            ASTNode lambdaBody = enclosingLambdaExpr.getBody();
            if (!(lambdaBody instanceof Block)) {
                this.fIsLastStatementSelected = true;
                return;
            }
            body = (Block)lambdaBody;
        } else if (this.fEnclosingBodyDeclaration instanceof MethodDeclaration) {
            body = ((MethodDeclaration)this.fEnclosingBodyDeclaration).getBody();
        } else if (this.fEnclosingBodyDeclaration instanceof Initializer) {
            body = ((Initializer)this.fEnclosingBodyDeclaration).getBody();
        }
        if (body == null) return;
        List statements = body.statements();
        if (statements.size() <= 0) {
            this.fIsLastStatementSelected = true;
            return;
        }
        this.fIsLastStatementSelected = nodes[nodes.length - 1] == statements.get(statements.size() - 1);
    }

    private void computeInput() {
        int argumentMode = 54;
        this.fArguments = this.removeSelectedDeclarations(this.fInputFlowInfo.get(this.fInputFlowContext, argumentMode));
        this.fMethodLocals = this.removeSelectedDeclarations(this.fInputFlowInfo.get(this.fInputFlowContext, 24));
        this.fTypeVariables = this.computeTypeVariables(this.fInputFlowInfo.getTypeVariables());
    }

    private IVariableBinding[] removeSelectedDeclarations(IVariableBinding[] bindings) {
        ArrayList<IVariableBinding> result = new ArrayList<IVariableBinding>(bindings.length);
        Selection selection = this.getSelection();
        int i = 0;
        while (i < bindings.length) {
            ASTNode decl = ((CompilationUnit)this.fEnclosingBodyDeclaration.getRoot()).findDeclaringNode((IBinding)bindings[i]);
            if (!selection.covers(decl)) {
                result.add(bindings[i]);
            }
            ++i;
        }
        return result.toArray(new IVariableBinding[result.size()]);
    }

    private ITypeBinding[] computeTypeVariables(ITypeBinding[] bindings) {
        Selection selection = this.getSelection();
        HashSet<ITypeBinding> result = new HashSet<ITypeBinding>();
        CompilationUnit compilationUnit = (CompilationUnit)this.fEnclosingBodyDeclaration.getRoot();
        int i = 0;
        while (i < bindings.length) {
            ASTNode decl = compilationUnit.findDeclaringNode((IBinding)bindings[i]);
            if (decl == null || !selection.covers(decl) && decl.getParent() instanceof MethodDeclaration) {
                result.add(bindings[i]);
            }
            ++i;
        }
        i = 0;
        while (i < this.fArguments.length) {
            ASTNode decl;
            IVariableBinding arg = this.fArguments[i];
            ITypeBinding type = arg.getType();
            if (type != null && type.isTypeVariable() && ((decl = compilationUnit.findDeclaringNode((IBinding)type)) == null || !selection.covers(decl) && decl.getParent() instanceof MethodDeclaration)) {
                result.add(type);
            }
            ++i;
        }
        return result.toArray(new ITypeBinding[result.size()]);
    }

    private void computeOutput(RefactoringStatus status) {
        FlowContext flowContext = new FlowContext(0, this.fMaxVariableId + 1);
        flowContext.setConsiderAccessMode(true);
        flowContext.setComputeMode(FlowContext.RETURN_VALUES);
        FlowInfo returnInfo = new InOutFlowAnalyzer(flowContext).perform(this.getSelectedNodes());
        IVariableBinding[] returnValues = returnInfo.get(flowContext, 56);
        IRegion region = this.getSelectedNodeRange();
        Selection selection = Selection.createFromStartLength((int)region.getOffset(), (int)region.getLength());
        ArrayList<IVariableBinding> localReads = new ArrayList<IVariableBinding>();
        flowContext.setComputeMode(FlowContext.ARGUMENTS);
        FlowInfo argInfo = new InputFlowAnalyzer(flowContext, selection, true).perform(this.fEnclosingBodyDeclaration);
        IVariableBinding[] reads = argInfo.get(flowContext, 38);
        int i = 0;
        while (i < returnValues.length && localReads.size() < returnValues.length) {
            IVariableBinding binding = returnValues[i];
            int x = 0;
            while (x < reads.length) {
                if (reads[x] == binding) {
                    localReads.add(binding);
                    this.fReturnValue = binding;
                    break;
                }
                ++x;
            }
            ++i;
        }
        switch (localReads.size()) {
            case 0: {
                this.fReturnValue = null;
                break;
            }
            case 1: {
                break;
            }
            default: {
                this.fReturnValue = null;
                StringBuffer affectedLocals = new StringBuffer();
                int i2 = 0;
                while (i2 < localReads.size()) {
                    IVariableBinding binding = (IVariableBinding)localReads.get(i2);
                    String bindingName = BindingLabelProvider.getBindingLabel((IBinding)binding, BindingLabelProvider.DEFAULT_TEXTFLAGS | 0x8000L);
                    affectedLocals.append(bindingName);
                    if (i2 != localReads.size() - 1) {
                        affectedLocals.append('\n');
                    }
                    ++i2;
                }
                String message = MessageFormat.format((String)RefactoringCoreMessages.ExtractMethodAnalyzer_assignments_to_local, (Object[])new Object[]{affectedLocals.toString()});
                status.addFatalError(message, JavaStatusContext.create((ITypeRoot)this.fCUnit, (Selection)this.getSelection()));
                return;
            }
        }
        ArrayList<IVariableBinding> callerLocals = new ArrayList<IVariableBinding>(5);
        FlowInfo localInfo = new InputFlowAnalyzer(flowContext, selection, false).perform(this.fEnclosingBodyDeclaration);
        IVariableBinding[] writes = localInfo.get(flowContext, 56);
        int i3 = 0;
        while (i3 < writes.length) {
            IVariableBinding write = writes[i3];
            if (this.getSelection().covers(ASTNodes.findDeclaration((IBinding)write, (ASTNode)this.fEnclosingBodyDeclaration))) {
                callerLocals.add(write);
            }
            ++i3;
        }
        this.fCallerLocals = callerLocals.toArray(new IVariableBinding[callerLocals.size()]);
        if (this.fReturnValue != null && this.getSelection().covers(ASTNodes.findDeclaration((IBinding)this.fReturnValue, (ASTNode)this.fEnclosingBodyDeclaration))) {
            this.fReturnLocal = this.fReturnValue;
        }
    }

    private void adjustArgumentsAndMethodLocals() {
        int i = 0;
        while (i < this.fArguments.length) {
            IVariableBinding argument = this.fArguments[i];
            if (this.fInputFlowInfo.hasAccessMode(this.fInputFlowContext, argument, 16)) {
                if (argument != this.fReturnValue) {
                    this.fArguments[i] = null;
                }
                if (this.fArguments[i] != null) {
                    int l = 0;
                    while (l < this.fMethodLocals.length) {
                        if (this.fMethodLocals[l] == argument) {
                            this.fMethodLocals[l] = null;
                        }
                        ++l;
                    }
                }
            }
            ++i;
        }
    }

    private void compressArrays() {
        this.fArguments = this.compressArray(this.fArguments);
        this.fCallerLocals = this.compressArray(this.fCallerLocals);
        this.fMethodLocals = this.compressArray(this.fMethodLocals);
    }

    private IVariableBinding[] compressArray(IVariableBinding[] array) {
        if (array == null) {
            return null;
        }
        int size = 0;
        int i = 0;
        while (i < array.length) {
            if (array[i] != null) {
                ++size;
            }
            ++i;
        }
        if (size == array.length) {
            return array;
        }
        IVariableBinding[] result = new IVariableBinding[size];
        int i2 = 0;
        int r = 0;
        while (i2 < array.length) {
            if (array[i2] != null) {
                result[r++] = array[i2];
            }
            ++i2;
        }
        return result;
    }

    public void aboutToCreateChange() {
    }

    public ITypeBinding[] getExceptions(boolean includeRuntimeExceptions) {
        if (includeRuntimeExceptions) {
            return this.fAllExceptions;
        }
        ArrayList<ITypeBinding> result = new ArrayList<ITypeBinding>(this.fAllExceptions.length);
        int i = 0;
        while (i < this.fAllExceptions.length) {
            ITypeBinding exception = this.fAllExceptions[i];
            if (includeRuntimeExceptions || !Bindings.isRuntimeException((ITypeBinding)exception)) {
                result.add(exception);
            }
            ++i;
        }
        return result.toArray(new ITypeBinding[result.size()]);
    }

    private void computeExceptions() {
        this.fAllExceptions = ExceptionAnalyzer.perform(this.getSelectedNodes());
    }

    protected void handleNextSelectedNode(ASTNode node) {
        super.handleNextSelectedNode(node);
        this.checkParent(node);
    }

    protected boolean handleSelectionEndsIn(ASTNode node) {
        this.invalidSelection(RefactoringCoreMessages.StatementAnalyzer_doesNotCover, JavaStatusContext.create((ITypeRoot)this.fCUnit, (ASTNode)node));
        return super.handleSelectionEndsIn(node);
    }

    private void checkParent(ASTNode node) {
        ASTNode firstParent = this.getFirstSelectedNode().getParent();
        do {
            if ((node = node.getParent()) != firstParent) continue;
            return;
        } while (node != null);
        this.invalidSelection(RefactoringCoreMessages.ExtractMethodAnalyzer_parent_mismatch);
    }

    /*
     * Unable to fully structure code
     */
    public void endVisit(CompilationUnit node) {
        block10: {
            block16: {
                block15: {
                    block14: {
                        block13: {
                            block12: {
                                block11: {
                                    status = this.getStatus();
                                    if (status.hasFatalError()) break block10;
                                    if (this.hasSelectedNodes()) break block11;
                                    coveringNode = this.getLastCoveringNode();
                                    if (coveringNode instanceof Block && coveringNode.getParent() instanceof MethodDeclaration && (messages = ASTNodes.getMessages((ASTNode)(methodDecl = (MethodDeclaration)coveringNode.getParent()), (int)0)).length > 0) {
                                        status.addFatalError(Messages.format(RefactoringCoreMessages.ExtractMethodAnalyzer_compile_errors, BasicElementLabels.getJavaElementName((String)methodDecl.getName().getIdentifier())), JavaStatusContext.create((ITypeRoot)this.fCUnit, (ASTNode)methodDecl));
                                    } else {
                                        status.addFatalError(RefactoringCoreMessages.ExtractMethodAnalyzer_invalid_selection);
                                    }
                                    break block10;
                                }
                                this.fEnclosingBodyDeclaration = (BodyDeclaration)ASTNodes.getParent((ASTNode)this.getFirstSelectedNode(), BodyDeclaration.class);
                                if (this.fEnclosingBodyDeclaration != null && (this.fEnclosingBodyDeclaration.getNodeType() == 31 || this.fEnclosingBodyDeclaration.getNodeType() == 23 || this.fEnclosingBodyDeclaration.getNodeType() == 28)) break block12;
                                status.addFatalError(RefactoringCoreMessages.ExtractMethodAnalyzer_invalid_selection);
                                break block10;
                            }
                            if (ASTNodes.getEnclosingType((ASTNode)this.fEnclosingBodyDeclaration) != null) break block13;
                            status.addFatalError(RefactoringCoreMessages.ExtractMethodAnalyzer_compile_errors_no_parent_binding);
                            break block10;
                        }
                        if (this.fEnclosingBodyDeclaration.getNodeType() == 31) {
                            this.fEnclosingMethodBinding = ((MethodDeclaration)this.fEnclosingBodyDeclaration).resolveBinding();
                        }
                        if (this.isSingleExpressionOrStatementSet()) break block14;
                        status.addFatalError(RefactoringCoreMessages.ExtractMethodAnalyzer_single_expression_or_set);
                        break block10;
                    }
                    if (!this.isExpressionSelected()) ** GOTO lbl57
                    expression = this.getFirstSelectedNode();
                    if (!(expression instanceof Name)) ** GOTO lbl-1000
                    name = (Name)expression;
                    if (!(name.resolveBinding() instanceof ITypeBinding)) break block15;
                    status.addFatalError(RefactoringCoreMessages.ExtractMethodAnalyzer_cannot_extract_type_reference);
                    break block10;
                }
                if (!(name.resolveBinding() instanceof IMethodBinding)) break block16;
                status.addFatalError(RefactoringCoreMessages.ExtractMethodAnalyzer_cannot_extract_method_name_reference);
                break block10;
            }
            if (!(name.resolveBinding() instanceof IVariableBinding)) ** GOTO lbl-1000
            locationInParent = name.getLocationInParent();
            isPartOfQualifiedName = false;
            isPartOfQualifier = false;
            if (locationInParent == QualifiedName.NAME_PROPERTY) {
                isPartOfQualifiedName = true;
                currParent = qualifiedName = (QualifiedName)name.getParent();
                while ((parent = currParent.getParent()) instanceof QualifiedName) {
                    currParent = (QualifiedName)parent;
                }
                if (!qualifiedName.equals((Object)currParent)) {
                    isPartOfQualifier = true;
                }
            }
            if (isPartOfQualifiedName && !isPartOfQualifier || locationInParent == FieldAccess.NAME_PROPERTY && !(((FieldAccess)name.getParent()).getExpression() instanceof ThisExpression)) {
                status.addFatalError(RefactoringCoreMessages.ExtractMethodAnalyzer_cannot_extract_part_of_qualified_name);
            } else if (name.isSimpleName() && ((SimpleName)name).isDeclaration()) {
                status.addFatalError(RefactoringCoreMessages.ExtractMethodAnalyzer_cannot_extract_name_in_declaration);
            } else lbl-1000:
            // 2 sources

            {
                this.fForceStatic = ASTNodes.getParent((ASTNode)expression, (int)46) != null || ASTNodes.getParent((ASTNode)expression, (int)17) != null;
lbl57:
                // 2 sources

                status.merge(LocalTypeAnalyzer.perform(this.fEnclosingBodyDeclaration, this.getSelection()));
                this.computeLastStatementSelected();
            }
        }
        super.endVisit(node);
    }

    public boolean visit(AnonymousClassDeclaration node) {
        boolean result = super.visit(node);
        if (this.isFirstSelectedNode((ASTNode)node)) {
            this.invalidSelection(RefactoringCoreMessages.ExtractMethodAnalyzer_cannot_extract_anonymous_type, JavaStatusContext.create((ITypeRoot)this.fCUnit, (ASTNode)node));
            return false;
        }
        return result;
    }

    public boolean visit(Assignment node) {
        boolean result = super.visit(node);
        Selection selection = this.getSelection();
        ASTNode selectedNode = NodeFinder.perform((ASTNode)node, (int)selection.getOffset(), (int)selection.getLength());
        if (selectedNode != null && SnippetFinder.isLeftHandSideOfAssignment(selectedNode) || selection.covers((ASTNode)node.getLeftHandSide()) && !selection.covers((ASTNode)node.getRightHandSide())) {
            this.invalidSelection(RefactoringCoreMessages.ExtractMethodAnalyzer_leftHandSideOfAssignment, JavaStatusContext.create((ITypeRoot)this.fCUnit, (ASTNode)node));
            return false;
        }
        return result;
    }

    public boolean visit(DoStatement node) {
        boolean result = super.visit(node);
        try {
            int actionStart = this.getTokenScanner().getTokenEndOffset(121, node.getStartPosition());
            if (this.getSelection().getOffset() == actionStart) {
                this.invalidSelection(RefactoringCoreMessages.ExtractMethodAnalyzer_after_do_keyword, JavaStatusContext.create((ITypeRoot)this.fCUnit, (Selection)this.getSelection()));
                return false;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return result;
    }

    public boolean visit(LambdaExpression node) {
        Selection selection = this.getSelection();
        int selectionStart = selection.getOffset();
        int selectionExclusiveEnd = selection.getExclusiveEnd();
        int lambdaStart = node.getStartPosition();
        int lambdaExclusiveEnd = lambdaStart + node.getLength();
        ASTNode body = node.getBody();
        int bodyStart = body.getStartPosition();
        int bodyExclusiveEnd = bodyStart + body.getLength();
        boolean isValidSelection = false;
        if (body instanceof Block && bodyStart < selectionStart && selectionExclusiveEnd <= bodyExclusiveEnd) {
            isValidSelection = true;
        } else if (body instanceof Expression) {
            try {
                TokenScanner scanner = new TokenScanner((ITypeRoot)this.fCUnit);
                int arrowExclusiveEnd = scanner.getTokenEndOffset(405, lambdaStart);
                if (selectionStart >= arrowExclusiveEnd) {
                    isValidSelection = true;
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        if (selectionStart <= lambdaStart && selectionExclusiveEnd >= lambdaExclusiveEnd) {
            isValidSelection = true;
        }
        if (!isValidSelection) {
            return false;
        }
        return super.visit(node);
    }

    public boolean visit(MethodDeclaration node) {
        Block body = node.getBody();
        if (body == null) {
            return false;
        }
        Selection selection = this.getSelection();
        int nodeStart = body.getStartPosition();
        int nodeExclusiveEnd = nodeStart + body.getLength();
        if (nodeStart >= selection.getOffset() || selection.getExclusiveEnd() >= nodeExclusiveEnd) {
            return false;
        }
        return super.visit(node);
    }

    public boolean visit(ConstructorInvocation node) {
        return this.visitConstructorInvocation((ASTNode)node, super.visit(node));
    }

    public boolean visit(SuperConstructorInvocation node) {
        return this.visitConstructorInvocation((ASTNode)node, super.visit(node));
    }

    private boolean visitConstructorInvocation(ASTNode node, boolean superResult) {
        if (this.getSelection().getVisitSelectionMode(node) == 2) {
            this.invalidSelection(RefactoringCoreMessages.ExtractMethodAnalyzer_super_or_this, JavaStatusContext.create((ITypeRoot)this.fCUnit, (ASTNode)node));
            return false;
        }
        return superResult;
    }

    public boolean visit(VariableDeclarationFragment node) {
        boolean result = super.visit(node);
        if (this.isFirstSelectedNode((ASTNode)node)) {
            if (node.getParent() instanceof FieldDeclaration) {
                this.invalidSelection(RefactoringCoreMessages.ExtractMethodAnalyzer_cannot_extract_variable_declaration_fragment_from_field, JavaStatusContext.create((ITypeRoot)this.fCUnit, (ASTNode)node));
            } else {
                this.invalidSelection(RefactoringCoreMessages.ExtractMethodAnalyzer_cannot_extract_variable_declaration_fragment, JavaStatusContext.create((ITypeRoot)this.fCUnit, (ASTNode)node));
            }
            return false;
        }
        return result;
    }

    public void endVisit(FieldDeclaration node) {
        if (ExtractMethodAnalyzer.contains((ASTNode[])this.getSelectedNodes(), (List)node.fragments())) {
            this.invalidSelection(RefactoringCoreMessages.ExtractMethodAnalyzer_cannot_extract_variable_declaration_fragment_from_field, JavaStatusContext.create((ITypeRoot)this.fCUnit, (ASTNode)node));
        }
        super.endVisit(node);
    }

    public void endVisit(ForStatement node) {
        if (this.getSelection().getEndVisitSelectionMode((ASTNode)node) == 3) {
            if (node.initializers().contains(this.getFirstSelectedNode())) {
                this.invalidSelection(RefactoringCoreMessages.ExtractMethodAnalyzer_cannot_extract_for_initializer, JavaStatusContext.create((ITypeRoot)this.fCUnit, (Selection)this.getSelection()));
            } else if (node.updaters().contains(this.getLastSelectedNode())) {
                this.invalidSelection(RefactoringCoreMessages.ExtractMethodAnalyzer_cannot_extract_for_updater, JavaStatusContext.create((ITypeRoot)this.fCUnit, (Selection)this.getSelection()));
            }
        }
        super.endVisit(node);
    }

    public void endVisit(EnhancedForStatement node) {
        if (this.getSelection().getEndVisitSelectionMode((ASTNode)node) == 3 && node.getParameter() == this.getFirstSelectedNode()) {
            this.invalidSelection(RefactoringCoreMessages.ExtractMethodAnalyzer_cannot_extract_for_initializer, JavaStatusContext.create((ITypeRoot)this.fCUnit, (Selection)this.getSelection()));
        }
        super.endVisit(node);
    }

    public void endVisit(VariableDeclarationExpression node) {
        if (this.getSelection().getEndVisitSelectionMode((ASTNode)node) == 2 && this.getFirstSelectedNode() == node && node.getLocationInParent() == TryStatement.RESOURCES_PROPERTY) {
            this.invalidSelection(RefactoringCoreMessages.ExtractMethodAnalyzer_resource_in_try_with_resources, JavaStatusContext.create((ITypeRoot)this.fCUnit, (Selection)this.getSelection()));
        }
        this.checkTypeInDeclaration(node.getType());
        super.endVisit(node);
    }

    public void endVisit(VariableDeclarationStatement node) {
        this.checkTypeInDeclaration(node.getType());
        super.endVisit(node);
    }

    private boolean isFirstSelectedNode(ASTNode node) {
        return this.getSelection().getVisitSelectionMode(node) == 2 && this.getFirstSelectedNode() == node;
    }

    private void checkTypeInDeclaration(Type node) {
        if (this.getSelection().getEndVisitSelectionMode((ASTNode)node) == 2 && this.getFirstSelectedNode() == node) {
            this.invalidSelection(RefactoringCoreMessages.ExtractMethodAnalyzer_cannot_extract_variable_declaration, JavaStatusContext.create((ITypeRoot)this.fCUnit, (Selection)this.getSelection()));
        }
    }

    private boolean isSingleExpressionOrStatementSet() {
        ASTNode first = this.getFirstSelectedNode();
        if (first == null) {
            return true;
        }
        return !(first instanceof Expression) || this.getSelectedNodes().length == 1;
    }
}

