/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corext.refactoring;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.rename.MethodChecks;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.reorg.ReorgPolicyFactory;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.jdt.ls.core.internal.corext.util.JavaElementUtil;

public final class RefactoringAvailabilityTester {
    public static IType getDeclaringType(IJavaElement element) {
        if (element == null) {
            return null;
        }
        if (!(element instanceof IType)) {
            element = element.getAncestor(7);
        }
        return (IType)element;
    }

    public static IJavaElement[] getJavaElements(Object[] elements) {
        ArrayList<IJavaElement> result = new ArrayList<IJavaElement>();
        int index = 0;
        while (index < elements.length) {
            if (elements[index] instanceof IJavaElement) {
                result.add((IJavaElement)elements[index]);
            }
            ++index;
        }
        return result.toArray(new IJavaElement[result.size()]);
    }

    public static IMember[] getPullUpMembers(IType type) throws JavaModelException {
        ArrayList<IField> list = new ArrayList<IField>(3);
        if (type.exists()) {
            IField[] members = type.getFields();
            int index = 0;
            while (index < members.length) {
                if (RefactoringAvailabilityTester.isPullUpAvailable((IMember)members[index])) {
                    list.add(members[index]);
                }
                ++index;
            }
            members = type.getMethods();
            index = 0;
            while (index < members.length) {
                if (RefactoringAvailabilityTester.isPullUpAvailable((IMember)members[index])) {
                    list.add(members[index]);
                }
                ++index;
            }
            members = type.getTypes();
            index = 0;
            while (index < members.length) {
                if (RefactoringAvailabilityTester.isPullUpAvailable((IMember)members[index])) {
                    list.add(members[index]);
                }
                ++index;
            }
        }
        return list.toArray(new IMember[list.size()]);
    }

    public static IMember[] getPushDownMembers(IType type) throws JavaModelException {
        ArrayList<IField> list = new ArrayList<IField>(3);
        if (type.exists()) {
            IField[] members = type.getFields();
            int index = 0;
            while (index < members.length) {
                if (RefactoringAvailabilityTester.isPushDownAvailable((IMember)members[index])) {
                    list.add(members[index]);
                }
                ++index;
            }
            members = type.getMethods();
            index = 0;
            while (index < members.length) {
                if (RefactoringAvailabilityTester.isPushDownAvailable((IMember)members[index])) {
                    list.add(members[index]);
                }
                ++index;
            }
        }
        return list.toArray(new IMember[list.size()]);
    }

    public static IResource[] getResources(Object[] elements) {
        ArrayList<IResource> result = new ArrayList<IResource>();
        int index = 0;
        while (index < elements.length) {
            if (elements[index] instanceof IResource) {
                result.add((IResource)elements[index]);
            }
            ++index;
        }
        return result.toArray(new IResource[result.size()]);
    }

    public static IType getTopLevelType(IMember[] members) {
        if (members != null && members.length == 1 && Checks.isTopLevelType((IMember)members[0])) {
            return (IType)members[0];
        }
        return null;
    }

    public static boolean isChangeSignatureAvailable(IMethod method) throws JavaModelException {
        return Checks.isAvailable((IJavaElement)method) && !Flags.isAnnotation((int)method.getDeclaringType().getFlags());
    }

    public static boolean isCommonDeclaringType(IMember[] members) {
        if (members.length == 0) {
            return false;
        }
        IType type = members[0].getDeclaringType();
        if (type == null) {
            return false;
        }
        int index = 0;
        while (index < members.length) {
            if (!type.equals(members[index].getDeclaringType())) {
                return false;
            }
            ++index;
        }
        return true;
    }

    public static boolean isConvertAnonymousAvailable(IType type) throws JavaModelException {
        if (Checks.isAvailable((IJavaElement)type)) {
            IJavaElement element = type.getParent();
            if (element instanceof IField && JdtFlags.isEnum((IMember)((IMember)element))) {
                return false;
            }
            return type.isAnonymous();
        }
        return false;
    }

    public static boolean isDelegateCreationAvailable(IField field) throws JavaModelException {
        return field.exists() && Flags.isStatic((int)field.getFlags()) && Flags.isFinal((int)field.getFlags());
    }

    public static boolean isDeleteAvailable(IJavaElement element) {
        if (!element.exists()) {
            return false;
        }
        if (element instanceof IJavaModel || element instanceof IJavaProject) {
            return false;
        }
        if (element.getParent() != null && element.getParent().isReadOnly()) {
            return false;
        }
        if (element instanceof IPackageFragmentRoot) {
            IPackageFragmentRoot root = (IPackageFragmentRoot)element;
            if (root.isExternal() || Checks.isClasspathDelete((IPackageFragmentRoot)root)) {
                return false;
            }
            if (root.getResource().equals((Object)root.getJavaProject().getProject())) {
                return false;
            }
        }
        if (element instanceof IPackageFragment && ((IPackageFragment)element).isDefaultPackage()) {
            return false;
        }
        if (element.getResource() == null && !RefactoringAvailabilityTester.isWorkingCopyElement(element)) {
            return false;
        }
        return !(element instanceof IMember) || !((IMember)element).isBinary();
    }

    public static boolean isDeleteAvailable(IResource resource) {
        if (!resource.exists() || resource.isPhantom()) {
            return false;
        }
        return resource.getType() != 8 && resource.getType() != 4;
    }

    public static boolean isDeleteAvailable(Object[] objects) {
        if (objects.length != 0) {
            IJavaElement[] elements;
            IResource[] resources = RefactoringAvailabilityTester.getResources(objects);
            if (objects.length != resources.length + (elements = RefactoringAvailabilityTester.getJavaElements(objects)).length) {
                return false;
            }
            int index = 0;
            while (index < resources.length) {
                if (!RefactoringAvailabilityTester.isDeleteAvailable(resources[index])) {
                    return false;
                }
                ++index;
            }
            index = 0;
            while (index < elements.length) {
                if (!RefactoringAvailabilityTester.isDeleteAvailable(elements[index])) {
                    return false;
                }
                ++index;
            }
            return true;
        }
        return false;
    }

    public static boolean isExtractInterfaceAvailable(IType type) throws JavaModelException {
        return Checks.isAvailable((IJavaElement)type) && !type.isBinary() && !type.isReadOnly() && !type.isAnnotation() && !type.isAnonymous() && !type.isLambda();
    }

    public static boolean isExtractMethodAvailable(ASTNode[] nodes) {
        if (nodes != null && nodes.length != 0) {
            if (nodes.length == 1) {
                return nodes[0] instanceof Statement || Checks.isExtractableExpression((ASTNode)nodes[0]);
            }
            int index = 0;
            while (index < nodes.length) {
                if (!(nodes[index] instanceof Statement)) {
                    return false;
                }
                ++index;
            }
            return true;
        }
        return false;
    }

    public static boolean isExtractSupertypeAvailable(IMember member) throws JavaModelException {
        if (!member.exists()) {
            return false;
        }
        int type = member.getElementType();
        if (type != 9 && type != 8 && type != 7) {
            return false;
        }
        if (JdtFlags.isEnum((IMember)member) && type != 7) {
            return false;
        }
        if (!Checks.isAvailable((IJavaElement)member)) {
            return false;
        }
        if (member instanceof IMethod) {
            IMethod method = (IMethod)member;
            if (method.isConstructor()) {
                return false;
            }
            if (JdtFlags.isNative((IMember)method)) {
                return false;
            }
            member = method.getDeclaringType();
        } else if (member instanceof IField) {
            member = member.getDeclaringType();
        }
        if (member instanceof IType) {
            if (JdtFlags.isEnum((IMember)member) || JdtFlags.isAnnotation((IMember)member)) {
                return false;
            }
            if (member.getDeclaringType() != null && !JdtFlags.isStatic((IMember)member)) {
                return false;
            }
            if (((IType)member).isAnonymous()) {
                return false;
            }
            if (((IType)member).isLambda()) {
                return false;
            }
        }
        return true;
    }

    public static boolean isExtractSupertypeAvailable(IMember[] members) throws JavaModelException {
        if (members != null && members.length != 0) {
            IType type = RefactoringAvailabilityTester.getTopLevelType(members);
            if (type != null && !type.isClass()) {
                return false;
            }
            int index = 0;
            while (index < members.length) {
                if (!RefactoringAvailabilityTester.isExtractSupertypeAvailable(members[index])) {
                    return false;
                }
                ++index;
            }
            return members.length == 1 || RefactoringAvailabilityTester.isCommonDeclaringType(members);
        }
        return false;
    }

    public static boolean isGeneralizeTypeAvailable(IJavaElement element) throws JavaModelException {
        if (element != null && element.exists()) {
            String type = null;
            if (element instanceof IMethod) {
                type = ((IMethod)element).getReturnType();
            } else if (element instanceof IField) {
                IField field = (IField)element;
                if (JdtFlags.isEnum((IMember)field)) {
                    return false;
                }
                type = field.getTypeSignature();
            } else {
                if (element instanceof ILocalVariable) {
                    return true;
                }
                if (element instanceof IType) {
                    IType clazz = (IType)element;
                    return !JdtFlags.isEnum((IMember)clazz);
                }
            }
            return type != null && PrimitiveType.toCode((String)Signature.toString((String)type)) == null;
        }
        return false;
    }

    public static boolean isInferTypeArgumentsAvailable(IJavaElement element) throws JavaModelException {
        if (!Checks.isAvailable((IJavaElement)element)) {
            return false;
        }
        if (element instanceof IJavaProject) {
            IJavaProject project = (IJavaProject)element;
            IClasspathEntry[] classpathEntries = project.getRawClasspath();
            int i = 0;
            while (i < classpathEntries.length) {
                if (classpathEntries[i].getEntryKind() == 3) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        if (element instanceof IPackageFragmentRoot) {
            return ((IPackageFragmentRoot)element).getKind() == 1;
        }
        if (element instanceof IPackageFragment) {
            return ((IPackageFragment)element).getKind() == 1;
        }
        if (element instanceof ICompilationUnit) {
            return true;
        }
        return element.getAncestor(5) != null;
    }

    public static boolean isInferTypeArgumentsAvailable(IJavaElement[] elements) throws JavaModelException {
        if (elements.length == 0) {
            return false;
        }
        int i = 0;
        while (i < elements.length) {
            if (!RefactoringAvailabilityTester.isInferTypeArgumentsAvailable(elements[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isInlineConstantAvailable(IField field) throws JavaModelException {
        return Checks.isAvailable((IJavaElement)field) && JdtFlags.isStatic((IMember)field) && JdtFlags.isFinal((IMember)field) && !JdtFlags.isEnum((IMember)field);
    }

    public static boolean isInlineMethodAvailable(IMethod method) throws JavaModelException {
        if (method == null) {
            return false;
        }
        if (!method.exists()) {
            return false;
        }
        if (!method.isStructureKnown()) {
            return false;
        }
        if (!method.isBinary()) {
            return true;
        }
        if (method.isConstructor()) {
            return false;
        }
        return SourceRange.isAvailable((ISourceRange)method.getNameRange());
    }

    public static ASTNode getInlineableMethodNode(ITypeRoot typeRoot, CompilationUnit root, int offset, int length) {
        ASTNode node = null;
        try {
            node = RefactoringAvailabilityTester.getInlineableMethodNode(NodeFinder.perform((ASTNode)root, (int)offset, (int)length, (ITypeRoot)typeRoot), (IJavaElement)typeRoot);
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        if (node != null) {
            return node;
        }
        return RefactoringAvailabilityTester.getInlineableMethodNode(NodeFinder.perform((ASTNode)root, (int)offset, (int)length), (IJavaElement)typeRoot);
    }

    private static ASTNode getInlineableMethodNode(ASTNode node, IJavaElement unit) {
        if (node == null) {
            return null;
        }
        switch (node.getNodeType()) {
            case 42: {
                StructuralPropertyDescriptor locationInParent = node.getLocationInParent();
                if (locationInParent == MethodDeclaration.NAME_PROPERTY) {
                    return node.getParent();
                }
                if (locationInParent == MethodInvocation.NAME_PROPERTY || locationInParent == SuperMethodInvocation.NAME_PROPERTY) {
                    return unit instanceof ICompilationUnit ? node.getParent() : null;
                }
                return null;
            }
            case 21: {
                node = ((ExpressionStatement)node).getExpression();
            }
        }
        switch (node.getNodeType()) {
            case 31: {
                return node;
            }
            case 17: 
            case 32: 
            case 48: {
                return unit instanceof ICompilationUnit ? node : null;
            }
        }
        return null;
    }

    public static boolean isInlineTempAvailable(ILocalVariable variable) throws JavaModelException {
        return Checks.isAvailable((IJavaElement)variable);
    }

    public static boolean isIntroduceFactoryAvailable(IMethod method) throws JavaModelException {
        return Checks.isAvailable((IJavaElement)method) && method.isConstructor();
    }

    public static boolean isIntroduceIndirectionAvailable(IMethod method) throws JavaModelException {
        if (method == null) {
            return false;
        }
        if (!method.exists()) {
            return false;
        }
        if (!method.isStructureKnown()) {
            return false;
        }
        if (method.isConstructor()) {
            return false;
        }
        if (method.getDeclaringType().isAnnotation()) {
            return false;
        }
        return !JavaModelUtil.isPolymorphicSignature((IMethod)method);
    }

    public static boolean isIntroduceParameterAvailable(ASTNode[] selectedNodes, ASTNode coveringNode) {
        return Checks.isExtractableExpression((ASTNode[])selectedNodes, (ASTNode)coveringNode);
    }

    public static boolean isMoveAvailable(IResource[] resources, IJavaElement[] elements) throws JavaModelException {
        if (elements != null) {
            int index = 0;
            while (index < elements.length) {
                IJavaElement element = elements[index];
                if (element == null || !element.exists()) {
                    return false;
                }
                if (element instanceof IType && ((IType)element).isLocal()) {
                    return false;
                }
                if (element instanceof IPackageDeclaration) {
                    return false;
                }
                if (element instanceof IField && JdtFlags.isEnum((IMember)((IMember)element))) {
                    return false;
                }
                ++index;
            }
        }
        return ReorgPolicyFactory.createMovePolicy(resources, elements).canEnable();
    }

    public static boolean isMoveInnerAvailable(IType type) throws JavaModelException {
        return Checks.isAvailable((IJavaElement)type) && !Checks.isAnonymous((IType)type) && !JavaElementUtil.isMainType(type) && !Checks.isInsideLocalType((IType)type);
    }

    public static boolean isMoveMethodAvailable(IMethod method) throws JavaModelException {
        return method.exists() && !method.isConstructor() && !method.isBinary() && !method.isReadOnly() && !JdtFlags.isStatic((IMember)method) && (JdtFlags.isDefaultMethod((IMethod)method) || !method.getDeclaringType().isInterface());
    }

    public static boolean isMoveStaticAvailable(IMember member) throws JavaModelException {
        boolean is18OrHigher;
        if (!member.exists()) {
            return false;
        }
        int type = member.getElementType();
        if (type != 9 && type != 8 && type != 7) {
            return false;
        }
        if (JdtFlags.isEnum((IMember)member) && type != 7) {
            return false;
        }
        IType declaring = member.getDeclaringType();
        if (declaring == null) {
            return false;
        }
        if (!Checks.isAvailable((IJavaElement)member)) {
            return false;
        }
        if (!(type != 9 || !declaring.isInterface() || (is18OrHigher = JavaModelUtil.is18OrHigher((IJavaProject)member.getJavaProject())) && Flags.isStatic((int)member.getFlags()))) {
            return false;
        }
        if (type == 9 && !JdtFlags.isStatic((IMember)member)) {
            return false;
        }
        if (type == 9 && ((IMethod)member).isConstructor()) {
            return false;
        }
        if (type == 7 && !JdtFlags.isStatic((IMember)member)) {
            return false;
        }
        return declaring.isInterface() || JdtFlags.isStatic((IMember)member);
    }

    public static boolean isMoveStaticAvailable(IMember[] members) throws JavaModelException {
        int index = 0;
        while (index < members.length) {
            if (!RefactoringAvailabilityTester.isMoveStaticAvailable(members[index])) {
                return false;
            }
            ++index;
        }
        return true;
    }

    public static boolean isMoveStaticMembersAvailable(IMember[] members) throws JavaModelException {
        if (members == null) {
            return false;
        }
        if (members.length == 0) {
            return false;
        }
        if (!RefactoringAvailabilityTester.isMoveStaticAvailable(members)) {
            return false;
        }
        return RefactoringAvailabilityTester.isCommonDeclaringType(members);
    }

    public static boolean isPromoteTempAvailable(ILocalVariable variable) throws JavaModelException {
        return Checks.isAvailable((IJavaElement)variable);
    }

    public static boolean isPullUpAvailable(IMember member) throws JavaModelException {
        if (!member.exists()) {
            return false;
        }
        int type = member.getElementType();
        if (type != 9 && type != 8 && type != 7) {
            return false;
        }
        if (JdtFlags.isEnum((IMember)member) && type != 7) {
            return false;
        }
        if (!Checks.isAvailable((IJavaElement)member)) {
            return false;
        }
        if (member instanceof IType && !JdtFlags.isStatic((IMember)member) && !JdtFlags.isEnum((IMember)member) && !JdtFlags.isAnnotation((IMember)member)) {
            return false;
        }
        if (member instanceof IMethod) {
            IMethod method = (IMethod)member;
            if (method.isConstructor()) {
                return false;
            }
            if (JdtFlags.isNative((IMember)method)) {
                return false;
            }
            IType declaring = method.getDeclaringType();
            if (declaring != null && declaring.isAnnotation()) {
                return false;
            }
        }
        return true;
    }

    public static boolean isPullUpAvailable(IMember[] members) throws JavaModelException {
        if (members != null && members.length != 0) {
            IType type = RefactoringAvailabilityTester.getTopLevelType(members);
            if (type != null && RefactoringAvailabilityTester.getPullUpMembers(type).length != 0) {
                return true;
            }
            int index = 0;
            while (index < members.length) {
                if (!RefactoringAvailabilityTester.isPullUpAvailable(members[index])) {
                    return false;
                }
                ++index;
            }
            return RefactoringAvailabilityTester.isCommonDeclaringType(members);
        }
        return false;
    }

    public static boolean isPushDownAvailable(IMember member) throws JavaModelException {
        if (!member.exists()) {
            return false;
        }
        int type = member.getElementType();
        if (type != 9 && type != 8) {
            return false;
        }
        if (JdtFlags.isEnum((IMember)member)) {
            return false;
        }
        if (!Checks.isAvailable((IJavaElement)member)) {
            return false;
        }
        if (JdtFlags.isStatic((IMember)member)) {
            return false;
        }
        if (type == 9) {
            IMethod method = (IMethod)member;
            if (method.isConstructor()) {
                return false;
            }
            if (JdtFlags.isNative((IMember)method)) {
                return false;
            }
            IType declaring = method.getDeclaringType();
            if (declaring != null && declaring.isAnnotation()) {
                return false;
            }
        }
        return true;
    }

    public static boolean isPushDownAvailable(IMember[] members) throws JavaModelException {
        if (members != null && members.length != 0) {
            IType type = RefactoringAvailabilityTester.getTopLevelType(members);
            if (type != null && RefactoringAvailabilityTester.getPushDownMembers(type).length != 0) {
                return true;
            }
            if (type != null && JdtFlags.isEnum((IMember)type)) {
                return false;
            }
            int index = 0;
            while (index < members.length) {
                if (!RefactoringAvailabilityTester.isPushDownAvailable(members[index])) {
                    return false;
                }
                ++index;
            }
            return RefactoringAvailabilityTester.isCommonDeclaringType(members);
        }
        return false;
    }

    public static boolean isRenameAvailable(ICompilationUnit unit) {
        if (unit == null) {
            return false;
        }
        if (!unit.exists()) {
            return false;
        }
        if (!JavaModelUtil.isPrimary((ICompilationUnit)unit)) {
            return false;
        }
        return !unit.isReadOnly();
    }

    public static boolean isRenameAvailable(IJavaProject project) throws JavaModelException {
        if (project == null) {
            return false;
        }
        if (!Checks.isAvailable((IJavaElement)project)) {
            return false;
        }
        return project.isConsistent();
    }

    public static boolean isRenameAvailable(ILocalVariable variable) throws JavaModelException {
        return Checks.isAvailable((IJavaElement)variable);
    }

    public static boolean isRenameAvailable(IMethod method) throws CoreException {
        if (method == null) {
            return false;
        }
        if (!Checks.isAvailable((IJavaElement)method)) {
            return false;
        }
        if (method.isConstructor()) {
            return false;
        }
        return !RefactoringAvailabilityTester.isRenameProhibited(method);
    }

    public static boolean isRenameAvailable(IPackageFragment fragment) throws JavaModelException {
        if (fragment == null) {
            return false;
        }
        if (!Checks.isAvailable((IJavaElement)fragment)) {
            return false;
        }
        return !fragment.isDefaultPackage();
    }

    public static boolean isRenameAvailable(IPackageFragmentRoot root) throws JavaModelException {
        if (root == null) {
            return false;
        }
        if (!Checks.isAvailable((IJavaElement)root)) {
            return false;
        }
        if (root.isArchive()) {
            return false;
        }
        if (root.isExternal()) {
            return false;
        }
        if (!root.isConsistent()) {
            return false;
        }
        return !(root.getResource() instanceof IProject);
    }

    public static boolean isRenameAvailable(IResource resource) {
        if (resource == null) {
            return false;
        }
        if (!resource.exists()) {
            return false;
        }
        return resource.isAccessible();
    }

    public static boolean isRenameAvailable(IType type) throws JavaModelException {
        if (type == null) {
            return false;
        }
        if (type.isAnonymous()) {
            return false;
        }
        if (type.isLambda()) {
            return false;
        }
        if (!Checks.isAvailable((IJavaElement)type)) {
            return false;
        }
        return !RefactoringAvailabilityTester.isRenameProhibited(type);
    }

    public static boolean isRenameAvailable(ITypeParameter parameter) throws JavaModelException {
        return Checks.isAvailable((IJavaElement)parameter);
    }

    public static boolean isRenameEnumConstAvailable(IField field) throws JavaModelException {
        return Checks.isAvailable((IJavaElement)field) && field.getDeclaringType().isEnum();
    }

    public static boolean isRenameFieldAvailable(IField field) throws JavaModelException {
        return Checks.isAvailable((IJavaElement)field) && !JdtFlags.isEnum((IMember)field);
    }

    public static boolean isRenameNonVirtualMethodAvailable(IMethod method) throws JavaModelException, CoreException {
        return RefactoringAvailabilityTester.isRenameAvailable(method) && !MethodChecks.isVirtual(method);
    }

    public static boolean isRenameProhibited(IMethod method) throws CoreException {
        return method.getElementName().equals("toString") && method.getNumberOfParameters() == 0 && (method.getReturnType().equals("Ljava.lang.String;") || method.getReturnType().equals("QString;") || method.getReturnType().equals("Qjava.lang.String;"));
    }

    public static boolean isRenameProhibited(IType type) {
        return type.getPackageFragment().getElementName().equals("java.lang");
    }

    public static boolean isRenameVirtualMethodAvailable(IMethod method) throws CoreException {
        return RefactoringAvailabilityTester.isRenameAvailable(method) && MethodChecks.isVirtual(method);
    }

    public static boolean isRenameElementAvailable(IJavaElement element) throws CoreException {
        switch (element.getElementType()) {
            case 2: {
                return RefactoringAvailabilityTester.isRenameAvailable((IJavaProject)element);
            }
            case 3: {
                return RefactoringAvailabilityTester.isRenameAvailable((IPackageFragmentRoot)element);
            }
            case 4: {
                return RefactoringAvailabilityTester.isRenameAvailable((IPackageFragment)element);
            }
            case 5: {
                return RefactoringAvailabilityTester.isRenameAvailable((ICompilationUnit)element);
            }
            case 7: {
                return RefactoringAvailabilityTester.isRenameAvailable((IType)element);
            }
            case 9: {
                IMethod method = (IMethod)element;
                if (method.isConstructor()) {
                    return RefactoringAvailabilityTester.isRenameAvailable(method.getDeclaringType());
                }
                return RefactoringAvailabilityTester.isRenameAvailable(method);
            }
            case 8: {
                IField field = (IField)element;
                if (Flags.isEnum((int)field.getFlags())) {
                    return RefactoringAvailabilityTester.isRenameEnumConstAvailable(field);
                }
                return RefactoringAvailabilityTester.isRenameFieldAvailable(field);
            }
            case 15: {
                return RefactoringAvailabilityTester.isRenameAvailable((ITypeParameter)element);
            }
            case 14: {
                return RefactoringAvailabilityTester.isRenameAvailable((ILocalVariable)element);
            }
        }
        return false;
    }

    public static boolean isReplaceInvocationsAvailable(IMethod method) throws JavaModelException {
        if (method == null) {
            return false;
        }
        if (!method.exists()) {
            return false;
        }
        return !method.isConstructor();
    }

    public static boolean isSelfEncapsulateAvailable(IField field) throws JavaModelException {
        return Checks.isAvailable((IJavaElement)field) && !JdtFlags.isEnum((IMember)field) && !field.getDeclaringType().isInterface();
    }

    public static boolean isUseSuperTypeAvailable(IType type) throws JavaModelException {
        return type != null && type.exists() && !type.isAnnotation() && !type.isAnonymous() && !type.isLambda();
    }

    public static boolean isWorkingCopyElement(IJavaElement element) {
        if (element instanceof ICompilationUnit) {
            return ((ICompilationUnit)element).isWorkingCopy();
        }
        if (ReorgUtils.isInsideCompilationUnit(element)) {
            return ReorgUtils.getCompilationUnit(element).isWorkingCopy();
        }
        return false;
    }

    private RefactoringAvailabilityTester() {
    }

    public static boolean isExtractClassAvailable(IType type) throws JavaModelException {
        if (type == null) {
            return false;
        }
        if (!type.exists()) {
            return false;
        }
        return ReorgUtils.isInsideCompilationUnit((IJavaElement)type) && type.isClass() && !type.isAnonymous() && !type.isLambda();
    }
}

