/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corext.fix;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IRegion;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.util.IClassFileReader;
import org.eclipse.jdt.core.util.IFieldInfo;
import org.eclipse.jdt.core.util.IInnerClassesAttribute;
import org.eclipse.jdt.core.util.IInnerClassesAttributeEntry;
import org.eclipse.jdt.core.util.IMethodInfo;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.corext.fix.AbstractSerialVersionOperation;
import org.eclipse.jdt.ls.core.internal.corrections.CorrectionMessages;

public final class SerialVersionHashOperation
extends AbstractSerialVersionOperation {
    private static final String STATIC_CLASS_INITIALIZER = "<clinit>";
    private final ICompilationUnit fCompilationUnit;

    public static Long calculateSerialVersionId(ITypeBinding typeBinding, IProgressMonitor monitor) throws CoreException, IOException {
        try {
            IFile classfileResource = SerialVersionHashOperation.getClassfile(typeBinding);
            if (classfileResource == null) {
                return null;
            }
            try (InputStream contents = classfileResource.getContents();){
                IClassFileReader cfReader = ToolFactory.createDefaultClassFileReader((InputStream)contents, (int)65535);
                if (cfReader != null) {
                    Long l = SerialVersionHashOperation.calculateSerialVersionId(cfReader);
                    return l;
                }
            }
            {
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private static String getClassName(char[] name) {
        return new String(name).replace('/', '.');
    }

    private static Long calculateSerialVersionId(IClassFileReader cfReader) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        DataOutputStream doos = new DataOutputStream(os);
        doos.writeUTF(SerialVersionHashOperation.getClassName(cfReader.getClassName()));
        int mod = SerialVersionHashOperation.getClassModifiers(cfReader);
        int classModifiers = mod & 0x611;
        doos.writeInt(classModifiers);
        char[][] interfaces = SerialVersionHashOperation.getSortedInterfacesNames(cfReader);
        int i = 0;
        while (i < interfaces.length) {
            doos.writeUTF(SerialVersionHashOperation.getClassName(interfaces[i]));
            ++i;
        }
        IFieldInfo[] sortedFields = SerialVersionHashOperation.getSortedFields(cfReader);
        int i2 = 0;
        while (i2 < sortedFields.length) {
            IFieldInfo curr = sortedFields[i2];
            int flags = curr.getAccessFlags();
            if (!Flags.isPrivate((int)flags) || !Flags.isStatic((int)flags) && !Flags.isTransient((int)flags)) {
                doos.writeUTF(new String(curr.getName()));
                doos.writeInt(flags & 0xDF);
                doos.writeUTF(new String(curr.getDescriptor()));
            }
            ++i2;
        }
        if (SerialVersionHashOperation.hasStaticClassInitializer(cfReader)) {
            doos.writeUTF(STATIC_CLASS_INITIALIZER);
            doos.writeInt(8);
            doos.writeUTF("()V");
        }
        IMethodInfo[] sortedMethods = SerialVersionHashOperation.getSortedMethods(cfReader);
        int i3 = 0;
        while (i3 < sortedMethods.length) {
            IMethodInfo curr = sortedMethods[i3];
            int flags = curr.getAccessFlags();
            if (!Flags.isPrivate((int)flags) && !curr.isClinit()) {
                doos.writeUTF(new String(curr.getName()));
                doos.writeInt(flags & 0xD3F);
                doos.writeUTF(SerialVersionHashOperation.getClassName(curr.getDescriptor()));
            }
            ++i3;
        }
        doos.flush();
        return SerialVersionHashOperation.computeHash(os.toByteArray());
    }

    private static int getClassModifiers(IClassFileReader cfReader) {
        IInnerClassesAttribute innerClassesAttribute = cfReader.getInnerClassesAttribute();
        if (innerClassesAttribute != null) {
            IInnerClassesAttributeEntry[] entries = innerClassesAttribute.getInnerClassAttributesEntries();
            int i = 0;
            while (i < entries.length) {
                IInnerClassesAttributeEntry entry = entries[i];
                char[] innerClassName = entry.getInnerClassName();
                if (innerClassName != null && CharOperation.equals((char[])cfReader.getClassName(), (char[])innerClassName)) {
                    return entry.getAccessFlags();
                }
                ++i;
            }
        }
        return cfReader.getAccessFlags();
    }

    private static Long computeHash(byte[] bytes) {
        try {
            byte[] sha = MessageDigest.getInstance("SHA-1").digest(bytes);
            if (sha.length >= 8) {
                long hash = 0L;
                int i = 7;
                while (i >= 0) {
                    hash = hash << 8 | (long)(sha[i] & 0xFF);
                    --i;
                }
                return hash;
            }
        }
        catch (NoSuchAlgorithmException e) {
            JavaLanguageServerPlugin.logException(e.getMessage(), e);
        }
        return null;
    }

    private static char[][] getSortedInterfacesNames(IClassFileReader cfReader) {
        char[][] interfaceNames = cfReader.getInterfaceNames();
        Arrays.sort(interfaceNames, new Comparator<char[]>(){

            @Override
            public int compare(char[] o1, char[] o2) {
                return CharOperation.compareTo((char[])o1, (char[])o2);
            }
        });
        return interfaceNames;
    }

    private static IFieldInfo[] getSortedFields(IClassFileReader cfReader) {
        IFieldInfo[] allFields = cfReader.getFieldInfos();
        Arrays.sort(allFields, new Comparator<IFieldInfo>(){

            @Override
            public int compare(IFieldInfo o1, IFieldInfo o2) {
                return CharOperation.compareTo((char[])o1.getName(), (char[])o2.getName());
            }
        });
        return allFields;
    }

    private static boolean hasStaticClassInitializer(IClassFileReader cfReader) {
        IMethodInfo[] methodInfos = cfReader.getMethodInfos();
        int i = 0;
        while (i < methodInfos.length) {
            if (methodInfos[i].isClinit()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static IMethodInfo[] getSortedMethods(IClassFileReader cfReader) {
        IMethodInfo[] allMethods = cfReader.getMethodInfos();
        Arrays.sort(allMethods, new Comparator<IMethodInfo>(){

            @Override
            public int compare(IMethodInfo mi1, IMethodInfo mi2) {
                if (mi1.isConstructor() != mi2.isConstructor()) {
                    return mi1.isConstructor() ? -1 : 1;
                }
                if (mi1.isConstructor()) {
                    return 0;
                }
                int res = CharOperation.compareTo((char[])mi1.getName(), (char[])mi2.getName());
                if (res != 0) {
                    return res;
                }
                return CharOperation.compareTo((char[])mi1.getDescriptor(), (char[])mi2.getDescriptor());
            }
        });
        return allMethods;
    }

    private static IFile getClassfile(ITypeBinding typeBinding) throws CoreException {
        IType type = (IType)typeBinding.getJavaElement();
        if (type == null || type.getCompilationUnit() == null || type.getJavaProject() == null || "jdt.ls-java-project".equals(type.getJavaProject().getProject().getName())) {
            return null;
        }
        IRegion region = JavaCore.newRegion();
        region.add((IJavaElement)type.getCompilationUnit());
        String name = typeBinding.getBinaryName();
        if (name != null) {
            int packStart = name.lastIndexOf(46);
            if (packStart != -1) {
                name = name.substring(packStart + 1);
            }
        } else {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.ls.core", CorrectionMessages.SerialVersionHashOperation_error_classnotfound));
        }
        name = String.valueOf(name) + ".class";
        IResource[] classFiles = JavaCore.getGeneratedResources((IRegion)region, (boolean)false);
        int i = 0;
        while (i < classFiles.length) {
            block14: {
                IResource resource = classFiles[i];
                if (resource.getType() == 1 && resource.getName().equals(name) && resource.exists()) {
                    block13: {
                        try {
                            Throwable throwable = null;
                            Object var8_10 = null;
                            try {
                                InputStream contents = ((IFile)resource).getContents();
                                if (contents == null) break block13;
                                contents.close();
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (Exception e) {
                            break block14;
                        }
                    }
                    return (IFile)resource;
                }
            }
            ++i;
        }
        return null;
    }

    public SerialVersionHashOperation(ICompilationUnit unit, ASTNode[] nodes) {
        super(unit, nodes);
        this.fCompilationUnit = unit;
    }

    @Override
    protected boolean addInitializer(VariableDeclarationFragment fragment, ASTNode declarationNode) {
        Assert.isNotNull((Object)fragment);
        try {
            String id = this.computeId(declarationNode, (IProgressMonitor)new NullProgressMonitor());
            fragment.setInitializer((Expression)fragment.getAST().newNumberLiteral(id));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return true;
    }

    @Override
    protected void addLinkedPositions(ASTRewrite rewrite, VariableDeclarationFragment fragment, LinkedProposalModelCore positionGroups) {
    }

    private String computeId(ASTNode declarationNode, IProgressMonitor monitor) throws InterruptedException {
        long serialVersionID;
        block15: {
            Assert.isNotNull((Object)monitor);
            serialVersionID = 1L;
            try {
                Long id;
                monitor.beginTask(CorrectionMessages.SerialVersionHashOperation_computing_id, 200);
                IJavaProject project = this.fCompilationUnit.getJavaProject();
                IPath path = this.fCompilationUnit.getResource().getFullPath();
                ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
                try {
                    bufferManager.connect(path, LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                }
                finally {
                    bufferManager.disconnect(path, LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                }
                project.getProject().build(10, (IProgressMonitor)new SubProgressMonitor(monitor, 60));
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                ITypeBinding typeBinding = SerialVersionHashOperation.getTypeBinding(declarationNode);
                if (typeBinding != null && (id = SerialVersionHashOperation.calculateSerialVersionId(typeBinding, (IProgressMonitor)new SubProgressMonitor(monitor, 100))) != null) {
                    serialVersionID = id;
                }
            }
            catch (CoreException exception) {
                JavaLanguageServerPlugin.logException(exception.getMessage(), exception);
                monitor.done();
                break block15;
            }
            catch (IOException exception) {
                try {
                    JavaLanguageServerPlugin.logException(exception.getMessage(), exception);
                    break block15;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    monitor.done();
                }
            }
            monitor.done();
        }
        return String.valueOf(serialVersionID) + "L";
    }

    private static ITypeBinding getTypeBinding(ASTNode parent) {
        if (parent instanceof AbstractTypeDeclaration) {
            AbstractTypeDeclaration declaration = (AbstractTypeDeclaration)parent;
            return declaration.resolveBinding();
        }
        if (parent instanceof AnonymousClassDeclaration) {
            AnonymousClassDeclaration declaration = (AnonymousClassDeclaration)parent;
            return declaration.resolveBinding();
        }
        if (parent instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)parent;
            return type.resolveBinding();
        }
        return null;
    }
}

