/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corext.fix;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalPositionGroupCore;
import org.eclipse.jdt.ls.core.internal.corext.fix.AbstractSerialVersionOperation;

public final class SerialVersionDefaultOperation
extends AbstractSerialVersionOperation {
    private static final String GROUP_INITIALIZER = "initializer";

    public SerialVersionDefaultOperation(ICompilationUnit unit, ASTNode[] nodes) {
        super(unit, nodes);
    }

    @Override
    protected boolean addInitializer(VariableDeclarationFragment fragment, ASTNode declarationNode) {
        Assert.isNotNull((Object)fragment);
        NumberLiteral expression = fragment.getAST().newNumberLiteral("1L");
        if (expression != null) {
            fragment.setInitializer((Expression)expression);
        }
        return true;
    }

    @Override
    protected void addLinkedPositions(ASTRewrite rewrite, VariableDeclarationFragment fragment, LinkedProposalModelCore positionGroups) {
        Assert.isNotNull((Object)rewrite);
        Assert.isNotNull((Object)fragment);
        Expression initializer = fragment.getInitializer();
        if (initializer != null) {
            LinkedProposalPositionGroupCore group = new LinkedProposalPositionGroupCore(GROUP_INITIALIZER);
            group.addPosition(rewrite.track((ASTNode)initializer), true);
            positionGroups.addPositionGroup(group);
        }
    }
}

