/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.Messages;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.StatusFactory;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;

public final class ProjectUtils {
    public static final String WORKSPACE_LINK = "_";
    private static final String JAR_SUFFIX = ".jar";
    private static final String SOURCE_JAR_SUFFIX = "-sources.jar";

    private ProjectUtils() {
    }

    public static boolean hasNature(IProject project, String natureId) {
        try {
            return project != null && project.hasNature(natureId);
        }
        catch (CoreException e) {
            return false;
        }
    }

    public static boolean isJavaProject(IProject project) {
        return ProjectUtils.hasNature(project, "org.eclipse.jdt.core.javanature");
    }

    public static boolean isMavenProject(IProject project) {
        return ProjectUtils.hasNature(project, "org.eclipse.m2e.core.maven2Nature");
    }

    public static boolean isGradleProject(IProject project) {
        return ProjectUtils.hasNature(project, "org.eclipse.buildship.core.gradleprojectnature");
    }

    public static boolean isGeneralJavaProject(IProject project) {
        return ProjectUtils.isJavaProject(project) && !ProjectUtils.isMavenProject(project) && !ProjectUtils.isGradleProject(project);
    }

    public static String getJavaSourceLevel(IProject project) {
        Map<String, String> options = ProjectUtils.getJavaOptions(project);
        return options == null ? null : options.get("org.eclipse.jdt.core.compiler.source");
    }

    public static Map<String, String> getJavaOptions(IProject project) {
        if (!ProjectUtils.isJavaProject(project)) {
            return null;
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        return javaProject.getOptions(true);
    }

    public static List<IProject> getGradleProjects() {
        return Stream.of(ProjectUtils.getAllProjects()).filter(ProjectUtils::isGradleProject).collect(Collectors.toList());
    }

    public static IJavaProject[] getJavaProjects() {
        return (IJavaProject[])Stream.of(ProjectUtils.getAllProjects()).filter(ProjectUtils::isJavaProject).map(p -> JavaCore.create((IProject)p)).filter(p -> p != null).toArray(IJavaProject[]::new);
    }

    public static IProject[] getAllProjects() {
        return ResourcesPlugin.getWorkspace().getRoot().getProjects();
    }

    public static boolean addSourcePath(IPath sourcePath, IJavaProject project) throws CoreException {
        return ProjectUtils.addSourcePath(sourcePath, null, project);
    }

    public static boolean addSourcePath(IPath sourcePath, IPath[] exclusionPaths, IJavaProject project) throws CoreException {
        IClasspathEntry[] existingEntries = project.getRawClasspath();
        ArrayList<IPath> parentSrcPaths = new ArrayList<IPath>();
        ArrayList<IPath> exclusionPatterns = new ArrayList<IPath>();
        IClasspathEntry[] iClasspathEntryArray = existingEntries;
        int n = existingEntries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 3) {
                if (entry.getPath().equals((Object)sourcePath)) {
                    return false;
                }
                if (entry.getPath().isPrefixOf(sourcePath)) {
                    parentSrcPaths.add(entry.getPath());
                } else if (sourcePath.isPrefixOf(entry.getPath())) {
                    exclusionPatterns.add(entry.getPath().makeRelativeTo(sourcePath).addTrailingSeparator());
                }
            }
            ++n2;
        }
        if (!parentSrcPaths.isEmpty()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.ls.core", Messages.format("Cannot add the folder ''{0}'' to the source path because it''s parent folder is already in the source path of the project ''{1}''.", new String[]{sourcePath.toOSString(), project.getProject().getName()})));
        }
        if (exclusionPaths != null) {
            iClasspathEntryArray = exclusionPaths;
            n = exclusionPaths.length;
            n2 = 0;
            while (n2 < n) {
                IClasspathEntry exclusion = iClasspathEntryArray[n2];
                if (sourcePath.isPrefixOf((IPath)exclusion) && !sourcePath.equals((Object)exclusion)) {
                    exclusionPatterns.add(exclusion.makeRelativeTo(sourcePath).addTrailingSeparator());
                }
                ++n2;
            }
        }
        IClasspathEntry[] newEntries = new IClasspathEntry[existingEntries.length + 1];
        System.arraycopy(existingEntries, 0, newEntries, 0, existingEntries.length);
        newEntries[newEntries.length - 1] = JavaCore.newSourceEntry((IPath)sourcePath, (IPath[])exclusionPatterns.toArray(new IPath[0]));
        project.setRawClasspath(newEntries, project.getOutputLocation(), null);
        return true;
    }

    public static boolean removeSourcePath(IPath sourcePath, IJavaProject project) throws JavaModelException {
        IClasspathEntry[] existingEntries = project.getRawClasspath();
        ArrayList<IClasspathEntry> newEntries = new ArrayList<IClasspathEntry>();
        boolean found = false;
        IClasspathEntry[] iClasspathEntryArray = existingEntries;
        int n = existingEntries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 3) {
                if (entry.getPath().equals((Object)sourcePath)) {
                    found = true;
                } else {
                    newEntries.add(ProjectUtils.removeFilters(entry, sourcePath));
                }
            } else {
                newEntries.add(entry);
            }
            ++n2;
        }
        if (found) {
            project.setRawClasspath(newEntries.toArray(new IClasspathEntry[0]), project.getOutputLocation(), null);
            return true;
        }
        return false;
    }

    public static IPath[] listSourcePaths(IJavaProject project) throws JavaModelException {
        ArrayList<IPath> result = new ArrayList<IPath>();
        IClasspathEntry[] iClasspathEntryArray = project.getRawClasspath();
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 3) {
                result.add(entry.getPath());
            }
            ++n2;
        }
        return result.toArray(new IPath[0]);
    }

    public static boolean isOnSourcePath(IPath sourcePath, IJavaProject project) throws JavaModelException {
        IClasspathEntry[] iClasspathEntryArray = project.getRawClasspath();
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 3 && entry.getPath().equals((Object)sourcePath)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static IPath findBelongedWorkspaceRoot(IPath filePath) {
        PreferenceManager manager = JavaLanguageServerPlugin.getPreferencesManager();
        Collection<IPath> rootPaths = manager.getPreferences().getRootPaths();
        if (rootPaths != null) {
            for (IPath rootPath : rootPaths) {
                if (!rootPath.isPrefixOf(filePath)) continue;
                return rootPath;
            }
        }
        return null;
    }

    public static String getWorkspaceInvisibleProjectName(IPath workspacePath) {
        String fileName = workspacePath.toFile().getName();
        String projectName = String.valueOf(fileName) + WORKSPACE_LINK + Integer.toHexString(workspacePath.toPortableString().hashCode());
        return projectName;
    }

    public static boolean isVisibleProject(IProject project) {
        PreferenceManager manager = JavaLanguageServerPlugin.getPreferencesManager();
        Collection<IPath> rootPaths = manager.getPreferences().getRootPaths();
        if (rootPaths == null) {
            return false;
        }
        return ResourceUtils.isContainedIn(project.getLocation(), rootPaths);
    }

    public static List<IProject> getVisibleProjects(IPath workspaceRoot) {
        ArrayList<IProject> projects = new ArrayList<IProject>();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.exists() && ProjectUtils.isVisibleProject(project) && workspaceRoot.isPrefixOf(project.getLocation())) {
                projects.add(project);
            }
            ++n2;
        }
        return projects;
    }

    public static IProject createInvisibleProjectIfNotExist(IPath workspaceRoot) throws OperationCanceledException, CoreException {
        String invisibleProjectName = ProjectUtils.getWorkspaceInvisibleProjectName(workspaceRoot);
        IProject invisibleProject = ResourcesPlugin.getWorkspace().getRoot().getProject(invisibleProjectName);
        if (!invisibleProject.exists()) {
            JavaLanguageServerPlugin.getProjectsManager().createJavaProject(invisibleProject, null, null, "bin", null);
            IFolder workspaceLinkFolder = invisibleProject.getFolder(WORKSPACE_LINK);
            if (!workspaceLinkFolder.isLinked()) {
                try {
                    JDTUtils.createFolders(workspaceLinkFolder.getParent(), null);
                    workspaceLinkFolder.createLink(workspaceRoot.toFile().toURI(), 256, null);
                }
                catch (CoreException e) {
                    invisibleProject.delete(true, null);
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.ls.core", Messages.format("Failed to create linked resource from ''{0}'' to the invisible project ''{1}''.", new String[]{workspaceRoot.toString(), invisibleProjectName}), (Throwable)e));
                }
            }
        }
        return invisibleProject;
    }

    private static IClasspathEntry removeFilters(IClasspathEntry entry, IPath path) {
        IPath[] inclusionPatterns = entry.getInclusionPatterns();
        ArrayList<IPath> inclusionList = new ArrayList<IPath>();
        if (inclusionPatterns != null) {
            IPath[] iPathArray = inclusionPatterns;
            int n = inclusionPatterns.length;
            int n2 = 0;
            while (n2 < n) {
                IPath pattern = iPathArray[n2];
                if (!path.equals((Object)entry.getPath().append(pattern))) {
                    inclusionList.add(pattern);
                }
                ++n2;
            }
        }
        IPath[] exclusionPatterns = entry.getExclusionPatterns();
        ArrayList<IPath> exclusionList = new ArrayList<IPath>();
        if (exclusionPatterns != null) {
            IPath[] iPathArray = exclusionPatterns;
            int n = exclusionPatterns.length;
            int n3 = 0;
            while (n3 < n) {
                IPath pattern = iPathArray[n3];
                if (!path.equals((Object)entry.getPath().append(pattern))) {
                    exclusionList.add(pattern);
                }
                ++n3;
            }
        }
        if (!(inclusionPatterns != null && inclusionPatterns.length != inclusionList.size() || exclusionPatterns != null && exclusionPatterns.length != exclusionList.size())) {
            return entry;
        }
        return JavaCore.newSourceEntry((IPath)entry.getPath(), (IPath[])inclusionList.toArray(new IPath[0]), (IPath[])exclusionList.toArray(new IPath[0]), (IPath)entry.getOutputLocation(), (IClasspathAttribute[])entry.getExtraAttributes());
    }

    public static void updateBinaries(IJavaProject javaProject, IPath libFolderPath, IProgressMonitor monitor) throws CoreException {
        ProjectUtils.updateBinaries(javaProject, Collections.singleton(libFolderPath), monitor);
    }

    public static void updateBinaries(IJavaProject javaProject, Set<IPath> libFolderPaths, IProgressMonitor monitor) throws CoreException {
        Set<java.nio.file.Path> binaries = ProjectUtils.collectBinaries(libFolderPaths, monitor);
        if (monitor.isCanceled()) {
            return;
        }
        Object[] rawClasspath = javaProject.getRawClasspath();
        List newEntries = Arrays.stream(rawClasspath).filter(cpe -> cpe.getEntryKind() != 1).collect(Collectors.toCollection(ArrayList::new));
        for (java.nio.file.Path file : binaries) {
            if (monitor.isCanceled()) {
                return;
            }
            Path newLibPath = new Path(file.toString());
            IPath sourcePath = ProjectUtils.detectSources(file);
            IClasspathEntry newEntry = JavaCore.newLibraryEntry((IPath)newLibPath, (IPath)sourcePath, null);
            JavaLanguageServerPlugin.logInfo("Adding " + newLibPath + " to the classpath");
            newEntries.add(newEntry);
        }
        Object[] newClasspath = newEntries.toArray(new IClasspathEntry[newEntries.size()]);
        if (!Arrays.equals(rawClasspath, newClasspath)) {
            javaProject.setRawClasspath((IClasspathEntry[])newClasspath, monitor);
        }
    }

    private static Set<java.nio.file.Path> collectBinaries(Set<IPath> libFolderPaths, final IProgressMonitor monitor) throws CoreException {
        final LinkedHashSet<java.nio.file.Path> binaries = new LinkedHashSet<java.nio.file.Path>();
        SimpleFileVisitor<java.nio.file.Path> jarDetector = new SimpleFileVisitor<java.nio.file.Path>(){

            @Override
            public FileVisitResult visitFile(java.nio.file.Path file, BasicFileAttributes attrs) throws IOException {
                if (monitor.isCanceled()) {
                    return FileVisitResult.TERMINATE;
                }
                if (ProjectUtils.isBinary(file)) {
                    binaries.add(file);
                }
                return FileVisitResult.CONTINUE;
            }
        };
        for (IPath libFolderPath : libFolderPaths) {
            String path = libFolderPath.toOSString();
            try {
                java.nio.file.Path libFolder = Paths.get(path, new String[0]);
                if (!Files.isDirectory(libFolder, new LinkOption[0])) continue;
                Files.walkFileTree(Paths.get(path, new String[0]), (FileVisitor<? super java.nio.file.Path>)jarDetector);
            }
            catch (IOException e) {
                throw new CoreException(StatusFactory.newErrorStatus("Unable to analyze " + path, e));
            }
        }
        return binaries;
    }

    private static boolean isBinary(java.nio.file.Path file) {
        String fileName = file.getFileName().toString();
        return fileName.endsWith(JAR_SUFFIX) && !fileName.endsWith(SOURCE_JAR_SUFFIX);
    }

    private static IPath detectSources(java.nio.file.Path file) {
        String filename = file.getFileName().toString();
        String sourceName = String.valueOf(filename.substring(0, filename.lastIndexOf(JAR_SUFFIX))) + SOURCE_JAR_SUFFIX;
        java.nio.file.Path sourcePath = file.getParent().resolve(sourceName);
        return Files.isRegularFile(sourcePath, new LinkOption[0]) ? new Path(sourcePath.toString()) : null;
    }
}

