/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.Channels;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.internal.net.ProxySelector;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.manipulation.JavaManipulation;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationPlugin;
import org.eclipse.jdt.internal.core.manipulation.MembersOrderPreferenceCacheCommon;
import org.eclipse.jdt.ls.core.internal.ConnectionStreamFactory;
import org.eclipse.jdt.ls.core.internal.JDTEnvironmentUtils;
import org.eclipse.jdt.ls.core.internal.JavaClientConnection;
import org.eclipse.jdt.ls.core.internal.LanguageServer;
import org.eclipse.jdt.ls.core.internal.ParentProcessWatcher;
import org.eclipse.jdt.ls.core.internal.ServiceStatus;
import org.eclipse.jdt.ls.core.internal.handlers.JDTLanguageServer;
import org.eclipse.jdt.ls.core.internal.managers.ContentProviderManager;
import org.eclipse.jdt.ls.core.internal.managers.DigestStore;
import org.eclipse.jdt.ls.core.internal.managers.ProjectsManager;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.jsonrpc.MessageConsumer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.util.tracker.ServiceTracker;

public class JavaLanguageServerPlugin
extends Plugin {
    private static final String JDT_UI_PLUGIN = "org.eclipse.jdt.ui";
    public static final String MANUAL = "Manual";
    public static final String HTTP_NON_PROXY_HOSTS = "http.nonProxyHosts";
    public static final String HTTPS_NON_PROXY_HOSTS = "https.nonProxyHosts";
    public static final String HTTPS_PROXY_PASSWORD = "https.proxyPassword";
    public static final String HTTPS_PROXY_PORT = "https.proxyPort";
    public static final String HTTPS_PROXY_HOST = "https.proxyHost";
    public static final String HTTP_PROXY_PASSWORD = "http.proxyPassword";
    public static final String HTTP_PROXY_PORT = "http.proxyPort";
    public static final String HTTP_PROXY_HOST = "http.proxyHost";
    public static final String HTTPS_PROXY_USER = "https.proxyUser";
    public static final String HTTP_PROXY_USER = "http.proxyUser";
    public static final String SERVER_SOURCE_ID = "Java";
    @Deprecated
    public static final String PLUGIN_ID = "org.eclipse.jdt.ls.core";
    public static final String DEFAULT_MEMBER_SORT_ORDER = "T,SF,SI,SM,F,I,C,M";
    private static JavaLanguageServerPlugin pluginInstance;
    private static BundleContext context;
    private ServiceTracker<IProxyService, IProxyService> proxyServiceTracker = null;
    private static InputStream in;
    private static PrintStream out;
    private static PrintStream err;
    private LanguageServer languageServer;
    private ProjectsManager projectsManager;
    private DigestStore digestStore;
    private ContentProviderManager contentProviderManager;
    private JDTLanguageServer protocol;
    private PreferenceManager preferenceManager;

    public static LanguageServer getLanguageServer() {
        return pluginInstance == null ? null : JavaLanguageServerPlugin.pluginInstance.languageServer;
    }

    public static BundleContext getBundleContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        try {
            Platform.getBundle((String)"org.eclipse.core.resources").start(1);
        }
        catch (BundleException e) {
            JavaLanguageServerPlugin.logException(e.getMessage(), e);
        }
        try {
            JavaLanguageServerPlugin.redirectStandardStreams();
        }
        catch (FileNotFoundException e) {
            JavaLanguageServerPlugin.logException(e.getMessage(), e);
        }
        context = bundleContext;
        pluginInstance = this;
        this.setPreferenceNodeId();
        this.preferenceManager = new PreferenceManager();
        this.digestStore = new DigestStore(this.getStateLocation().toFile());
        this.projectsManager = new ProjectsManager(this.preferenceManager);
        try {
            ResourcesPlugin.getWorkspace().addSaveParticipant(PLUGIN_ID, (ISaveParticipant)this.projectsManager);
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException(e.getMessage(), e);
        }
        this.contentProviderManager = new ContentProviderManager(this.preferenceManager);
        JavaLanguageServerPlugin.logInfo(((Object)((Object)this)).getClass() + " is started");
        this.configureProxy();
    }

    private void setPreferenceNodeId() {
        Bundle bundle = Platform.getBundle((String)JDT_UI_PLUGIN);
        if (bundle != null && bundle.getState() != 32) {
            try {
                bundle.start();
            }
            catch (BundleException e) {
                JavaLanguageServerPlugin.logException(e.getMessage(), e);
            }
        }
        JavaManipulation.setPreferenceNodeId(null);
        JavaManipulation.setPreferenceNodeId((String)PLUGIN_ID);
        IEclipsePreferences fDefaultPreferenceStore = DefaultScope.INSTANCE.getNode(JavaManipulation.getPreferenceNodeId());
        fDefaultPreferenceStore.put("outlinesortoption", DEFAULT_MEMBER_SORT_ORDER);
        MembersOrderPreferenceCacheCommon preferenceCache = JavaManipulationPlugin.getDefault().getMembersOrderPreferenceCacheCommon();
        preferenceCache.install();
    }

    private void configureProxy() {
        String httpHost = System.getProperty(HTTP_PROXY_HOST);
        String httpPort = System.getProperty(HTTP_PROXY_PORT);
        final String httpUser = System.getProperty(HTTP_PROXY_USER);
        final String httpPassword = System.getProperty(HTTP_PROXY_PASSWORD);
        String httpsHost = System.getProperty(HTTPS_PROXY_HOST);
        String httpsPort = System.getProperty(HTTPS_PROXY_PORT);
        String httpsUser = System.getProperty(HTTPS_PROXY_USER);
        String httpsPassword = System.getProperty(HTTPS_PROXY_PASSWORD);
        String httpsNonProxyHosts = System.getProperty(HTTPS_NON_PROXY_HOSTS);
        String httpNonProxyHosts = System.getProperty(HTTP_NON_PROXY_HOSTS);
        if (StringUtils.isNotBlank((CharSequence)httpUser) || StringUtils.isNotBlank((CharSequence)httpsUser)) {
            IProxyService proxyService;
            try {
                Platform.getBundle((String)"org.eclipse.core.net").start(1);
            }
            catch (BundleException e) {
                JavaLanguageServerPlugin.logException(e.getMessage(), e);
            }
            if (StringUtils.isNotBlank((CharSequence)httpUser) && StringUtils.isNotBlank((CharSequence)httpPassword)) {
                Authenticator.setDefault(new Authenticator(){

                    @Override
                    public PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(httpUser, httpPassword.toCharArray());
                    }
                });
            }
            if ((proxyService = this.getProxyService()) != null) {
                IProxyData[] proxies;
                ProxySelector.setActiveProvider((String)MANUAL);
                IProxyData[] iProxyDataArray = proxies = proxyService.getProxyData();
                int n = proxies.length;
                int n2 = 0;
                while (n2 < n) {
                    IProxyData proxy = iProxyDataArray[n2];
                    if ("HTTP".equals(proxy.getType())) {
                        proxy.setHost(httpHost);
                        proxy.setPort(httpPort == null ? -1 : Integer.valueOf(httpPort));
                        proxy.setPassword(httpPassword);
                        proxy.setUserid(httpUser);
                    }
                    if ("HTTPS".equals(proxy.getType())) {
                        proxy.setHost(httpsHost);
                        proxy.setPort(httpsPort == null ? -1 : Integer.valueOf(httpsPort));
                        proxy.setPassword(httpsPassword);
                        proxy.setUserid(httpsUser);
                    }
                    ++n2;
                }
                try {
                    proxyService.setProxyData(proxies);
                    if (httpHost != null) {
                        System.setProperty(HTTP_PROXY_HOST, httpHost);
                    }
                    if (httpPort != null) {
                        System.setProperty(HTTP_PROXY_PORT, httpPort);
                    }
                    if (httpUser != null) {
                        System.setProperty(HTTP_PROXY_USER, httpUser);
                    }
                    if (httpPassword != null) {
                        System.setProperty(HTTP_PROXY_PASSWORD, httpPassword);
                    }
                    if (httpsHost != null) {
                        System.setProperty(HTTPS_PROXY_HOST, httpsHost);
                    }
                    if (httpsPort != null) {
                        System.setProperty(HTTPS_PROXY_PORT, httpsPort);
                    }
                    if (httpsUser != null) {
                        System.setProperty(HTTPS_PROXY_USER, httpsUser);
                    }
                    if (httpsPassword != null) {
                        System.setProperty(HTTPS_PROXY_PASSWORD, httpsPassword);
                    }
                    if (httpsNonProxyHosts != null) {
                        System.setProperty(HTTPS_NON_PROXY_HOSTS, httpsNonProxyHosts);
                    }
                    if (httpNonProxyHosts != null) {
                        System.setProperty(HTTP_NON_PROXY_HOSTS, httpNonProxyHosts);
                    }
                }
                catch (CoreException e) {
                    JavaLanguageServerPlugin.logException(e.getMessage(), e);
                }
            }
        }
    }

    public IProxyService getProxyService() {
        try {
            if (this.proxyServiceTracker == null) {
                this.proxyServiceTracker = new ServiceTracker(context, IProxyService.class.getName(), null);
                this.proxyServiceTracker.open();
            }
            return (IProxyService)this.proxyServiceTracker.getService();
        }
        catch (Exception e) {
            JavaLanguageServerPlugin.logException(e.getMessage(), e);
            return null;
        }
    }

    private void startConnection() throws IOException {
        Launcher launcher;
        ExecutorService executorService = Executors.newCachedThreadPool();
        this.protocol = new JDTLanguageServer(this.projectsManager, this.preferenceManager);
        if (JDTEnvironmentUtils.inSocketStreamDebugMode()) {
            String host = JDTEnvironmentUtils.getClientHost();
            Integer port = JDTEnvironmentUtils.getClientPort();
            InetSocketAddress inetSocketAddress = new InetSocketAddress(host, (int)port);
            AsynchronousServerSocketChannel serverSocket = AsynchronousServerSocketChannel.open().bind(inetSocketAddress);
            try {
                AsynchronousSocketChannel socketChannel = serverSocket.accept().get();
                InputStream in = Channels.newInputStream(socketChannel);
                OutputStream out = Channels.newOutputStream(socketChannel);
                Function<MessageConsumer, MessageConsumer> messageConsumer = it -> it;
                launcher = Launcher.createIoLauncher((Object)this.protocol, JavaClientConnection.JavaLanguageClient.class, (InputStream)in, (OutputStream)out, (ExecutorService)executorService, messageConsumer);
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException("Error when opening a socket channel at " + host + ":" + port + ".", e);
            }
        } else {
            ConnectionStreamFactory connectionFactory = new ConnectionStreamFactory();
            InputStream in = connectionFactory.getInputStream();
            OutputStream out = connectionFactory.getOutputStream();
            ParentProcessWatcher wrapper = "false".equals(System.getProperty("watchParentProcess")) ? it -> it : new ParentProcessWatcher(this.languageServer);
            launcher = Launcher.createLauncher((Object)this.protocol, JavaClientConnection.JavaLanguageClient.class, (InputStream)in, (OutputStream)out, (ExecutorService)executorService, (Function)wrapper);
        }
        this.protocol.connectClient((JavaClientConnection.JavaLanguageClient)launcher.getRemoteProxy());
        launcher.startListening();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        JavaLanguageServerPlugin.logInfo(((Object)((Object)this)).getClass() + " is stopping:");
        pluginInstance = null;
        context = null;
        ResourcesPlugin.getWorkspace().removeSaveParticipant(PLUGIN_ID);
        this.projectsManager = null;
        this.contentProviderManager = null;
        this.languageServer = null;
    }

    public WorkingCopyOwner getWorkingCopyOwner() {
        return this.protocol.getWorkingCopyOwner();
    }

    public static JavaLanguageServerPlugin getInstance() {
        return pluginInstance;
    }

    public static void log(IStatus status) {
        if (context != null) {
            Platform.getLog((Bundle)context.getBundle()).log(status);
        }
    }

    public static void log(CoreException e) {
        JavaLanguageServerPlugin.log(e.getStatus());
    }

    public static void logError(String message) {
        if (context != null) {
            JavaLanguageServerPlugin.log((IStatus)new Status(4, context.getBundle().getSymbolicName(), message));
        }
    }

    public static void logInfo(String message) {
        if (context != null) {
            JavaLanguageServerPlugin.log((IStatus)new Status(1, context.getBundle().getSymbolicName(), message));
        }
    }

    public static void logException(String message, Throwable ex) {
        if (context != null) {
            JavaLanguageServerPlugin.log((IStatus)new Status(4, context.getBundle().getSymbolicName(), message, ex));
        }
    }

    public static void sendStatus(ServiceStatus serverStatus, String status) {
        if (pluginInstance != null && JavaLanguageServerPlugin.pluginInstance.protocol != null) {
            JavaLanguageServerPlugin.pluginInstance.protocol.sendStatus(serverStatus, status);
        }
    }

    static void startLanguageServer(LanguageServer newLanguageServer) throws IOException {
        if (pluginInstance != null) {
            JavaLanguageServerPlugin.pluginInstance.languageServer = newLanguageServer;
            pluginInstance.startConnection();
        }
    }

    public static ProjectsManager getProjectsManager() {
        return JavaLanguageServerPlugin.pluginInstance.projectsManager;
    }

    public static DigestStore getDigestStore() {
        return JavaLanguageServerPlugin.pluginInstance.digestStore;
    }

    public static ContentProviderManager getContentProviderManager() {
        return JavaLanguageServerPlugin.pluginInstance.contentProviderManager;
    }

    public static String getVersion() {
        return context == null ? "Unknown" : context.getBundle().getVersion().toString();
    }

    private static void redirectStandardStreams() throws FileNotFoundException {
        in = System.in;
        out = System.out;
        err = System.err;
        System.setIn(new ByteArrayInputStream(new byte[0]));
        boolean isDebug = Boolean.getBoolean("jdt.ls.debug");
        if (isDebug) {
            String id = "jdt.ls-" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            File workspaceFile = root.getRawLocation().makeAbsolute().toFile();
            File rootFile = new File(workspaceFile, ".metadata");
            rootFile.mkdirs();
            File outFile = new File(rootFile, ".out-" + id + ".log");
            FileOutputStream stdFileOut = new FileOutputStream(outFile);
            System.setOut(new PrintStream(stdFileOut));
            File errFile = new File(rootFile, ".error-" + id + ".log");
            FileOutputStream stdFileErr = new FileOutputStream(errFile);
            System.setErr(new PrintStream(stdFileErr));
        } else {
            System.setOut(new PrintStream(new ByteArrayOutputStream()));
            System.setErr(new PrintStream(new ByteArrayOutputStream()));
        }
    }

    public static InputStream getIn() {
        return in;
    }

    public static PrintStream getOut() {
        return out;
    }

    public static PrintStream getErr() {
        return err;
    }

    public static PreferenceManager getPreferencesManager() {
        if (pluginInstance != null) {
            return JavaLanguageServerPlugin.pluginInstance.preferenceManager;
        }
        return null;
    }

    public void unregisterCapability(String id, String method) {
        if (this.protocol != null) {
            this.protocol.unregisterCapability(id, method);
        }
    }

    public void registerCapability(String id, String method) {
        this.registerCapability(id, method, null);
    }

    public void registerCapability(String id, String method, Object options) {
        if (this.protocol != null) {
            this.protocol.registerCapability(id, method, options);
        }
    }

    public void setProtocol(JDTLanguageServer protocol) {
        this.protocol = protocol;
    }

    public JDTLanguageServer getProtocol() {
        return this.protocol;
    }

    public JavaClientConnection getClientConnection() {
        if (this.protocol != null) {
            return this.protocol.getClientConnection();
        }
        return null;
    }

    public static void setPreferencesManager(PreferenceManager preferenceManager) {
        if (pluginInstance != null) {
            JavaLanguageServerPlugin.pluginInstance.preferenceManager = preferenceManager;
        }
    }
}

