/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal;

import com.google.common.base.Charsets;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.core.internal.utils.FileUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMemberValuePairBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.manipulation.SharedASTProviderCore;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.template.java.SignatureUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.launching.environments.IExecutionEnvironmentsManager;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.ls.core.internal.handlers.JsonRpcHelpers;
import org.eclipse.jdt.ls.core.internal.hover.JavaElementLabelComposer;
import org.eclipse.jdt.ls.core.internal.hover.JavaElementLabels;
import org.eclipse.jdt.ls.core.internal.javadoc.JavaElementLinks;
import org.eclipse.jdt.ls.core.internal.managers.ContentProviderManager;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IRegion;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;

public final class JDTUtils {
    public static final String PATH_SEPARATOR = "/";
    public static final String PERIOD = ".";
    public static final String SRC = "src";
    private static final String JDT_SCHEME = "jdt";
    private static Set<String> SILENCED_CODEGENS = Collections.singleton("lombok");

    private JDTUtils() {
    }

    public static ICompilationUnit resolveCompilationUnit(String uriString) {
        return JDTUtils.resolveCompilationUnit(JDTUtils.toURI(uriString));
    }

    public static ICompilationUnit resolveCompilationUnit(URI uri) {
        if (uri == null || JDT_SCHEME.equals(uri.getScheme()) || !uri.isAbsolute()) {
            return null;
        }
        IFile resource = (IFile)JDTUtils.findResource(uri, arg_0 -> ((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).findFilesForLocationURI(arg_0));
        if (resource != null) {
            String name;
            if (!ProjectUtils.isJavaProject(resource.getProject())) {
                return null;
            }
            if (resource.getFileExtension() != null && Util.isJavaLikeFileName((String)(name = resource.getName()))) {
                return JavaCore.createCompilationUnitFrom((IFile)resource);
            }
            return null;
        }
        return JDTUtils.getFakeCompilationUnit(uri, (IProgressMonitor)new NullProgressMonitor());
    }

    public static IPackageFragment resolvePackage(String uriString) {
        return JDTUtils.resolvePackage(JDTUtils.toURI(uriString));
    }

    public static IPackageFragment resolvePackage(URI uri) {
        if (uri == null || JDT_SCHEME.equals(uri.getScheme()) || !uri.isAbsolute()) {
            return null;
        }
        IFolder resource = (IFolder)JDTUtils.findResource(uri, arg_0 -> ((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).findContainersForLocationURI(arg_0));
        if (resource != null) {
            if (!ProjectUtils.isJavaProject(resource.getProject())) {
                return null;
            }
            IJavaElement element = JavaCore.create((IFolder)resource);
            if (element instanceof IPackageFragment) {
                return (IPackageFragment)element;
            }
        }
        return null;
    }

    static ICompilationUnit getFakeCompilationUnit(URI uri, IProgressMonitor monitor) {
        if (uri == null || !"file".equals(uri.getScheme()) || !uri.getPath().endsWith(".java")) {
            return null;
        }
        java.nio.file.Path path = Paths.get(uri);
        if (!Files.isReadable(path)) {
            return null;
        }
        IProject project = JavaLanguageServerPlugin.getProjectsManager().getDefaultProject();
        if (project == null || !project.isAccessible()) {
            return null;
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        String packageName = JDTUtils.getPackageName(javaProject, uri);
        String fileName = path.getName(path.getNameCount() - 1).toString();
        String packagePath = packageName.replace(PERIOD, PATH_SEPARATOR);
        IPath filePath = new Path(SRC).append(packagePath).append(fileName);
        IFile file = project.getFile(filePath);
        if (!file.isLinked()) {
            try {
                JDTUtils.createFolders(file.getParent(), monitor);
                file.createLink(uri, 256, monitor);
            }
            catch (CoreException e) {
                String errMsg = "Failed to create linked resource from " + uri + " to " + project.getName();
                JavaLanguageServerPlugin.logException(errMsg, e);
            }
        }
        if (file.isLinked()) {
            return (ICompilationUnit)JavaCore.create((IResource)file, (IJavaProject)javaProject);
        }
        return null;
    }

    public static void createFolders(IContainer folder, IProgressMonitor monitor) throws CoreException {
        if (!folder.exists() && folder instanceof IFolder) {
            IContainer parent = folder.getParent();
            JDTUtils.createFolders(parent, monitor);
            folder.refreshLocal(0, monitor);
            if (!folder.exists()) {
                ((IFolder)folder).create(true, true, monitor);
            }
        }
    }

    public static String getPackageName(IJavaProject javaProject, URI uri) {
        block4: {
            try {
                File file = ResourceUtils.toFile(uri);
                String content = com.google.common.io.Files.toString((File)file, (Charset)Charsets.UTF_8);
                if (content.isEmpty() && javaProject != null && "jdt.ls-java-project".equals(javaProject.getProject().getName())) {
                    java.nio.file.Path path;
                    java.nio.file.Path parent = path = Paths.get(uri);
                    while (parent.getParent() != null && parent.getParent().getNameCount() > 0) {
                        String pathStr;
                        String name = (parent = parent.getParent()).getName(parent.getNameCount() - 1).toString();
                        if (!SRC.equals(name) || (pathStr = path.getParent().toString()).length() <= parent.toString().length()) continue;
                        pathStr = pathStr.substring(parent.toString().length() + 1);
                        pathStr = pathStr.replace(PATH_SEPARATOR, PERIOD);
                        return pathStr;
                    }
                    break block4;
                }
                return JDTUtils.getPackageName(javaProject, content);
            }
            catch (IOException e) {
                JavaLanguageServerPlugin.logException("Failed to read package name from " + uri, e);
            }
        }
        return "";
    }

    public static String getPackageName(IJavaProject javaProject, String fileContent) {
        if (fileContent == null) {
            return "";
        }
        char[] source = fileContent.toCharArray();
        ASTParser parser = ASTParser.newParser((int)12);
        parser.setProject(javaProject);
        parser.setIgnoreMethodBodies(true);
        parser.setSource(source);
        CompilationUnit ast = (CompilationUnit)parser.createAST(null);
        PackageDeclaration pkg = ast.getPackage();
        return pkg == null || pkg.getName() == null ? "" : pkg.getName().getFullyQualifiedName();
    }

    public static IClassFile resolveClassFile(String uriString) {
        return JDTUtils.resolveClassFile(JDTUtils.toURI(uriString));
    }

    public static IClassFile resolveClassFile(URI uri) {
        if (uri != null && JDT_SCHEME.equals(uri.getScheme()) && "contents".equals(uri.getAuthority())) {
            String handleId = uri.getQuery();
            IJavaElement element = JavaCore.create((String)handleId);
            IClassFile cf = (IClassFile)element.getAncestor(6);
            return cf;
        }
        return null;
    }

    public static ITypeRoot resolveTypeRoot(String uriString) {
        URI uri = JDTUtils.toURI(uriString);
        if (uri == null) {
            return null;
        }
        if (JDT_SCHEME.equals(uri.getScheme())) {
            return JDTUtils.resolveClassFile(uri);
        }
        return JDTUtils.resolveCompilationUnit(uri);
    }

    public static Location toLocation(IJavaElement element) throws JavaModelException {
        return JDTUtils.toLocation(element, LocationType.NAME_RANGE);
    }

    public static Location toLocation(IJavaElement element, LocationType type) throws JavaModelException {
        ISourceRange nameRange;
        ICompilationUnit unit = (ICompilationUnit)element.getAncestor(5);
        IClassFile cf = (IClassFile)element.getAncestor(6);
        if (unit == null && cf == null) {
            return null;
        }
        if (element instanceof ISourceReference && SourceRange.isAvailable((ISourceRange)(nameRange = type.getRange(element)))) {
            if (cf == null) {
                return JDTUtils.toLocation(unit, nameRange.getOffset(), nameRange.getLength());
            }
            return JDTUtils.toLocation(cf, nameRange.getOffset(), nameRange.getLength());
        }
        return null;
    }

    public static ISourceRange getNameRange(IJavaElement element) throws JavaModelException {
        ISourceRange nameRange = null;
        if (element instanceof IMember) {
            IMember member = (IMember)element;
            nameRange = member.getNameRange();
            if (!SourceRange.isAvailable((ISourceRange)nameRange)) {
                nameRange = member.getSourceRange();
            }
        } else if (element instanceof ITypeParameter || element instanceof ILocalVariable) {
            nameRange = ((ISourceReference)element).getNameRange();
        } else if (element instanceof ISourceReference) {
            nameRange = ((ISourceReference)element).getSourceRange();
        }
        if (!SourceRange.isAvailable((ISourceRange)nameRange) && element.getParent() != null) {
            nameRange = JDTUtils.getNameRange(element.getParent());
        }
        return nameRange;
    }

    private static ISourceRange getSourceRange(IJavaElement element) throws JavaModelException {
        ISourceRange sourceRange = null;
        if (element instanceof IMember) {
            IMember member = (IMember)element;
            sourceRange = member.getSourceRange();
        } else if (element instanceof ITypeParameter || element instanceof ILocalVariable) {
            sourceRange = ((ISourceReference)element).getSourceRange();
        } else if (element instanceof ISourceReference) {
            sourceRange = ((ISourceReference)element).getSourceRange();
        }
        if (!SourceRange.isAvailable((ISourceRange)sourceRange) && element.getParent() != null) {
            sourceRange = JDTUtils.getSourceRange(element.getParent());
        }
        return sourceRange;
    }

    public static Location toLocation(ICompilationUnit unit, int offset, int length) throws JavaModelException {
        return new Location(ResourceUtils.toClientUri(JDTUtils.toURI(unit)), JDTUtils.toRange((IOpenable)unit, offset, length));
    }

    public static Location toLocation(IClassFile classFile) throws JavaModelException {
        return JDTUtils.toLocation(classFile, 0, 0);
    }

    public static Location toLocation(String uri) {
        return new Location(ResourceUtils.toClientUri(uri), JDTUtils.newRange());
    }

    public static Location toLocation(IClassFile classFile, int offset, int length) throws JavaModelException {
        String uriString = JDTUtils.toUri(classFile);
        if (uriString != null) {
            Range range = JDTUtils.toRange((IOpenable)classFile, offset, length);
            return new Location(uriString, range);
        }
        return null;
    }

    public static String toUri(IClassFile classFile) {
        if (JavaLanguageServerPlugin.getPreferencesManager() != null && !JavaLanguageServerPlugin.getPreferencesManager().isClientSupportsClassFileContent()) {
            return null;
        }
        String packageName = classFile.getParent().getElementName();
        String jarName = classFile.getParent().getParent().getElementName();
        String uriString = null;
        try {
            uriString = new URI(JDT_SCHEME, "contents", PATH_SEPARATOR + jarName + PATH_SEPARATOR + packageName + PATH_SEPARATOR + classFile.getElementName(), classFile.getHandleIdentifier(), null).toASCIIString();
        }
        catch (URISyntaxException e) {
            JavaLanguageServerPlugin.logException("Error generating URI for class ", e);
        }
        return uriString;
    }

    public static String toUri(ITypeRoot typeRoot) {
        if (typeRoot instanceof ICompilationUnit) {
            return JDTUtils.toURI((ICompilationUnit)typeRoot);
        }
        if (typeRoot instanceof IClassFile) {
            return JDTUtils.toUri((IClassFile)typeRoot);
        }
        return null;
    }

    public static Range toRange(IOpenable openable, int offset, int length) throws JavaModelException {
        Range range = JDTUtils.newRange();
        if (offset > 0 || length > 0) {
            int[] loc = null;
            int[] endLoc = null;
            IBuffer buffer = openable.getBuffer();
            if (buffer != null) {
                loc = JsonRpcHelpers.toLine(buffer, offset);
                endLoc = JsonRpcHelpers.toLine(buffer, offset + length);
            }
            if (loc == null) {
                loc = new int[2];
            }
            if (endLoc == null) {
                endLoc = new int[2];
            }
            JDTUtils.setPosition(range.getStart(), loc);
            JDTUtils.setPosition(range.getEnd(), endLoc);
        }
        return range;
    }

    public static Range newRange() {
        return new Range(new Position(), new Position());
    }

    public static Range newLineRange(int line, int start, int end) {
        return new Range(new Position(line, start), new Position(line, end));
    }

    private static void setPosition(Position position, int[] coords) {
        assert (coords.length == 2);
        position.setLine(coords[0]);
        position.setCharacter(coords[1]);
    }

    @Deprecated
    public static String getFileURI(ICompilationUnit cu) {
        return JDTUtils.toURI(cu);
    }

    public static String toURI(ICompilationUnit cu) {
        return JDTUtils.getFileURI(cu.getResource());
    }

    public static String getFileURI(IResource resource) {
        return ResourceUtils.fixURI(resource.getRawLocationURI() == null ? resource.getLocationURI() : resource.getRawLocationURI());
    }

    public static IJavaElement findElementAtSelection(ITypeRoot unit, int line, int column, PreferenceManager preferenceManager, IProgressMonitor monitor) throws JavaModelException {
        IJavaElement[] elements = JDTUtils.findElementsAtSelection(unit, line, column, preferenceManager, monitor);
        if (elements != null && elements.length == 1) {
            return elements[0];
        }
        return null;
    }

    public static IJavaElement[] findElementsAtSelection(ITypeRoot unit, int line, int column, PreferenceManager preferenceManager, IProgressMonitor monitor) throws JavaModelException {
        block7: {
            if (unit == null) {
                return null;
            }
            int offset = JsonRpcHelpers.toOffset(unit.getBuffer(), line, column);
            if (offset > -1) {
                return unit.codeSelect(offset, 0);
            }
            if (unit instanceof IClassFile) {
                IClassFile classFile = (IClassFile)unit;
                ContentProviderManager contentProvider = JavaLanguageServerPlugin.getContentProviderManager();
                String contents = contentProvider.getSource(classFile, monitor);
                if (contents != null) {
                    String name;
                    block8: {
                        Document document = new Document(contents);
                        offset = document.getLineOffset(line) + column;
                        if (offset <= -1) break block7;
                        name = JDTUtils.parse(contents, offset);
                        if (name != null) break block8;
                        return null;
                    }
                    try {
                        SearchPattern pattern = SearchPattern.createPattern((String)name, (int)0, (int)0, (int)64);
                        IJavaSearchScope scope = JDTUtils.createSearchScope(unit.getJavaProject(), preferenceManager);
                        final ArrayList elements = new ArrayList();
                        SearchRequestor requestor = new SearchRequestor(){

                            public void acceptSearchMatch(SearchMatch match) {
                                if (match.getElement() instanceof IJavaElement) {
                                    elements.add((IJavaElement)match.getElement());
                                }
                            }
                        };
                        SearchEngine searchEngine = new SearchEngine();
                        searchEngine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, requestor, null);
                        return elements.toArray(new IJavaElement[0]);
                    }
                    catch (CoreException | BadLocationException e) {
                        JavaLanguageServerPlugin.logException(e.getMessage(), e);
                    }
                }
            }
        }
        return null;
    }

    private static String parse(String contents, int offset) {
        if (contents == null || offset < 0 || contents.length() < offset || !JDTUtils.isJavaIdentifierOrPeriod(contents.charAt(offset))) {
            return null;
        }
        int start = offset;
        while (start - 1 > -1 && JDTUtils.isJavaIdentifierOrPeriod(contents.charAt(start - 1))) {
            --start;
        }
        int end = offset;
        while (end <= contents.length() && JDTUtils.isJavaIdentifierOrPeriod(contents.charAt(end))) {
            ++end;
        }
        if (end >= start) {
            return contents.substring(start, end);
        }
        return null;
    }

    private static boolean isJavaIdentifierOrPeriod(char ch) {
        return Character.isJavaIdentifierPart(ch) || ch == '.';
    }

    public static boolean isFolder(String uriString) {
        IContainer parent;
        IFile fakeFile = JDTUtils.findFile(uriString);
        IContainer iContainer = parent = fakeFile == null ? null : fakeFile.getParent();
        if (parent == null) {
            return false;
        }
        if (!parent.isSynchronized(1)) {
            try {
                parent.refreshLocal(1, null);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return parent.findMember(fakeFile.getName()) instanceof IFolder;
    }

    public static IFile findFile(String uriString) {
        return (IFile)JDTUtils.findResource(JDTUtils.toURI(uriString), arg_0 -> ((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).findFilesForLocationURI(arg_0));
    }

    public static IContainer findFolder(String uriString) {
        return (IContainer)JDTUtils.findResource(JDTUtils.toURI(uriString), arg_0 -> ((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).findContainersForLocationURI(arg_0));
    }

    public static IResource findResource(URI uri, Function<URI, IResource[]> resourceFinder) {
        String uriString;
        int index;
        URI realUri;
        if (uri == null || !"file".equals(uri.getScheme())) {
            return null;
        }
        IResource[] resources = resourceFinder.apply(uri);
        if (resources.length == 0 && !uri.equals(realUri = FileUtil.realURI((URI)uri))) {
            uri = realUri;
            resources = resourceFinder.apply(uri);
        }
        if (resources.length == 0 && "win32".equals(Platform.getOS()) && uri.toString().startsWith("file:////") && (index = (uriString = uri.toString()).indexOf(PATH_SEPARATOR, "file:////".length())) > 0) {
            String server = uriString.substring("file:////".length(), index);
            uriString = uriString.replace(server, server.toUpperCase());
            try {
                uri = new URI(uriString);
            }
            catch (URISyntaxException e) {
                JavaLanguageServerPlugin.logException(e.getMessage(), e);
            }
            resources = resourceFinder.apply(uri);
        }
        switch (resources.length) {
            case 0: {
                return null;
            }
            case 1: {
                return resources[0];
            }
        }
        IResource resource = null;
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource f = iResourceArray[n2];
            if (JavaLanguageServerPlugin.getProjectsManager().getDefaultProject().equals((Object)f.getProject())) {
                try {
                    f.delete(true, null);
                }
                catch (CoreException e) {
                    JavaLanguageServerPlugin.logException(e.getMessage(), e);
                }
            }
            if (resource == null || f.getProjectRelativePath().segmentCount() < resource.getProjectRelativePath().segmentCount()) {
                resource = f;
            }
            ++n2;
        }
        return resource;
    }

    public static URI toURI(String uriString) {
        if (uriString == null || uriString.isEmpty()) {
            return null;
        }
        try {
            URI uri = new URI(uriString);
            if ("win32".equals(Platform.getOS()) && URIUtil.isFileURI((URI)uri)) {
                uri = URIUtil.toFile((URI)uri).toURI();
            }
            return uri;
        }
        catch (URISyntaxException e) {
            JavaLanguageServerPlugin.logException("Failed to resolve " + uriString, e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isHiddenGeneratedElement(IJavaElement element) {
        if (!(element instanceof IAnnotatable)) return false;
        try {
            IAnnotation[] annotations = ((IAnnotatable)element).getAnnotations();
            if (annotations.length == 0) return false;
            IAnnotation[] iAnnotationArray = annotations;
            int n = annotations.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IAnnotation annotation = iAnnotationArray[n2];
                if (JDTUtils.isSilencedGeneratedAnnotation(annotation)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return false;
    }

    private static boolean isSilencedGeneratedAnnotation(IAnnotation annotation) throws JavaModelException {
        if ("javax.annotation.Generated".equals(annotation.getElementName()) || "javax.annotation.processing.Generated".equals(annotation.getElementName())) {
            IMemberValuePair[] memberValuePairs;
            IMemberValuePair[] iMemberValuePairArray = memberValuePairs = annotation.getMemberValuePairs();
            int n = memberValuePairs.length;
            int n2 = 0;
            while (n2 < n) {
                IMemberValuePair m = iMemberValuePairArray[n2];
                if ("value".equals(m.getMemberName()) && 9 == m.getValueKind()) {
                    if (m.getValue() instanceof String) {
                        return SILENCED_CODEGENS.contains(m.getValue());
                    }
                    if (m.getValue() instanceof Object[]) {
                        Object[] objectArray = (Object[])m.getValue();
                        int n3 = objectArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Object val = objectArray[n4];
                            if (SILENCED_CODEGENS.contains(val)) {
                                return true;
                            }
                            ++n4;
                        }
                    }
                }
                ++n2;
            }
        }
        return false;
    }

    public static IJavaSearchScope createSearchScope(IJavaProject project, PreferenceManager preferenceManager) {
        IJavaProject[] elements = project == null ? ProjectUtils.getJavaProjects() : new IJavaProject[]{project};
        int scope = 1;
        if (preferenceManager != null && preferenceManager.isClientSupportsClassFileContent()) {
            scope |= 6;
        }
        return SearchEngine.createJavaSearchScope((IJavaElement[])elements, (int)scope);
    }

    public static boolean isOnClassPath(ICompilationUnit unit) {
        if (unit != null && unit.getJavaProject() != null && !unit.getJavaProject().getProject().equals((Object)JavaLanguageServerPlugin.getProjectsManager().getDefaultProject())) {
            return unit.getJavaProject().isOnClasspath((IJavaElement)unit);
        }
        return false;
    }

    public static boolean isDefaultProject(ICompilationUnit unit) {
        return unit != null && unit.getResource() != null && unit.getResource().getProject().equals((Object)JavaLanguageServerPlugin.getProjectsManager().getDefaultProject());
    }

    public static void setCompatibleVMs(String id) {
        IExecutionEnvironment[] environments;
        IExecutionEnvironmentsManager manager = JavaRuntime.getExecutionEnvironmentsManager();
        IExecutionEnvironment[] iExecutionEnvironmentArray = environments = manager.getExecutionEnvironments();
        int n = environments.length;
        int n2 = 0;
        while (n2 < n) {
            IVMInstall[] compatibleVMs;
            IExecutionEnvironment environment = iExecutionEnvironmentArray[n2];
            IVMInstall[] iVMInstallArray = compatibleVMs = environment.getCompatibleVMs();
            int n3 = compatibleVMs.length;
            int n4 = 0;
            while (n4 < n3) {
                IVMInstall compatibleVM = iVMInstallArray[n4];
                if (id.equals(compatibleVM.getVMInstallType().getId()) && compatibleVM.getVMInstallType().findVMInstall(compatibleVM.getId()) != null && !compatibleVM.equals(environment.getDefaultVM()) && (environment.getDefaultVM() == null || compatibleVM.getId().compareTo(environment.getDefaultVM().getId()) < 0)) {
                    environment.setDefaultVM(compatibleVM);
                }
                ++n4;
            }
            ++n2;
        }
    }

    public static IResource getFileOrFolder(String uriString) {
        IContainer parent;
        IFile file = JDTUtils.findFile(uriString);
        IContainer iContainer = parent = file == null ? null : file.getParent();
        if (parent == null) {
            return file;
        }
        try {
            parent.refreshLocal(0, null);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (parent.findMember(file.getName()) instanceof IFolder) {
            return JDTUtils.findFolder(uriString);
        }
        return file;
    }

    public static String getConstantValue(IField field, ITypeRoot typeRoot, IRegion region) {
        if (field == null || !JDTUtils.isStaticFinal(field)) {
            return null;
        }
        ASTNode node = JDTUtils.getHoveredASTNode(typeRoot, region);
        Object constantValue = node != null ? JDTUtils.getVariableBindingConstValue(node, field) : JDTUtils.computeFieldConstantFromTypeAST(field, null);
        if (constantValue == null) {
            return null;
        }
        if (constantValue instanceof String) {
            return ASTNodes.getEscapedStringLiteral((String)((String)constantValue));
        }
        if (constantValue instanceof Character) {
            return String.valueOf('\'') + constantValue.toString() + '\'';
        }
        return constantValue.toString();
    }

    public static boolean isStaticFinal(IField field) {
        try {
            return JdtFlags.isFinal((IMember)field) && JdtFlags.isStatic((IMember)field);
        }
        catch (JavaModelException e) {
            JavaLanguageServerPlugin.log((CoreException)((Object)e));
            return false;
        }
    }

    private static ASTNode getHoveredASTNode(ITypeRoot typeRoot, IRegion region) {
        if (typeRoot == null || region == null) {
            return null;
        }
        CompilationUnit unit = SharedASTProviderCore.getAST((ITypeRoot)typeRoot, (SharedASTProviderCore.WAIT_FLAG)SharedASTProviderCore.WAIT_ACTIVE_ONLY, null);
        if (unit == null) {
            return null;
        }
        return NodeFinder.perform((ASTNode)unit, (int)region.getOffset(), (int)region.getLength());
    }

    private static Object getVariableBindingConstValue(ASTNode node, IField field) {
        IVariableBinding variableBinding;
        IBinding binding;
        if (node != null && node.getNodeType() == 42 && (binding = ((SimpleName)node).resolveBinding()) != null && binding.getKind() == 3 && field.equals((variableBinding = (IVariableBinding)binding).getJavaElement())) {
            return variableBinding.getConstantValue();
        }
        return null;
    }

    public static Object computeFieldConstantFromTypeAST(IField constantField, IProgressMonitor monitor) {
        IBinding[] createBindings;
        if (monitor != null && monitor.isCanceled()) {
            return null;
        }
        CompilationUnit ast = SharedASTProviderCore.getAST((ITypeRoot)constantField.getTypeRoot(), (SharedASTProviderCore.WAIT_FLAG)SharedASTProviderCore.WAIT_NO, (IProgressMonitor)monitor);
        if (ast != null) {
            Expression initializer;
            block13: {
                VariableDeclarationFragment fieldDecl;
                block12: {
                    block11: {
                        if (!constantField.isEnumConstant()) break block11;
                        return null;
                    }
                    fieldDecl = ASTNodeSearchUtil.getFieldDeclarationFragmentNode(constantField, ast);
                    if (fieldDecl != null) break block12;
                    return null;
                }
                initializer = fieldDecl.getInitializer();
                if (initializer != null) break block13;
                return null;
            }
            try {
                return initializer.resolveConstantExpressionValue();
            }
            catch (JavaModelException fieldDecl) {
                // empty catch block
            }
        }
        if (monitor != null && monitor.isCanceled()) {
            return null;
        }
        ASTParser p = ASTParser.newParser((int)12);
        p.setProject(constantField.getJavaProject());
        try {
            createBindings = p.createBindings(new IJavaElement[]{constantField}, monitor);
        }
        catch (OperationCanceledException e) {
            return null;
        }
        IVariableBinding variableBinding = (IVariableBinding)createBindings[0];
        if (variableBinding != null) {
            return variableBinding.getConstantValue();
        }
        return null;
    }

    public static String getAnnotationMemberDefaultValue(IMethod method, ITypeRoot typeRoot, IRegion hoverRegion) throws JavaModelException {
        IMemberValuePair memberValuePair = method.getDefaultValue();
        if (memberValuePair == null) {
            return null;
        }
        Object defaultValue = memberValuePair.getValue();
        boolean isEmptyArray = defaultValue instanceof Object[] && ((Object[])defaultValue).length == 0;
        int valueKind = memberValuePair.getValueKind();
        if (valueKind == 14 && !isEmptyArray) {
            IBinding binding = JDTUtils.getHoveredNodeBinding((IJavaElement)method, typeRoot, hoverRegion);
            if (binding instanceof IMethodBinding) {
                Object value = ((IMethodBinding)binding).getDefaultValue();
                StringBuilder buf = new StringBuilder();
                try {
                    JDTUtils.addValue(buf, value, false);
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
                return buf.toString();
            }
        } else if (defaultValue != null) {
            IAnnotation parentAnnotation = (IAnnotation)method.getAncestor(16);
            StringBuilder buf = new StringBuilder();
            new JavaElementLabelComposer(buf).appendAnnotationValue(parentAnnotation, defaultValue, valueKind, JavaElementLabels.LABEL_FLAGS);
            return buf.toString();
        }
        return null;
    }

    private static void addValue(StringBuilder buf, Object value, boolean addLinks) throws URISyntaxException {
        if (value instanceof ITypeBinding) {
            ITypeBinding typeBinding = (ITypeBinding)value;
            IJavaElement type = typeBinding.getJavaElement();
            if (type == null || !addLinks) {
                buf.append(typeBinding.getName());
            } else {
                String uri = JavaElementLinks.createURI("eclipse-javadoc", type);
                String name = type.getElementName();
                JDTUtils.addLink(buf, uri, name);
            }
            buf.append(".class");
        } else if (value instanceof IVariableBinding) {
            IVariableBinding variableBinding = (IVariableBinding)value;
            IJavaElement variable = variableBinding.getJavaElement();
            if (variable == null || !addLinks) {
                buf.append(variableBinding.getName());
            } else {
                String uri = JavaElementLinks.createURI("eclipse-javadoc", variable);
                String name = variable.getElementName();
                JDTUtils.addLink(buf, uri, name);
            }
        } else if (value instanceof IAnnotationBinding) {
            IAnnotationBinding annotationBinding = (IAnnotationBinding)value;
            JDTUtils.addAnnotation(buf, annotationBinding, addLinks);
        } else if (value instanceof String) {
            buf.append(ASTNodes.getEscapedStringLiteral((String)((String)value)));
        } else if (value instanceof Character) {
            buf.append(ASTNodes.getEscapedCharacterLiteral((char)((Character)value).charValue()));
        } else if (value instanceof Object[]) {
            Object[] values = (Object[])value;
            buf.append('{');
            int i = 0;
            while (i < values.length) {
                if (i > 0) {
                    buf.append(", ");
                }
                JDTUtils.addValue(buf, values[i], addLinks);
                ++i;
            }
            buf.append('}');
        } else {
            buf.append(String.valueOf(value));
        }
    }

    private static StringBuilder addLink(StringBuilder buf, String uri, String label) {
        return buf.append(JavaElementLinks.createLink(uri, label));
    }

    private static void addAnnotation(StringBuilder buf, IAnnotationBinding annotation, boolean addLinks) throws URISyntaxException {
        IJavaElement javaElement = annotation.getAnnotationType().getJavaElement();
        buf.append('@');
        if (javaElement == null || !addLinks) {
            buf.append(annotation.getName());
        } else {
            String uri = JavaElementLinks.createURI("eclipse-javadoc", javaElement);
            JDTUtils.addLink(buf, uri, annotation.getName());
        }
        IMemberValuePairBinding[] mvPairs = annotation.getDeclaredMemberValuePairs();
        if (mvPairs.length > 0) {
            buf.append('(');
            int j = 0;
            while (j < mvPairs.length) {
                if (j > 0) {
                    buf.append(", ");
                }
                IMemberValuePairBinding mvPair = mvPairs[j];
                if (addLinks) {
                    String memberURI = JavaElementLinks.createURI("eclipse-javadoc", mvPair.getMethodBinding().getJavaElement());
                    JDTUtils.addLink(buf, memberURI, mvPair.getName());
                } else {
                    buf.append(mvPair.getName());
                }
                buf.append('=');
                JDTUtils.addValue(buf, mvPair.getValue(), addLinks);
                ++j;
            }
            buf.append(')');
        }
    }

    private static IBinding getHoveredNodeBinding(IJavaElement element, ITypeRoot typeRoot, IRegion region) {
        IBinding binding;
        if (typeRoot == null || region == null) {
            return null;
        }
        ASTNode node = JDTUtils.getHoveredASTNode(typeRoot, region);
        if (node == null) {
            ASTParser p = ASTParser.newParser((int)12);
            p.setProject(element.getJavaProject());
            p.setBindingsRecovery(true);
            try {
                binding = p.createBindings(new IJavaElement[]{element}, null)[0];
            }
            catch (OperationCanceledException e) {
                return null;
            }
        } else {
            binding = JDTUtils.resolveBinding(node);
        }
        return binding;
    }

    private static IBinding resolveBinding(ASTNode node) {
        if (node instanceof SimpleName) {
            SimpleName simpleName = (SimpleName)node;
            ASTNode normalized = ASTNodes.getNormalizedNode((ASTNode)simpleName);
            if (normalized.getLocationInParent() == ClassInstanceCreation.TYPE_PROPERTY) {
                ClassInstanceCreation cic = (ClassInstanceCreation)normalized.getParent();
                IMethodBinding constructorBinding = cic.resolveConstructorBinding();
                if (constructorBinding == null) {
                    return null;
                }
                ITypeBinding declaringClass = constructorBinding.getDeclaringClass();
                if (!declaringClass.isAnonymous()) {
                    return constructorBinding;
                }
                ITypeBinding superTypeDeclaration = declaringClass.getSuperclass().getTypeDeclaration();
                return JDTUtils.resolveSuperclassConstructor(superTypeDeclaration, constructorBinding);
            }
            return simpleName.resolveBinding();
        }
        if (node instanceof SuperConstructorInvocation) {
            return ((SuperConstructorInvocation)node).resolveConstructorBinding();
        }
        if (node instanceof ConstructorInvocation) {
            return ((ConstructorInvocation)node).resolveConstructorBinding();
        }
        if (node instanceof LambdaExpression) {
            return ((LambdaExpression)node).resolveMethodBinding();
        }
        return null;
    }

    private static IBinding resolveSuperclassConstructor(ITypeBinding superClassDeclaration, IMethodBinding constructor) {
        IMethodBinding[] methods = superClassDeclaration.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            IMethodBinding method = methods[i];
            if (method.isConstructor() && constructor.isSubsignature(method)) {
                return method;
            }
            ++i;
        }
        return null;
    }

    public static IField resolveField(CompletionProposal proposal, IJavaProject javaProject) throws JavaModelException {
        String name;
        IField field;
        char[] declarationSignature = proposal.getDeclarationSignature();
        if (declarationSignature == null) {
            return null;
        }
        String typeName = SignatureUtil.stripSignatureToFQN((String)String.valueOf(declarationSignature));
        IType type = javaProject.findType(typeName);
        if (type != null && (field = type.getField(name = String.valueOf(proposal.getName()))).exists()) {
            return field;
        }
        return null;
    }

    public static IMethod resolveMethod(CompletionProposal proposal, IJavaProject javaProject) throws JavaModelException {
        char[] declarationSignature = proposal.getDeclarationSignature();
        String typeName = SignatureUtil.stripSignatureToFQN((String)String.valueOf(declarationSignature));
        IType type = javaProject.findType(typeName);
        if (type != null) {
            String name = String.valueOf(proposal.getName());
            if (proposal.getKind() == 13) {
                IMethod method = type.getMethod(name, CharOperation.NO_STRINGS);
                if (method.exists()) {
                    return method;
                }
                return null;
            }
            String[] parameters = Signature.getParameterTypes((String)String.valueOf(SignatureUtil.fix83600((char[])proposal.getSignature())));
            int i = 0;
            while (i < parameters.length) {
                parameters[i] = SignatureUtil.getLowerBound((String)parameters[i]);
                ++i;
            }
            boolean isConstructor = proposal.isConstructor();
            return JavaModelUtil.findMethod((String)name, (String[])parameters, (boolean)isConstructor, (IType)type);
        }
        return null;
    }

    public static enum LocationType {
        NAME_RANGE{

            @Override
            ISourceRange getRange(IJavaElement element) throws JavaModelException {
                return JDTUtils.getNameRange(element);
            }
        }
        ,
        FULL_RANGE{

            @Override
            ISourceRange getRange(IJavaElement element) throws JavaModelException {
                return JDTUtils.getSourceRange(element);
            }
        };


        abstract ISourceRange getRange(IJavaElement var1) throws JavaModelException;
    }
}

