/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.quickaccess;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.quickaccess.PreviousPicksProvider;
import org.eclipse.ui.internal.quickaccess.QuickAccessEntry;
import org.eclipse.ui.internal.quickaccess.QuickAccessMatcher;
import org.eclipse.ui.internal.quickaccess.QuickAccessMessages;
import org.eclipse.ui.internal.quickaccess.QuickAccessProvider;
import org.eclipse.ui.internal.quickaccess.providers.HelpSearchProvider;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.quickaccess.QuickAccessElement;
import org.eclipse.ui.themes.ColorUtil;

public abstract class QuickAccessContents {
    private static final String QUICK_ACCESS_COMMAND_ID = "org.eclipse.ui.window.quickAccess";
    private static final int INITIAL_COUNT_PER_PROVIDER = 5;
    private static final int MAX_COUNT_TOTAL = 20;
    protected Text filterText;
    private QuickAccessProvider[] providers;
    private Map<String, QuickAccessProvider> providerMap = new HashMap<String, QuickAccessProvider>();
    private Map<QuickAccessElement, QuickAccessProvider> elementsToProviders = new HashMap<QuickAccessElement, QuickAccessProvider>();
    private Map<QuickAccessElement, QuickAccessMatcher> elementsToMatchers = new HashMap<QuickAccessElement, QuickAccessMatcher>();
    protected Table table;
    protected Label infoLabel;
    private LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());
    protected String rememberedText;
    private Color grayColor;
    private TextLayout textLayout;
    private boolean showAllMatches = false;
    protected boolean resized = false;
    private TriggerSequence keySequence;
    private Job computeProposalsJob;
    int numberOfFilteredResults;
    Pattern categoryPattern;
    Label hintText;
    private boolean displayHintText;

    public QuickAccessContents(QuickAccessProvider[] providers) {
        this.providers = providers;
    }

    private int computeNumberOfItems() {
        Rectangle rect = this.table.getClientArea();
        int itemHeight = this.table.getItemHeight();
        int headerHeight = this.table.getHeaderHeight();
        return (rect.height - headerHeight + itemHeight - 1) / (itemHeight + this.table.getGridLineWidth());
    }

    public void updateProposals(final String filter) {
        if (this.computeProposalsJob != null) {
            this.computeProposalsJob.cancel();
            this.computeProposalsJob = null;
        }
        if (this.table == null || this.table.isDisposed()) {
            return;
        }
        final Display display = this.table.getDisplay();
        final ArrayList<QuickAccessEntry> extraEntries = new ArrayList<QuickAccessEntry>();
        QuickAccessEntry helpSearchEntry = new HelpSearchProvider().makeHelpSearchEntry(filter);
        if (helpSearchEntry != null) {
            extraEntries.add(helpSearchEntry);
        }
        final QuickAccessElement perfectMatch = this.getPerfectMatch(filter);
        final String computingMessage = NLS.bind((String)QuickAccessMessages.QuickaAcessContents_computeMatchingEntries, (Object)filter);
        int maxNumberOfItemsInTable = this.computeNumberOfItems();
        final AtomicReference entries = new AtomicReference();
        final Job currentComputeEntriesJob = Job.create((String)computingMessage, theMonitor -> {
            entries.set(this.computeMatchingEntries(filter, perfectMatch, extraEntries, maxNumberOfItemsInTable, theMonitor));
            return theMonitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
        });
        currentComputeEntriesJob.setPriority(10);
        final UIJob computingFeedbackJob = new UIJob(this.table.getDisplay(), QuickAccessMessages.QuickAccessContents_computeMatchingEntries_displayFeedback_jobName){

            @Override
            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (currentComputeEntriesJob.getResult() == null && !monitor.isCanceled() && !QuickAccessContents.this.table.isDisposed()) {
                    QuickAccessContents.this.showHintText(computingMessage, QuickAccessContents.this.grayColor);
                    return Status.OK_STATUS;
                }
                return Status.CANCEL_STATUS;
            }
        };
        currentComputeEntriesJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                computingFeedbackJob.cancel();
                if (QuickAccessContents.this.computeProposalsJob == currentComputeEntriesJob && event.getResult().isOK() && !QuickAccessContents.this.table.isDisposed()) {
                    display.asyncExec(() -> {
                        computingFeedbackJob.cancel();
                        QuickAccessContents.this.refreshTable(perfectMatch, (List[])entries.get(), extraEntries, filter);
                    });
                }
            }
        });
        this.computeProposalsJob = currentComputeEntriesJob;
        currentComputeEntriesJob.schedule();
        computingFeedbackJob.schedule(200L);
    }

    protected abstract QuickAccessElement getPerfectMatch(String var1);

    protected abstract void updateFeedback(boolean var1, boolean var2);

    public void setShowAllMatches(boolean showAll) {
        if (this.showAllMatches != showAll) {
            this.showAllMatches = showAll;
            this.updateInfoLabel();
            this.updateProposals(this.filterText.getText().toLowerCase());
        }
    }

    private void updateInfoLabel() {
        if (this.infoLabel != null) {
            boolean forceHide;
            TriggerSequence sequence = this.getTriggerSequence();
            boolean bl = forceHide = this.getNumberOfFilteredResults() == 0 || this.showAllMatches && this.table.getItemCount() <= this.computeNumberOfItems();
            if (sequence == null || forceHide) {
                this.infoLabel.setText("");
            } else if (this.showAllMatches) {
                this.infoLabel.setText(NLS.bind((String)QuickAccessMessages.QuickAccessContents_PressKeyToLimitResults, (Object)sequence.format()));
            } else {
                this.infoLabel.setText(NLS.bind((String)QuickAccessMessages.QuickAccess_PressKeyToShowAllMatches, (Object)sequence.format()));
            }
            this.infoLabel.getParent().layout(true);
        }
    }

    public TriggerSequence getTriggerSequence() {
        if (this.keySequence == null) {
            IBindingService bindingService = (IBindingService)Adapters.adapt((Object)PlatformUI.getWorkbench(), IBindingService.class);
            this.keySequence = bindingService.getBestActiveBindingFor(QUICK_ACCESS_COMMAND_ID);
        }
        return this.keySequence;
    }

    public boolean getShowAllMatches() {
        return this.showAllMatches;
    }

    private void refreshTable(QuickAccessElement perfectMatch, List<QuickAccessEntry>[] entries, List<QuickAccessEntry> extraEntries, String filter) {
        int nExtraEntries;
        if (this.table.isDisposed()) {
            return;
        }
        int n = nExtraEntries = extraEntries == null ? 0 : extraEntries.size();
        if (this.table.getItemCount() > entries.length + nExtraEntries && this.table.getItemCount() - (entries.length + nExtraEntries) > 20) {
            this.table.removeAll();
        }
        TableItem[] items = this.table.getItems();
        int selectionIndex = -1;
        int index = 0;
        int i = 0;
        while (i < this.providers.length) {
            if (entries[i] != null) {
                boolean firstEntry = true;
                Iterator<QuickAccessEntry> it = entries[i].iterator();
                while (it.hasNext()) {
                    TableItem item;
                    QuickAccessEntry entry = it.next();
                    entry.firstInCategory = firstEntry;
                    firstEntry = false;
                    if (!it.hasNext()) {
                        entry.lastInCategory = true;
                    }
                    if (index < items.length) {
                        item = items[index];
                        this.table.clear(index);
                    } else {
                        item = new TableItem(this.table, 0);
                    }
                    if (perfectMatch == entry.element && selectionIndex == -1) {
                        selectionIndex = index;
                    }
                    item.setData((Object)entry);
                    item.setText(0, entry.provider.getName());
                    item.setText(1, entry.element.getLabel());
                    if (Util.isWpf()) {
                        item.setImage(1, entry.getImage(entry.element, (ResourceManager)this.resourceManager));
                    }
                    ++index;
                }
            }
            ++i;
        }
        for (QuickAccessEntry entry : extraEntries) {
            TableItem item = new TableItem(this.table, 0);
            item.setData((Object)entry);
        }
        if (index < items.length) {
            this.table.remove(index, items.length - 1);
        }
        if (selectionIndex == -1) {
            selectionIndex = 0;
        }
        if (this.table.getItemCount() > 0) {
            this.table.setSelection(selectionIndex);
            this.hideHintText();
        } else if (filter.isEmpty()) {
            this.showHintText(QuickAccessMessages.QuickAccess_StartTypingToFindMatches, this.grayColor);
        } else {
            this.showHintText(QuickAccessMessages.QuickAccessContents_NoMatchingResults, this.grayColor);
        }
        this.updateInfoLabel();
        this.updateFeedback(filter.isEmpty(), this.showAllMatches);
    }

    protected int getNumberOfFilteredResults() {
        return this.numberOfFilteredResults;
    }

    private List<QuickAccessEntry>[] computeMatchingEntries(String filter, QuickAccessElement perfectMatch, List<QuickAccessEntry> extraEntries, int maxNumberOfItemsInTable, IProgressMonitor aMonitor) {
        QuickAccessEntry entry;
        boolean done;
        if (aMonitor == null) {
            aMonitor = new NullProgressMonitor();
        }
        List[] entries = new List[this.providers.length];
        int maxCount = maxNumberOfItemsInTable - extraEntries.size();
        int[] indexPerProvider = new int[this.providers.length];
        int countPerProvider = Math.min(maxCount / 4, 5);
        int prevPick = 0;
        int countTotal = 0;
        boolean perfectMatchAdded = true;
        if (perfectMatch != null) {
            --maxCount;
            perfectMatchAdded = false;
        }
        String category = null;
        HashSet prevPickIds = new HashSet();
        do {
            done = true;
            Matcher categoryMatcher = this.getCategoryPattern().matcher(filter);
            if (categoryMatcher.matches()) {
                category = categoryMatcher.group(1);
                filter = String.valueOf(category) + " " + categoryMatcher.group(2);
            }
            final String finalFilter = filter;
            int i = 0;
            while (i < this.providers.length && (this.showAllMatches || countTotal < maxCount) && !aMonitor.isCanceled()) {
                if (aMonitor.isCanceled()) break;
                if (entries[i] == null) {
                    entries[i] = new ArrayList();
                    indexPerProvider[i] = 0;
                }
                int count = 0;
                final QuickAccessProvider provider = this.providers[i];
                boolean isPreviousPickProvider = provider instanceof PreviousPicksProvider;
                if ((category == null || category.equalsIgnoreCase(provider.getName()) || isPreviousPickProvider) && (!filter.isEmpty() || isPreviousPickProvider || this.showAllMatches)) {
                    final AtomicReference<QuickAccessElement[]> sortedElementRef = new AtomicReference<QuickAccessElement[]>();
                    if (provider.requiresUiAccess()) {
                        UIJob job = new UIJob(NLS.bind((String)QuickAccessMessages.QuickAccessContents_processingProviderInUI, (Object)provider.getName())){

                            @Override
                            public IStatus runInUIThread(IProgressMonitor monitor) {
                                sortedElementRef.set(provider.getElementsSorted(finalFilter, monitor));
                                return Status.OK_STATUS;
                            }
                        };
                        job.setPriority(10);
                        job.schedule();
                        try {
                            job.join(0L, (IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (Exception e) {
                            WorkbenchPlugin.log(e);
                        }
                    } else {
                        sortedElementRef.set(provider.getElementsSorted(filter, aMonitor));
                    }
                    QuickAccessElement[] sortedElements = (QuickAccessElement[])sortedElementRef.get();
                    if (sortedElements == null) {
                        sortedElements = new QuickAccessElement[]{};
                    }
                    if (!(provider instanceof PreviousPicksProvider)) {
                        QuickAccessElement[] quickAccessElementArray = sortedElements;
                        int n = sortedElements.length;
                        int n2 = 0;
                        while (n2 < n) {
                            QuickAccessElement element = quickAccessElementArray[n2];
                            this.elementsToProviders.put(element, provider);
                            ++n2;
                        }
                    }
                    if (isPreviousPickProvider) {
                        prevPick = sortedElements.length;
                        Stream.of(sortedElements).map(QuickAccessElement::getId).forEach(prevPickIds::add);
                    }
                    int j = indexPerProvider[i];
                    while (j < sortedElements.length && (this.showAllMatches || count < countPerProvider && countTotal < maxCount) && !aMonitor.isCanceled()) {
                        QuickAccessElement element = sortedElements[j];
                        if (!isPreviousPickProvider && prevPickIds.contains(element.getId())) {
                            ++j;
                            continue;
                        }
                        QuickAccessEntry entry2 = null;
                        if (filter.length() == 0) {
                            entry2 = i == 0 || this.showAllMatches ? new QuickAccessEntry(element, provider, new int[0][0], new int[0][0], 0) : null;
                        } else {
                            QuickAccessEntry possibleMatch = this.getMatcherFor(element).match(filter, provider);
                            if (possibleMatch != null) {
                                entry2 = possibleMatch;
                            }
                        }
                        if (entry2 != null) {
                            entries[i].add(entry2);
                            ++count;
                            ++countTotal;
                            if (i == 0 && entry2.element == perfectMatch) {
                                perfectMatchAdded = true;
                                maxCount = 20;
                            }
                        }
                        ++j;
                    }
                    indexPerProvider[i] = j;
                    if (j < sortedElements.length) {
                        done = false;
                    }
                }
                ++i;
            }
            countPerProvider = 1;
        } while ((this.showAllMatches || countTotal < maxCount) && !done && !aMonitor.isCanceled());
        if (!perfectMatchAdded && (entry = this.getMatcherFor(perfectMatch).match(filter, this.providers[0])) != null) {
            if (entries[0] == null) {
                entries[0] = new ArrayList();
                indexPerProvider[0] = 0;
            }
            entries[0].add(entry);
        }
        this.numberOfFilteredResults = countTotal - prevPick;
        if (!aMonitor.isCanceled()) {
            aMonitor.done();
        }
        return entries;
    }

    protected Pattern getCategoryPattern() {
        if (this.categoryPattern == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("^(:?");
            int i = 0;
            while (i < this.providers.length) {
                if (i != 0) {
                    sb.append("|");
                }
                sb.append(this.providers[i].getName());
                ++i;
            }
            sb.append("):\\s?(.*)");
            String regex = sb.toString();
            this.categoryPattern = Pattern.compile(regex, 2);
        }
        return this.categoryPattern;
    }

    private void doDispose() {
        if (this.textLayout != null && !this.textLayout.isDisposed()) {
            this.textLayout.dispose();
        }
        if (this.resourceManager != null) {
            this.resourceManager.dispose();
            this.resourceManager = null;
        }
    }

    protected String getId() {
        return "org.eclipse.ui.internal.QuickAccess";
    }

    protected abstract void handleElementSelected(String var1, Object var2);

    private void handleSelection() {
        QuickAccessElement selectedElement = null;
        String text = this.filterText.getText().toLowerCase();
        if (this.table.getSelectionCount() == 1) {
            QuickAccessEntry entry = (QuickAccessEntry)this.table.getSelection()[0].getData();
            QuickAccessElement quickAccessElement = selectedElement = entry == null ? null : entry.element;
        }
        if (selectedElement != null) {
            this.doClose();
            this.handleElementSelected(text, selectedElement);
        }
    }

    public void preOpen() {
        this.setShowAllMatches(false);
        this.keySequence = null;
        this.updateInfoLabel();
    }

    protected abstract void doClose();

    public void hookFilterText(Text filterText) {
        this.filterText = filterText;
        filterText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                switch (e.keyCode) {
                    case 13: 
                    case 0x1000050: {
                        QuickAccessContents.this.handleSelection();
                        break;
                    }
                    case 0x1000002: {
                        int index = QuickAccessContents.this.table.getSelectionIndex();
                        if (index == -1 || QuickAccessContents.this.table.getItemCount() <= index + 1) break;
                        QuickAccessContents.this.table.setSelection(index + 1);
                        break;
                    }
                    case 0x1000001: {
                        int index = QuickAccessContents.this.table.getSelectionIndex();
                        if (index == -1 || index < 1) break;
                        QuickAccessContents.this.table.setSelection(index - 1);
                        break;
                    }
                    case 27: {
                        QuickAccessContents.this.doClose();
                    }
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        filterText.addModifyListener(e -> {
            String text = ((Text)e.widget).getText().toLowerCase();
            this.updateProposals(text);
        });
    }

    Label createHintText(Composite composite, int defaultOrientation) {
        this.hintText = new Label(composite, 4);
        this.hintText.setOrientation(defaultOrientation);
        this.displayHintText = true;
        return this.hintText;
    }

    private void hideHintText() {
        if (this.displayHintText) {
            this.setHintTextToDisplay(false);
        }
    }

    private void showHintText(String text, Color color) {
        if (this.hintText == null || this.hintText.isDisposed()) {
            return;
        }
        this.hintText.setText(text);
        if (color != null) {
            this.hintText.setForeground(color);
        }
        if (!this.displayHintText) {
            this.setHintTextToDisplay(true);
        }
    }

    private void setHintTextToDisplay(boolean toDisplay) {
        GridData data = (GridData)this.hintText.getLayoutData();
        data.exclude = !toDisplay;
        this.hintText.setVisible(toDisplay);
        this.hintText.requestLayout();
        this.displayHintText = toDisplay;
    }

    public Table createTable(Composite composite, int defaultOrientation) {
        TextStyle boldStyle;
        composite.addDisposeListener(e -> this.doDispose());
        Composite tableComposite = new Composite(composite, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tableComposite);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableColumnLayout);
        this.table = new Table(tableComposite, 65540);
        this.textLayout = new TextLayout((Device)this.table.getDisplay());
        this.textLayout.setOrientation(defaultOrientation);
        Font boldFont = this.resourceManager.createFont(FontDescriptor.createFrom((Font)this.table.getFont()).setStyle(1));
        this.textLayout.setFont(this.table.getFont());
        this.textLayout.setText(QuickAccessMessages.QuickAccess_AvailableCategories);
        int maxProviderWidth = this.textLayout.getBounds().width;
        this.textLayout.setFont(boldFont);
        QuickAccessProvider[] quickAccessProviderArray = this.providers;
        int n = this.providers.length;
        int n2 = 0;
        while (n2 < n) {
            QuickAccessProvider provider = quickAccessProviderArray[n2];
            this.textLayout.setText(provider.getName());
            int width = this.textLayout.getBounds().width;
            if (width > maxProviderWidth) {
                maxProviderWidth = width;
            }
            ++n2;
        }
        tableColumnLayout.setColumnData((Widget)new TableColumn(this.table, 0), (ColumnLayoutData)new ColumnWeightData(0, maxProviderWidth));
        tableColumnLayout.setColumnData((Widget)new TableColumn(this.table, 0), (ColumnLayoutData)new ColumnWeightData(100, 100));
        this.table.getShell().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (!QuickAccessContents.this.showAllMatches && !QuickAccessContents.this.resized) {
                    QuickAccessContents.this.resized = true;
                    e.display.timerExec(100, () -> {
                        if (QuickAccessContents.this.table != null && !QuickAccessContents.this.table.isDisposed() && QuickAccessContents.this.filterText != null && !QuickAccessContents.this.filterText.isDisposed()) {
                            QuickAccessContents.this.updateProposals(QuickAccessContents.this.filterText.getText().toLowerCase());
                        }
                        QuickAccessContents.this.resized = false;
                    });
                }
            }
        });
        this.table.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000001 && QuickAccessContents.this.table.getSelectionIndex() == 0) {
                    QuickAccessContents.this.filterText.setFocus();
                } else if (e.character == '\u001b') {
                    QuickAccessContents.this.doClose();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (QuickAccessContents.this.table.getSelectionCount() < 1) {
                    return;
                }
                if (e.button != 1) {
                    return;
                }
                if (QuickAccessContents.this.table.equals(e.getSource())) {
                    TableItem o = QuickAccessContents.this.table.getItem(new Point(e.x, e.y));
                    TableItem selection = QuickAccessContents.this.table.getSelection()[0];
                    if (selection.equals(o)) {
                        QuickAccessContents.this.handleSelection();
                    }
                }
            }
        });
        this.table.addMouseMoveListener(new MouseMoveListener(){
            TableItem lastItem = null;

            public void mouseMove(MouseEvent e) {
                if (QuickAccessContents.this.table.equals(e.getSource())) {
                    TableItem tableItem;
                    if (this.lastItem == null ^ (tableItem = QuickAccessContents.this.table.getItem(new Point(e.x, e.y))) == null) {
                        QuickAccessContents.this.table.setCursor(tableItem == null ? null : QuickAccessContents.this.table.getDisplay().getSystemCursor(21));
                    }
                    if (tableItem != null) {
                        if (!tableItem.equals(this.lastItem)) {
                            this.lastItem = tableItem;
                            QuickAccessContents.this.table.setSelection(new TableItem[]{this.lastItem});
                        }
                    } else {
                        this.lastItem = null;
                    }
                }
            }
        });
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                QuickAccessContents.this.handleSelection();
            }
        });
        if (PlatformUI.getPreferenceStore().getBoolean("USE_COLORED_LABELS")) {
            boldStyle = new TextStyle(boldFont, null, null);
            this.grayColor = this.resourceManager.createColor(ColorUtil.blend(this.table.getBackground().getRGB(), this.table.getForeground().getRGB()));
        } else {
            boldStyle = null;
        }
        Listener listener = event -> {
            QuickAccessEntry entry = (QuickAccessEntry)event.item.getData();
            if (entry != null) {
                switch (event.type) {
                    case 41: {
                        entry.measure(event, this.textLayout, (ResourceManager)this.resourceManager, boldStyle);
                        break;
                    }
                    case 42: {
                        entry.paint(event, this.textLayout, (ResourceManager)this.resourceManager, boldStyle, this.grayColor);
                        break;
                    }
                    case 40: {
                        entry.erase(event);
                    }
                }
            }
        };
        this.table.addListener(41, listener);
        this.table.addListener(40, listener);
        this.table.addListener(42, listener);
        return this.table;
    }

    public Label createInfoLabel(Composite parent) {
        this.infoLabel = new Label(parent, 0);
        this.infoLabel.setFont(parent.getFont());
        this.infoLabel.setForeground(this.grayColor);
        this.infoLabel.setBackground(this.table.getBackground());
        GridData gd = new GridData(768);
        gd.horizontalAlignment = 131072;
        gd.grabExcessHorizontalSpace = false;
        this.infoLabel.setLayoutData((Object)gd);
        this.updateInfoLabel();
        return this.infoLabel;
    }

    QuickAccessProvider getProvider(String providerId) {
        if (this.providers == null || this.providers.length == 0) {
            return null;
        }
        if (this.providerMap == null || this.providerMap.size() != this.providers.length) {
            this.providerMap = Arrays.stream(this.providers).collect(Collectors.toMap(QuickAccessProvider::getId, Function.identity()));
        }
        return this.providerMap.get(providerId);
    }

    QuickAccessProvider getProviderFor(QuickAccessElement quickAccessElement) {
        return this.elementsToProviders.get(quickAccessElement);
    }

    private QuickAccessMatcher getMatcherFor(QuickAccessElement element) {
        if (!this.elementsToMatchers.containsKey(element)) {
            this.elementsToMatchers.put(element, new QuickAccessMatcher(element));
        }
        return this.elementsToMatchers.get(element);
    }

    void registerProviderFor(QuickAccessElement quickAccessElement, QuickAccessProvider quickAccessProvider) {
        if (quickAccessElement == null || quickAccessProvider == null) {
            return;
        }
        this.elementsToProviders.put(quickAccessElement, quickAccessProvider);
    }

    public Text getFilterText() {
        return this.filterText;
    }

    public Table getTable() {
        return this.table;
    }
}

