/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.preferences;

import java.util.Set;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.ui.internal.preferences.PropertyMapAdapter;
import org.eclipse.ui.internal.preferences.ThemeAdapter;
import org.eclipse.ui.themes.IThemeManager;

public class ThemeManagerAdapter
extends PropertyMapAdapter {
    private IThemeManager manager;
    private IPropertyChangeListener listener = event -> this.firePropertyChange(event.getProperty());

    public ThemeManagerAdapter(IThemeManager manager) {
        this.manager = manager;
    }

    @Override
    protected void attachListener() {
        this.manager.addPropertyChangeListener(this.listener);
    }

    @Override
    protected void detachListener() {
        this.manager.removePropertyChangeListener(this.listener);
    }

    @Override
    public Set keySet() {
        return ThemeAdapter.getKeySet(this.manager.getCurrentTheme());
    }

    @Override
    public Object getValue(String propertyId, Class propertyType) {
        return ThemeAdapter.getValue(this.manager.getCurrentTheme(), propertyId, propertyType);
    }

    @Override
    public boolean propertyExists(String propertyId) {
        return this.keySet().contains(propertyId);
    }

    @Override
    public void setValue(String propertyId, Object newValue) {
        throw new UnsupportedOperationException();
    }
}

