/*
 * Decompiled with CFR 0.152.
 */
package org.elastic.jdt.ls.core.internal.manifest;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.elastic.jdt.ls.core.internal.ElasticJavaLanguageServerPlugin;
import org.elastic.jdt.ls.core.internal.manifest.ArtifactResolver;
import org.elastic.jdt.ls.core.internal.manifest.model.Dependency;
import org.elastic.jdt.ls.core.internal.manifest.model.ProjectInfo;
import org.elastic.jdt.ls.core.internal.manifest.model.Repo;

public class ProjectCreator {
    private java.nio.file.Path currentDir;

    public IJavaProject createJavaProjectFromProjectInfo(java.nio.file.Path dir, String rootProjectName, ProjectInfo project, IProgressMonitor monitor) {
        try {
            IJavaProject javaProject;
            if (project.getPath().equals(":")) {
                this.currentDir = dir;
                javaProject = this.createJavaProject(rootProjectName, monitor);
            } else {
                this.currentDir = dir.resolve(project.getPath().substring(1).replaceAll(":", "/"));
                javaProject = this.createJavaProject(rootProjectName.concat(project.getPath().replaceAll(":", ".")), monitor);
            }
            List<String> sourceDirs = project.getSrcDirs();
            List<String> testSourceDirs = project.getTestSrcDirs();
            if (sourceDirs != null) {
                this.createSourceDirectories(sourceDirs, javaProject, monitor);
            }
            if (testSourceDirs != null) {
                this.createSourceDirectories(testSourceDirs, javaProject, monitor);
            }
            if (sourceDirs != null && testSourceDirs != null) {
                this.addVariableEntry(javaProject, (IPath)new Path("JRE_LIB"), (IPath)new Path("JRE_SRC"), (IPath)new Path("JRE_SRCROOT"), monitor);
            }
            if (project.isAndroid().booleanValue()) {
                this.setAndroidHome(project.getAndroidSdkVersion(), javaProject, monitor);
            }
            if (project.getDependencies() != null) {
                List<ImmutablePair<String, String>> dependencies = this.retrieveAllDeps(project.getDependencies(), project.getRepos());
                this.setClasspath(dependencies, javaProject, monitor);
            }
            javaProject.getProject().refreshLocal(2, monitor);
            return javaProject;
        }
        catch (InterruptedException | CoreException ce) {
            ElasticJavaLanguageServerPlugin.logException("Failed to create the java project depending on info " + project.toString(), ce);
            return null;
        }
    }

    private void setClasspath(List<ImmutablePair<String, String>> dependencies, IJavaProject javaProject, IProgressMonitor monitor) throws CoreException {
        if (dependencies.size() == 0) {
            return;
        }
        int i = 0;
        while (i < dependencies.size()) {
            try {
                String cp = (String)dependencies.get(i).getLeft();
                File classpathEntry = new File(cp);
                if (classpathEntry.isFile()) {
                    if (dependencies.get(i).getRight() != null) {
                        this.addLibrary(javaProject, (IPath)new Path(classpathEntry.getAbsolutePath()), (IPath)new Path(new File((String)dependencies.get(i).getRight()).getAbsolutePath()), monitor);
                    } else {
                        this.addLibrary(javaProject, (IPath)new Path(classpathEntry.getAbsolutePath()), null, monitor);
                    }
                } else {
                    this.addContainer(javaProject, (IPath)new Path(classpathEntry.getAbsolutePath()), monitor);
                }
            }
            catch (JavaModelException e) {
                ElasticJavaLanguageServerPlugin.logException("Failed to add lib " + dependencies.get(i).toString(), e);
            }
            ++i;
        }
    }

    private void setAndroidHome(String version, IJavaProject javaProject, IProgressMonitor monitor) throws JavaModelException {
        if (version == null) {
            return;
        }
        String androidHome = System.getenv("ANDROID_HOME");
        if (androidHome != null) {
            this.addVariableEntry(javaProject, (IPath)new Path(String.valueOf(androidHome) + "/platforms/" + version + "/android.jar"), (IPath)new Path(String.valueOf(androidHome) + "/sources/" + version), null, monitor);
        } else {
            ElasticJavaLanguageServerPlugin.logError("ANDROID_HOME is undefined");
        }
    }

    private List<ImmutablePair<String, String>> retrieveAllDeps(List<Dependency> deps, List<Repo> repos) throws InterruptedException {
        List<ImmutablePair<String, String>> allDepsPaths = Collections.synchronizedList(new ArrayList());
        ExecutorService pool = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() + 1);
        for (Dependency dependency : deps) {
            class DownloadDepTask
            implements Runnable {
                private Dependency dep;
                private RepositorySystem system;
                private RepositorySystemSession session;
                private ArtifactRequest artifactRequest;
                private final /* synthetic */ List val$allDepsPaths;

                DownloadDepTask(Dependency dep, List list, List list2) {
                    this.val$allDepsPaths = list2;
                    this.dep = dep;
                    this.system = ArtifactResolver.newRepositorySystem();
                    this.session = ArtifactResolver.newRepositorySystemSession(this.system);
                    this.artifactRequest = new ArtifactRequest();
                    this.artifactRequest.setRepositories(ArtifactResolver.newRepositories(this.system, this.session, list));
                }

                @Override
                public void run() {
                    File artifactFile = null;
                    if (this.dep.getPath() != null) {
                        this.val$allDepsPaths.add(ImmutablePair.of((Object)this.dep.getPath(), null));
                    } else {
                        try {
                            DefaultArtifact artifact = new DefaultArtifact(String.format("%s:%s:%s", this.dep.getGroupId(), this.dep.getArtifactId(), this.dep.getVersion()));
                            String artifactPath = this.session.getLocalRepositoryManager().getPathForLocalArtifact((Artifact)artifact);
                            artifactFile = Paths.get(ArtifactResolver.MAVEN_LOCAL, artifactPath).toFile();
                            if (!artifactFile.exists()) {
                                this.artifactRequest.setArtifact((Artifact)artifact);
                                ArtifactResult artifactResult = this.system.resolveArtifact(this.session, this.artifactRequest);
                                artifactFile = artifactResult.getArtifact().getFile();
                            }
                            if (FilenameUtils.getExtension((String)artifactFile.getName()) == "aar") {
                                ProjectCreator.this.explodeAarJarFiles(artifactFile, String.format("%s-%s-%s", this.dep.getGroupId(), this.dep.getArtifactId(), this.dep.getVersion())).forEach(this.val$allDepsPaths::add);
                            } else {
                                DefaultArtifact sourceArtifact = new DefaultArtifact(String.format("%s:%s:jar:sources:%s", this.dep.getGroupId(), this.dep.getArtifactId(), this.dep.getVersion()));
                                String sourceArtifactPath = this.session.getLocalRepositoryManager().getPathForLocalArtifact((Artifact)sourceArtifact);
                                File sourceArtifactFile = Paths.get(ArtifactResolver.MAVEN_LOCAL, sourceArtifactPath).toFile();
                                if (!sourceArtifactFile.exists()) {
                                    this.artifactRequest.setArtifact((Artifact)sourceArtifact);
                                    ArtifactResult sourceArtifactResult = this.system.resolveArtifact(this.session, this.artifactRequest);
                                    sourceArtifactFile = sourceArtifactResult.getArtifact().getFile();
                                }
                                this.val$allDepsPaths.add(ImmutablePair.of((Object)artifactFile.getPath(), (Object)sourceArtifactFile.getPath()));
                            }
                        }
                        catch (ArtifactResolutionException e) {
                            if (artifactFile != null) {
                                if (FilenameUtils.getExtension((String)artifactFile.getName()) == "aar") {
                                    ProjectCreator.this.explodeAarJarFiles(artifactFile, String.format("%s-%s-%s", this.dep.getGroupId(), this.dep.getArtifactId(), this.dep.getVersion())).forEach(this.val$allDepsPaths::add);
                                } else {
                                    this.val$allDepsPaths.add(ImmutablePair.of((Object)artifactFile.getPath(), null));
                                }
                            }
                            ElasticJavaLanguageServerPlugin.logException("Failed to resolve dependency: " + this.dep.toString(), e);
                        }
                    }
                }
            }
            pool.submit(new DownloadDepTask(dependency, repos, allDepsPaths));
        }
        pool.shutdown();
        pool.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        return allDepsPaths;
    }

    private Stream<ImmutablePair<String, String>> explodeAarJarFiles(File aarFile, String jarId) {
        File targetFolder = new File(new File(new File(this.currentDir.toAbsolutePath().toString(), "build"), "exploded-aars"), jarId);
        if (!targetFolder.exists()) {
            if (!targetFolder.mkdirs()) {
                ElasticJavaLanguageServerPlugin.logError("Cannot create folder: " + targetFolder.getAbsolutePath());
            }
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (ZipFile zipFile = new ZipFile(aarFile);){
                    zipFile.stream().forEach(f -> {
                        if (f.getName().endsWith(".jar")) {
                            String targetName = String.valueOf(jarId) + ".jar";
                            File targetFile = new File(targetFolder, targetName);
                            this.ensureParentFolderExists(targetFile);
                            int index = 1;
                            while (targetFile.exists()) {
                                targetFile = new File(targetFolder, String.format("%s_%s", ++index, targetName));
                            }
                            this.copy(zipFile, targetFile, (ZipEntry)f);
                        }
                    });
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                ElasticJavaLanguageServerPlugin.logException("Cannot explode aar: " + aarFile.getAbsolutePath(), e);
            }
        }
        List<File> files = this.listFilesTraversingFolders(targetFolder);
        return files.stream().filter(f -> f.getName().endsWith(".jar")).map(f -> ImmutablePair.of((Object)f.getPath(), null));
    }

    private List<File> listFilesTraversingFolders(File folder) {
        ArrayList<File> files = new ArrayList<File>();
        File[] children = folder.listFiles();
        if (children != null) {
            File[] fileArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                if (child.isFile()) {
                    files.add(child);
                } else if (child.isDirectory()) {
                    files.addAll(this.listFilesTraversingFolders(child));
                }
                ++n2;
            }
        }
        return files;
    }

    private void ensureParentFolderExists(File targetFile) {
        File parentFolder = targetFile.getParentFile();
        if (!parentFolder.exists() && !parentFolder.mkdirs()) {
            throw new RuntimeException("Cannot create folder: " + parentFolder.getAbsolutePath());
        }
    }

    private void copy(ZipFile zipFile, File targetFile, ZipEntry entry) {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (InputStream inputStream = zipFile.getInputStream(entry);){
                Files.copy(inputStream, targetFile.toPath(), new CopyOption[0]);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Cannot write entry to file: %s: %s", e.getMessage(), targetFile.getAbsolutePath()), e);
        }
    }

    private void createSourceDirectories(List<String> sourceDirs, IJavaProject javaProject, IProgressMonitor monitor) throws CoreException {
        int i = 0;
        while (i < sourceDirs.size()) {
            String srcDir = sourceDirs.get(i);
            if (this.currentDir.resolve(srcDir).toFile().exists()) {
                File srcDirectory = new File(srcDir);
                srcDirectory.getName();
                IPath sourcePath = javaProject.getProject().getFolder(srcDir).getFullPath();
                ProjectUtils.addSourcePath((IPath)sourcePath, (IPath[])new IPath[0], (IJavaProject)javaProject);
            }
            ++i;
        }
    }

    private IJavaProject createJavaProject(String projectName, IProgressMonitor monitor) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = root.getProject(projectName);
        IProjectDescription description = workspace.newProjectDescription(project.getName());
        description.setLocationURI(this.currentDir.toUri());
        if (!project.exists()) {
            project.create(description, monitor);
        } else {
            project.refreshLocal(2, monitor);
        }
        if (!project.isOpen()) {
            project.open(monitor);
        }
        if (!project.hasNature("org.eclipse.jdt.core.javanature")) {
            this.addNatureToProject(project, "org.eclipse.jdt.core.javanature", monitor);
        }
        IJavaProject jproject = JavaCore.create((IProject)project);
        jproject.setRawClasspath(new IClasspathEntry[0], monitor);
        return jproject;
    }

    private void addNatureToProject(IProject proj, String natureId, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = proj.getDescription();
        String[] prevNatures = description.getNatureIds();
        String[] newNatures = new String[prevNatures.length + 1];
        System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
        newNatures[prevNatures.length] = natureId;
        description.setNatureIds(newNatures);
        proj.setDescription(description, monitor);
    }

    private void addToClasspath(IJavaProject jproject, IClasspathEntry cpe, IProgressMonitor monitor) throws JavaModelException {
        IClasspathEntry[] oldEntries = jproject.getRawClasspath();
        int i = 0;
        while (i < oldEntries.length) {
            if (oldEntries[i].equals(cpe)) {
                return;
            }
            ++i;
        }
        int nEntries = oldEntries.length;
        IClasspathEntry[] newEntries = new IClasspathEntry[nEntries + 1];
        System.arraycopy(oldEntries, 0, newEntries, 0, nEntries);
        newEntries[nEntries] = cpe;
        jproject.setRawClasspath(newEntries, monitor);
    }

    private void addVariableEntry(IJavaProject jproject, IPath path, IPath sourceAttachPath, IPath sourceAttachRoot, IProgressMonitor monitor) throws JavaModelException {
        IClasspathEntry cpe = JavaCore.newVariableEntry((IPath)path, (IPath)sourceAttachPath, (IPath)sourceAttachRoot);
        this.addToClasspath(jproject, cpe, monitor);
    }

    private void addLibrary(IJavaProject jproject, IPath path, IPath sourcePath, IProgressMonitor monitor) throws JavaModelException {
        IClasspathEntry cpe = JavaCore.newLibraryEntry((IPath)path, (IPath)sourcePath, null);
        this.addToClasspath(jproject, cpe, monitor);
    }

    private void addContainer(IJavaProject jproject, IPath path, IProgressMonitor monitor) throws CoreException {
        IClasspathEntry cpe = JavaCore.newContainerEntry((IPath)path);
        this.addToClasspath(jproject, cpe, monitor);
        IProject project = jproject.getProject();
        IFolder folder = project.getFolder(path.lastSegment());
        if (!folder.exists()) {
            folder.createLink(path, 16, monitor);
        }
    }
}

