/*
 * Decompiled with CFR 0.152.
 */
package org.elastic.jdt.ls.core.internal;

import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.managers.ProjectsManager;
import org.eclipse.lsp4j.DidChangeWorkspaceFoldersParams;
import org.eclipse.lsp4j.WorkspaceFolder;

public class SynchronizedWorkspaceFolderChangeHandler {
    private ProjectsManager projectManager;
    private final CountDownLatch countDownLatch = new CountDownLatch(1);

    SynchronizedWorkspaceFolderChangeHandler(ProjectsManager projectManager) {
        this.projectManager = projectManager;
    }

    public void update(DidChangeWorkspaceFoldersParams params) {
        IPath rootPath;
        ArrayList<IPath> addedRootPaths = new ArrayList<IPath>();
        ArrayList<IPath> removedRootPaths = new ArrayList<IPath>();
        for (WorkspaceFolder folder : params.getEvent().getAdded()) {
            rootPath = ResourceUtils.filePathFromURI((String)folder.getUri());
            if (rootPath == null) continue;
            addedRootPaths.add(rootPath);
        }
        for (WorkspaceFolder folder : params.getEvent().getRemoved()) {
            rootPath = ResourceUtils.filePathFromURI((String)folder.getUri());
            if (rootPath == null) continue;
            removedRootPaths.add(rootPath);
        }
        Job job = this.projectManager.updateWorkspaceFolders(addedRootPaths, removedRootPaths);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                SynchronizedWorkspaceFolderChangeHandler.this.countDownLatch.countDown();
            }
        });
        try {
            this.countDownLatch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

