/*
 * Decompiled with CFR 0.152.
 */
package org.elastic.jdt.ls.core.internal;

import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.eclipse.core.runtime.Platform;
import org.eclipse.lsp4j.jsonrpc.MessageConsumer;
import org.elastic.jdt.ls.core.internal.ElasticJavaLanguageServerPlugin;
import org.elastic.jdt.ls.core.internal.ElasticLanguageServer;

public final class ParentProcessWatcher
implements Runnable,
Function<MessageConsumer, MessageConsumer> {
    private static final long INACTIVITY_DELAY_SECS = 30000L;
    private static final int POLL_DELAY_SECS = 2;
    private volatile long lastActivityTime;
    private final ElasticLanguageServer server;
    private ScheduledFuture<?> task;
    private ScheduledExecutorService service;

    public ParentProcessWatcher(ElasticLanguageServer server) {
        this.server = server;
        this.service = Executors.newScheduledThreadPool(1);
        this.task = this.service.scheduleWithFixedDelay(this, 2L, 2L, TimeUnit.SECONDS);
    }

    @Override
    public void run() {
        if (!this.parentProcessStillRunning()) {
            this.task.cancel(true);
            this.server.exit();
        }
    }

    private boolean parentProcessStillRunning() {
        long pid = this.server.getParentProcessId();
        if (pid == 0L || this.lastActivityTime > System.currentTimeMillis() - 30000L) {
            return true;
        }
        String command = "win32".equals(Platform.getOS()) ? "cmd /c \"tasklist /FI \"PID eq " + pid + "\" | findstr " + pid + "\"" : "ps -p " + pid;
        try {
            Process process = Runtime.getRuntime().exec(command);
            int processResult = process.waitFor();
            return processResult == 0;
        }
        catch (IOException | InterruptedException e) {
            ElasticJavaLanguageServerPlugin.logException(e.getMessage(), e);
            return true;
        }
    }

    @Override
    public MessageConsumer apply(MessageConsumer consumer) {
        return message -> {
            this.lastActivityTime = System.currentTimeMillis();
            consumer.consume(message);
        };
    }
}

